/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.HelpIapHttpClient;
import com.help.common.HelpIapMessageBuilder;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Convert;
import com.help.common.util.StringUtil;
import com.help.config.HelpCrcbIapConfig;
import com.help.crcb.hub.CrcbHubRequestInfo;
import com.help.domain.RoleInfo;
import com.help.iap.HelpIapRequestInfo;
import com.help.iap.HelpIapResponseInfo;
import com.help.storage.editable.IEditableRoleStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpIapRoleStorage
implements IEditableRoleStorage {
    Logger logger = LoggerFactory.getLogger(HelpIapRoleStorage.class);
    @Autowired
    HelpCrcbIapConfig helpCrcbIapConfig;
    @Autowired
    HelpIapHttpClient helpIapHttpClient;
    @Autowired
    HelpIapMessageBuilder helpIapMessageBuilder;

    public RoleInfo get(String roleNo) {
        List<RoleInfo> list = this.getAll(roleNo);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<RoleInfo> getAll(String ... roleNos) {
        if (roleNos == null || roleNos.length == 0) {
            return new ArrayList<RoleInfo>();
        }
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("roleNos", (Object)roleNos);
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/getRole", (CrcbHubRequestInfo)param);
        List roles = (List)result.get((Object)"pageInfoList");
        List<RoleInfo> list = roles.stream().map(p -> this.transform((Map<String, Object>)p)).collect(Collectors.toList());
        Arrays.stream(roleNos).forEach(r -> {
            if (!list.stream().anyMatch(p -> p.getRoleNo().equalsIgnoreCase((String)r))) {
                this.logger.warn("\u89d2\u8272[{}]\u5728\u5458\u5de5\u7cfb\u7edf\u4e0d\u5b58\u5728,\u5df2\u5ffd\u7565", r);
            }
        });
        return list;
    }

    public List<RoleInfo> list() {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("roleNos", (Object)new String[0]);
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/getRole", (CrcbHubRequestInfo)param);
        List roles = (List)result.get((Object)"pageInfoList");
        return roles.stream().map(p -> this.transform((Map<String, Object>)p)).collect(Collectors.toList());
    }

    public UnifyPageData<RoleInfo> searchByPage(String role, UnifyPageInfo pageInfo) {
        List<Object> list = null;
        list = StringUtil.isNotEmpty((String)role) ? this.list().stream().filter(p -> p.getRoleNo().indexOf(role) >= 0 || p.getRoleName().indexOf(role) >= 0).collect(Collectors.toList()) : this.list();
        pageInfo.setTotalCount((long)list.size());
        list = list.stream().skip((pageInfo.getPageIndex() - 1) * pageInfo.getPageSize()).limit(pageInfo.getPageIndex() * pageInfo.getPageSize()).collect(Collectors.toList());
        return new UnifyPageData(list, pageInfo);
    }

    public void add(RoleInfo roleInfo) {
        if (!"1".equalsIgnoreCase(roleInfo.getState())) {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u5458\u5de5\u7cfb\u7edf\u53ea\u5141\u8bb8\u521b\u5efa[\u542f\u7528\u4e2d]\u7684\u89d2\u8272");
        }
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("groupId", (Object)roleInfo.getRoleNo());
        param.put("groupName", (Object)roleInfo.getRoleName());
        param.put("description", (Object)roleInfo.getRemark());
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/addRole", (CrcbHubRequestInfo)param);
    }

    public void edit(RoleInfo roleInfo) {
        if (!"1".equalsIgnoreCase(roleInfo.getState())) {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u5458\u5de5\u7cfb\u7edf\u53ea\u5141\u8bb8[\u542f\u7528\u4e2d]\u7684\u89d2\u8272");
        }
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("groupId", (Object)roleInfo.getRoleNo());
        param.put("groupName", (Object)roleInfo.getRoleName());
        param.put("description", (Object)roleInfo.getRemark());
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/editRole", (CrcbHubRequestInfo)param);
    }

    public void delete(String roleNo) {
        HelpIapRequestInfo param = this.helpIapMessageBuilder.buildRequest();
        param.put("roleNo", (Object)roleNo);
        param.put("sysId", (Object)this.helpCrcbIapConfig.getSysId());
        HelpIapResponseInfo result = this.helpIapHttpClient.postGateway("/api/employee/deleteRole", (CrcbHubRequestInfo)param);
    }

    public void changeState(String roleNo, boolean enable) {
        throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u5458\u5de5\u7cfb\u7edf\u4e0d\u5141\u8bb8\u4fee\u6539\u89d2\u8272\u72b6\u6001");
    }

    private RoleInfo transform(Map<String, Object> map) {
        RoleInfo info = new RoleInfo();
        info.setRoleNo(Convert.toString((Object)map.get("groupId")));
        info.setRoleName(Convert.toString((Object)map.get("groupName")));
        info.setState("1");
        info.setRemark(Convert.toString((Object)map.get("description")));
        return info;
    }
}

