/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.HelpLocalDeptAutoConfiguration;
import com.help.HelpLocalUserAutoConfiguration;
import com.help.conditional.ConditionalOnMatchOrEmpty;
import com.help.config.HelpEmployeeCenterConfig;
import com.help.dao.PUserAffiliationMapper;
import com.help.dao.PUserMapper;
import com.help.runner.UserInitSyncRunner;
import com.help.schedule.HelpIapUserSyncSchedule;
import com.help.storage.HelpIapUserStorageProxy;
import com.help.storage.HelpLocalUserStorage;
import com.help.storage.IUserStorage;
import com.helpframework.controller.UserSyncController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnBean(value={HelpEmployeeCenterConfig.class})
@ConditionalOnProperty(prefix="help.employee", name={"enable-iap-user"})
@ConditionalOnMatchOrEmpty(value="help.employee.enable", havingValue={"true"})
@AutoConfigureBefore(value={HelpLocalUserAutoConfiguration.class, HelpLocalDeptAutoConfiguration.class})
public class HelpIapUserAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpIapUserAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={IUserStorage.class})
    public HelpIapUserStorageProxy helpIapUserStorageProxy(@Autowired PUserMapper pUserMapper, @Autowired PUserAffiliationMapper pUserAffiliationMapper) {
        HelpIapUserStorageProxy userService = new HelpIapUserStorageProxy(new HelpLocalUserStorage(false, pUserMapper, pUserAffiliationMapper));
        return userService;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapUserStorageProxy.class})
    public HelpIapUserSyncSchedule helpIapUserSyncSchedule() {
        HelpIapUserSyncSchedule schedule = new HelpIapUserSyncSchedule();
        this.logger.info("\u68c0\u6d4b\u5230[\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u6a21\u5757],\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0\u7528\u6237\u670d\u52a1,\u5458\u5de5\u7cfb\u7edf\u7528\u6237\u540c\u6b65\u670d\u52a1]");
        return schedule;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapUserStorageProxy.class})
    public UserSyncController userSyncController() {
        UserSyncController ctrl = new UserSyncController();
        return ctrl;
    }

    @Bean
    @ConditionalOnBean(value={HelpIapUserStorageProxy.class})
    @ConditionalOnMissingBean
    public UserInitSyncRunner userInitSyncRunner() {
        return new UserInitSyncRunner();
    }
}

