/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.HelpLocalDeptAutoConfiguration;
import com.help.HelpLocalOrgAutoConfiguration;
import com.help.conditional.ConditionalOnMatchOrEmpty;
import com.help.config.HelpEmployeeCenterConfig;
import com.help.dao.POrgMapper;
import com.help.dao.PUserAffiliationMapper;
import com.help.plugin.HelpIapOrgTypeDicExtension;
import com.help.runner.OrgInitSyncRunner;
import com.help.schedule.HelpIapOrgSyncSchedule;
import com.help.storage.HelpIapOrgStorageProxy;
import com.help.storage.HelpLocalOrgStorage;
import com.help.storage.IOrgStorage;
import com.helpframework.controller.OrgSyncController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnBean(value={HelpEmployeeCenterConfig.class})
@ConditionalOnProperty(prefix="help.employee", name={"enable-iap-org"})
@ConditionalOnMatchOrEmpty(value="help.employee.enable", havingValue={"true"})
@AutoConfigureBefore(value={HelpLocalOrgAutoConfiguration.class, HelpLocalDeptAutoConfiguration.class})
public class HelpIapOrgAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpIapOrgAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={IOrgStorage.class})
    public HelpIapOrgStorageProxy helpIapOrgStorageProxy(@Autowired POrgMapper pOrgMapper, @Autowired PUserAffiliationMapper pUserAffiliationMapper) {
        HelpIapOrgStorageProxy iEditableOrgService = new HelpIapOrgStorageProxy(new HelpLocalOrgStorage(false, pOrgMapper, pUserAffiliationMapper));
        return iEditableOrgService;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapOrgStorageProxy.class})
    public HelpIapOrgTypeDicExtension helpIapOrgTypeDicExtension() {
        return new HelpIapOrgTypeDicExtension();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapOrgStorageProxy.class})
    public HelpIapOrgSyncSchedule helpIapOrgSyncSchedule() {
        HelpIapOrgSyncSchedule schedule = new HelpIapOrgSyncSchedule();
        this.logger.info("\u68c0\u6d4b\u5230[\u5458\u5de5\u7cfb\u7edf\u673a\u6784\u6a21\u5757],\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0\u673a\u6784\u670d\u52a1,\u5458\u5de5\u7cfb\u7edf\u673a\u6784\u540c\u6b65\u670d\u52a1]");
        return schedule;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapOrgStorageProxy.class})
    public OrgSyncController orgSyncController() {
        OrgSyncController ctrl = new OrgSyncController();
        return ctrl;
    }

    @Bean
    @ConditionalOnBean(value={HelpIapOrgStorageProxy.class})
    @ConditionalOnMissingBean
    public OrgInitSyncRunner orgInitSyncRunner() {
        return new OrgInitSyncRunner();
    }
}

