/*
 * Decompiled with CFR 0.152.
 */
package com.help;

import com.help.HelpLocalDeptAutoConfiguration;
import com.help.conditional.ConditionalOnMatchOrEmpty;
import com.help.config.HelpEmployeeCenterConfig;
import com.help.dao.PDeptMapper;
import com.help.dao.PUserAffiliationMapper;
import com.help.runner.DeptInitSyncRunner;
import com.help.schedule.HelpIapDeptSyncSchedule;
import com.help.storage.HelpIapDeptStorageProxy;
import com.help.storage.HelpLocalDeptStorage;
import com.help.storage.IDeptStorage;
import com.helpframework.controller.DeptSyncController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnBean(value={HelpEmployeeCenterConfig.class})
@ConditionalOnProperty(prefix="help.employee", name={"enable-iap-dept"})
@ConditionalOnMatchOrEmpty(value="help.employee.enable", havingValue={"true"})
@AutoConfigureBefore(value={HelpLocalDeptAutoConfiguration.class, HelpLocalDeptAutoConfiguration.class})
public class HelpIapDeptAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpIapDeptAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={IDeptStorage.class})
    public HelpIapDeptStorageProxy helpIapDeptStorageProxy(@Autowired PDeptMapper pDeptMapper, @Autowired PUserAffiliationMapper pUserAffiliationMapper) {
        HelpIapDeptStorageProxy storage = new HelpIapDeptStorageProxy(new HelpLocalDeptStorage(false, pDeptMapper, pUserAffiliationMapper));
        return storage;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapDeptStorageProxy.class})
    public HelpIapDeptSyncSchedule helpIapDeptSyncSchedule() {
        HelpIapDeptSyncSchedule schedule = new HelpIapDeptSyncSchedule();
        this.logger.info("\u68c0\u6d4b\u5230[\u5458\u5de5\u7cfb\u7edf\u90e8\u95e8\u6a21\u5757],\u81ea\u52a8\u914d\u7f6e[HELP\u5e73\u53f0\u90e8\u95e8\u670d\u52a1,\u5458\u5de5\u7cfb\u7edf\u90e8\u95e8\u540c\u6b65\u670d\u52a1]");
        return schedule;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpIapDeptStorageProxy.class})
    public DeptSyncController deptSyncController() {
        DeptSyncController ctrl = new DeptSyncController();
        return ctrl;
    }

    @Bean
    @ConditionalOnBean(value={HelpIapDeptStorageProxy.class})
    @ConditionalOnMissingBean
    public DeptInitSyncRunner deptInitSyncRunner() {
        return new DeptInitSyncRunner();
    }
}

