/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import redis.embedded.RedisServer;
import redis.embedded.core.ExecutableProvider;

public final class RedisServerBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONF_FILENAME = "embedded-redis-server";
    private File executable;
    private ExecutableProvider provider = ExecutableProvider.newEmbeddedRedis2_8_19Provider();
    private String bindAddress = "127.0.0.1";
    private int bindPort = 6379;
    private InetSocketAddress slaveOf;
    private String redisConf;
    private StringBuilder redisConfigBuilder;

    public RedisServerBuilder executableProvider(ExecutableProvider provider) {
        this.provider = provider;
        return this;
    }

    public RedisServerBuilder bind(String bind) {
        this.bindAddress = bind;
        return this;
    }

    public RedisServerBuilder port(int port) {
        this.bindPort = port;
        return this;
    }

    public RedisServerBuilder slaveOf(String hostname, int port) {
        this.slaveOf = new InetSocketAddress(hostname, port);
        return this;
    }

    public RedisServerBuilder slaveOf(InetSocketAddress slaveOf) {
        this.slaveOf = slaveOf;
        return this;
    }

    public RedisServerBuilder configFile(String redisConf) {
        if (this.redisConfigBuilder != null) {
            throw new IllegalArgumentException("Redis configuration is already partially built using setting(String) method");
        }
        this.redisConf = redisConf;
        return this;
    }

    public RedisServerBuilder settingIf(boolean shouldSet, String configLine) {
        if (shouldSet) {
            this.setting(configLine);
        }
        return this;
    }

    public RedisServerBuilder setting(String configLine) {
        if (this.redisConf != null) {
            throw new IllegalArgumentException("Redis configuration is already set using redis conf file");
        }
        if (this.redisConfigBuilder == null) {
            this.redisConfigBuilder = new StringBuilder();
        }
        this.redisConfigBuilder.append(configLine).append(LINE_SEPARATOR);
        return this;
    }

    public RedisServer build() {
        return new RedisServer(this.bindPort, this.buildCommandArgs());
    }

    public void reset() {
        this.executable = null;
        this.redisConfigBuilder = null;
        this.slaveOf = null;
        this.redisConf = null;
    }

    public List<String> buildCommandArgs() {
        this.setting("bind " + this.bindAddress);
        this.tryResolveConfAndExec();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable.getAbsolutePath());
        if (this.redisConf != null && !this.redisConf.isEmpty()) {
            args.add(this.redisConf);
        }
        args.add("--port");
        args.add(Integer.toString(this.bindPort));
        if (this.slaveOf != null) {
            args.add("--slaveof");
            args.add(this.slaveOf.getHostName());
            args.add(Integer.toString(this.slaveOf.getPort()));
        }
        return args;
    }

    private void tryResolveConfAndExec() {
        try {
            this.resolveConfAndExec();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not build server instance", e);
        }
    }

    private void resolveConfAndExec() throws IOException {
        if (this.redisConf == null && this.redisConfigBuilder != null) {
            File redisConfigFile = File.createTempFile("embedded-redis-server_" + this.bindPort, ".conf");
            redisConfigFile.deleteOnExit();
            Files.write(redisConfigFile.toPath(), this.redisConfigBuilder.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.redisConf = redisConfigFile.getAbsolutePath();
        }
        try {
            this.executable = this.provider.get();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to resolve executable", e);
        }
    }
}

