/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.RawConnectionFactory;
import cn.beecp.RawXaConnectionFactory;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.BorrowerState;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJmxBean;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.PooledConnectionTransferPolicy;
import cn.beecp.pool.PooledConnectionValidTest;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.XaProxyConnection;
import cn.beecp.pool.XaProxyResource;
import cn.beecp.pool.XaResourceLocalImpl;
import cn.beecp.pool.atomic.AtomicIntegerFieldUpdaterImpl;
import cn.beecp.pool.atomic.AtomicReferenceFieldUpdaterImpl;
import cn.beecp.pool.exception.PoolClosedException;
import cn.beecp.pool.exception.PoolCreateFailedException;
import cn.beecp.pool.exception.PoolInternalException;
import cn.beecp.pool.exception.TestSQLFailException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastConnectionPool
extends Thread
implements ConnectionPool,
ConnectionPoolJmxBean,
PooledConnectionValidTest,
PooledConnectionTransferPolicy {
    private static final BorrowerState BOWER_NORMAL = new BorrowerState();
    private static final BorrowerState BOWER_WAITING = new BorrowerState();
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConStUpd = AtomicIntegerFieldUpdaterImpl.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowStUpd = AtomicReferenceFieldUpdaterImpl.newUpdater(Borrower.class, Object.class, "state");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> PoolStateUpd = AtomicIntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "poolState");
    private static final Logger Log = LoggerFactory.getLogger(FastConnectionPool.class);
    private String poolName;
    private String poolMode;
    private Object synLock;
    private String poolHostIP;
    private long poolThreadId;
    private String poolThreadName;
    private int poolMaxSize;
    private volatile int poolState;
    private boolean isFairMode;
    private boolean isCompeteMode;
    private int semaphoreSize;
    private PoolSemaphore semaphore;
    private long maxWaitNs;
    private long idleTimeoutMs;
    private long holdTimeoutMs;
    private long validAssumeTime;
    private int validTestTimeout;
    private long delayTimeForNextClearNs;
    private int stateCodeOnRelease;
    private PooledConnectionTransferPolicy transferPolicy;
    private boolean templatePooledConnNotCreated = true;
    private PooledConnection templatePooledConn;
    private volatile PooledConnection[] pooledArray;
    private boolean isRawXaConnFactory;
    private RawConnectionFactory rawConnFactory;
    private RawXaConnectionFactory rawXaConnFactory;
    private PooledConnectionValidTest conValidTest;
    private ThreadPoolExecutor networkTimeoutExecutor;
    private AtomicInteger servantState;
    private AtomicInteger servantTryCount;
    private AtomicInteger idleScanState;
    private IdleTimeoutScanThread idleScanThread;
    private ConcurrentLinkedQueue<Borrower> waitQueue;
    private ThreadLocal<WeakReference<Borrower>> threadLocal;
    private BeeDataSourceConfig poolConfig;
    private ConnectionPoolMonitorVo monitorVo;
    private ConnectionPoolHook exitHook;
    private boolean printRuntimeLog;

    public void init(BeeDataSourceConfig config) throws SQLException {
        if (config == null) {
            throw new PoolCreateFailedException("Configuration can't be null");
        }
        if (this.poolState != 0) {
            throw new PoolCreateFailedException("Pool has initialized");
        }
        this.poolConfig = config.check();
        this.poolName = this.poolConfig.getPoolName();
        this.poolMaxSize = this.poolConfig.getMaxActive();
        Log.info("BeeCP({})starting....", (Object)this.poolName);
        Object rawFactory = this.poolConfig.getConnectionFactory();
        if (rawFactory instanceof RawXaConnectionFactory) {
            this.isRawXaConnFactory = true;
            this.rawXaConnFactory = (RawXaConnectionFactory)rawFactory;
        } else if (rawFactory instanceof RawConnectionFactory) {
            this.rawConnFactory = (RawConnectionFactory)rawFactory;
        } else {
            throw new PoolCreateFailedException("Invalid connection factory");
        }
        this.synLock = new Object();
        this.pooledArray = new PooledConnection[0];
        this.createInitConnections(this.poolConfig.getInitialSize());
        if (this.poolConfig.isFairMode()) {
            this.poolMode = "fair";
            this.isFairMode = true;
            this.transferPolicy = new FairTransferPolicy();
        } else {
            this.poolMode = "compete";
            this.isCompeteMode = true;
            this.transferPolicy = this;
        }
        this.stateCodeOnRelease = this.transferPolicy.getStateCodeOnRelease();
        this.maxWaitNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
        this.idleTimeoutMs = this.poolConfig.getIdleTimeout();
        this.holdTimeoutMs = this.poolConfig.getHoldTimeout();
        this.validAssumeTime = this.poolConfig.getValidAssumeTime();
        this.validTestTimeout = this.poolConfig.getValidTestTimeout();
        this.delayTimeForNextClearNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getDelayTimeForNextClear());
        this.printRuntimeLog = this.poolConfig.isPrintRuntimeLog();
        this.semaphoreSize = this.poolConfig.getBorrowSemaphoreSize();
        this.semaphore = new PoolSemaphore(this.semaphoreSize, this.isFairMode);
        this.waitQueue = new ConcurrentLinkedQueue();
        this.threadLocal = new ThreadLocal();
        this.servantTryCount = new AtomicInteger(0);
        this.servantState = new AtomicInteger(0);
        this.idleScanState = new AtomicInteger(0);
        this.idleScanThread = new IdleTimeoutScanThread(this);
        this.monitorVo = this.createPoolMonitorVo();
        this.exitHook = new ConnectionPoolHook(this);
        Runtime.getRuntime().addShutdownHook(this.exitHook);
        this.registerJmx();
        this.setDaemon(true);
        this.setName("BeeCP(" + this.poolName + ")-workServant");
        this.idleScanThread.setDaemon(true);
        this.idleScanThread.setName("BeeCP(" + this.poolName + ")-idleCheck");
        this.setPriority(3);
        this.idleScanThread.setPriority(3);
        this.start();
        this.idleScanThread.start();
        this.poolState = 1;
        Log.info("BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}", new Object[]{this.poolName, this.poolMode, this.pooledArray.length, this.poolMaxSize, this.semaphoreSize, this.poolConfig.getMaxWait(), this.poolConfig.getDriverClassName()});
    }

    private void createInitConnections(int initSize) throws SQLException {
        block5: {
            try {
                int size = initSize > 0 ? initSize : 1;
                for (int i = 0; i < size; ++i) {
                    this.createPooledConn(0);
                }
            }
            catch (Throwable e) {
                for (PooledConnection p : this.pooledArray) {
                    this.removePooledConn(p, "init");
                }
                if (e instanceof TestSQLFailException) {
                    throw (TestSQLFailException)e;
                }
                if (initSize <= 0) break block5;
                throw e instanceof SQLException ? (SQLException)e : new PoolInternalException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection createPooledConn(int state) throws SQLException {
        Object object = this.synLock;
        synchronized (object) {
            int l = this.pooledArray.length;
            if (l < this.poolMaxSize) {
                if (this.printRuntimeLog) {
                    Log.info("BeeCP({}))begin to create a new pooled connection,state:{}", (Object)this.poolName, (Object)state);
                }
                Connection rawConn = null;
                XAConnection rawXaConn = null;
                XAResource rawXaRes = null;
                try {
                    if (this.isRawXaConnFactory) {
                        rawXaConn = this.rawXaConnFactory.create();
                        rawConn = rawXaConn.getConnection();
                        rawXaRes = rawXaConn.getXAResource();
                    } else {
                        rawConn = this.rawConnFactory.create();
                    }
                    if (this.templatePooledConnNotCreated) {
                        this.templatePooledConn = this.createTemplatePooledConn(rawConn);
                        this.templatePooledConnNotCreated = false;
                    }
                    PooledConnection p = this.templatePooledConn.setDefaultAndCopy(rawConn, state, rawXaRes);
                    if (this.printRuntimeLog) {
                        Log.info("BeeCP({}))has created a new pooled connection:{},state:{}", new Object[]{this.poolName, p, state});
                    }
                    PooledConnection[] arrayNew = new PooledConnection[l + 1];
                    System.arraycopy(this.pooledArray, 0, arrayNew, 0, l);
                    arrayNew[l] = p;
                    this.pooledArray = arrayNew;
                    return p;
                }
                catch (Throwable e) {
                    if (rawConn != null) {
                        PoolStaticCenter.oclose(rawConn);
                    } else if (rawXaConn != null) {
                        PoolStaticCenter.oclose(rawXaConn);
                    }
                    throw e instanceof SQLException ? (SQLException)e : new PoolInternalException(e);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePooledConn(PooledConnection p, String removeType) {
        if (this.printRuntimeLog) {
            Log.info("BeeCP({}))begin to remove pooled connection:{},reason:{}", new Object[]{this.poolName, p, removeType});
        }
        p.onBeforeRemove();
        Object object = this.synLock;
        synchronized (object) {
            int l = this.pooledArray.length;
            for (int i = l - 1; i >= 0; --i) {
                if (this.pooledArray[i] != p) continue;
                PooledConnection[] arrayNew = new PooledConnection[l - 1];
                System.arraycopy(this.pooledArray, 0, arrayNew, 0, i);
                int m = l - i - 1;
                if (m > 0) {
                    System.arraycopy(this.pooledArray, i + 1, arrayNew, i, m);
                }
                this.pooledArray = arrayNew;
                if (!this.printRuntimeLog) break;
                Log.info("BeeCP({}))has removed pooled connection:{},reason:{}", new Object[]{this.poolName, p, removeType});
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection createTemplatePooledConn(Connection rawCon) throws SQLException {
        boolean supportIsValid;
        String defaultSchema;
        String defaultCatalog;
        Boolean defaultReadOnly;
        Integer defaultTransactionIsolation;
        Boolean defaultAutoCommit;
        block28: {
            block27: {
                block26: {
                    defaultAutoCommit = this.poolConfig.isDefaultAutoCommit();
                    if (defaultAutoCommit == null) {
                        defaultAutoCommit = rawCon.getAutoCommit();
                    }
                    if ((defaultTransactionIsolation = this.poolConfig.getDefaultTransactionIsolationCode()) == null) {
                        defaultTransactionIsolation = rawCon.getTransactionIsolation();
                    }
                    if ((defaultReadOnly = this.poolConfig.isDefaultReadOnly()) == null) {
                        defaultReadOnly = rawCon.isReadOnly();
                    }
                    if (PoolStaticCenter.isBlank(defaultCatalog = this.poolConfig.getDefaultCatalog())) {
                        try {
                            defaultCatalog = rawCon.getCatalog();
                        }
                        catch (Throwable e) {
                            if (!this.printRuntimeLog) break block26;
                            Log.warn("BeeCP({})driver not support 'catalog'", (Object)this.poolName);
                        }
                    }
                }
                if (PoolStaticCenter.isBlank(defaultSchema = this.poolConfig.getDefaultSchema())) {
                    try {
                        defaultSchema = rawCon.getSchema();
                    }
                    catch (Throwable e) {
                        if (!this.printRuntimeLog) break block27;
                        Log.warn("BeeCP({})driver not support 'schema'", (Object)this.poolName);
                    }
                }
            }
            supportIsValid = true;
            try {
                if (rawCon.isValid(this.validTestTimeout)) {
                    this.conValidTest = this;
                } else {
                    supportIsValid = false;
                    if (this.printRuntimeLog) {
                        Log.warn("BeeCP({})driver not support 'isValid'", (Object)this.poolName);
                    }
                }
            }
            catch (Throwable e) {
                supportIsValid = false;
                if (!this.printRuntimeLog) break block28;
                Log.warn("BeeCP({})driver not support 'isValid',cause:", (Object)this.poolName, (Object)e);
            }
        }
        if (!supportIsValid) {
            String conTestSql = this.poolConfig.getValidTestSql();
            boolean supportQueryTimeout = PoolStaticCenter.validateTestSql(this.poolName, rawCon, conTestSql, this.validTestTimeout, defaultAutoCommit);
            this.conValidTest = new PooledConnectionValidTestBySql(conTestSql, defaultAutoCommit, supportQueryTimeout);
        }
        int defaultNetworkTimeout = 0;
        boolean supportNetworkTimeoutInd = true;
        try {
            defaultNetworkTimeout = rawCon.getNetworkTimeout();
            if (defaultNetworkTimeout < 0) {
                supportNetworkTimeoutInd = false;
                if (this.printRuntimeLog) {
                    Log.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
                }
            } else {
                if (this.networkTimeoutExecutor == null) {
                    this.networkTimeoutExecutor = new ThreadPoolExecutor(this.poolMaxSize, this.poolMaxSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.poolMaxSize), new PoolThreadThreadFactory("BeeCP(" + this.poolName + ")"));
                    this.networkTimeoutExecutor.allowCoreThreadTimeOut(true);
                }
                rawCon.setNetworkTimeout(this.networkTimeoutExecutor, defaultNetworkTimeout);
            }
        }
        catch (Throwable e) {
            supportNetworkTimeoutInd = false;
            if (this.printRuntimeLog) {
                Log.warn("BeeCP({})driver not support 'networkTimeout',cause:", (Object)this.poolName, (Object)e);
            }
        }
        finally {
            if (!supportNetworkTimeoutInd && this.networkTimeoutExecutor != null) {
                this.networkTimeoutExecutor.shutdown();
                this.networkTimeoutExecutor = null;
            }
        }
        return new PooledConnection(defaultAutoCommit, defaultTransactionIsolation, defaultReadOnly, defaultCatalog, defaultSchema, defaultNetworkTimeout, supportNetworkTimeoutInd, this.networkTimeoutExecutor, this);
    }

    public final Connection getConnection() throws SQLException {
        return PoolStaticCenter.createProxyConnection(this.getPooledConnection());
    }

    public final XAConnection getXAConnection() throws SQLException {
        PooledConnection p = this.getPooledConnection();
        ProxyConnectionBase proxyConn = PoolStaticCenter.createProxyConnection(p);
        return new XaProxyConnection(proxyConn, this.isRawXaConnFactory ? new XaProxyResource(p.rawXaRes, proxyConn) : new XaResourceLocalImpl(proxyConn, p.defaultAutoCommit));
    }

    private PooledConnection getPooledConnection() throws SQLException {
        Borrower b;
        if (this.poolState != 1) {
            throw new PoolClosedException("Pool has shut down or in clearing");
        }
        WeakReference<Borrower> r = this.threadLocal.get();
        Borrower borrower = b = r != null ? (Borrower)r.get() : null;
        if (b != null) {
            PooledConnection p = b.lastUsed;
            if (p != null && p.state == 0 && ConStUpd.compareAndSet(p, 0, 1)) {
                if (this.testOnBorrow(p)) {
                    b.lastUsed = p;
                    return b.lastUsed;
                }
                b.lastUsed = null;
            }
        } else {
            b = new Borrower();
            this.threadLocal.set(new WeakReference<Borrower>(b));
        }
        long deadline = System.nanoTime();
        try {
            if (!this.semaphore.tryAcquire(this.maxWaitNs, TimeUnit.NANOSECONDS)) {
                throw new SQLTimeoutException("Get connection timeout");
            }
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted during getting connection");
        }
        try {
            PooledConnection p = this.searchOrCreate();
            if (p != null) {
                PooledConnection pooledConnection = b.lastUsed = p;
                return pooledConnection;
            }
            b.state = BOWER_NORMAL;
            this.waitQueue.offer(b);
            boolean failed = false;
            SQLException cause = null;
            deadline += this.maxWaitNs;
            Thread thd = b.thread;
            while (true) {
                Object s;
                if ((s = b.state) instanceof PooledConnection) {
                    p = (PooledConnection)s;
                    if (this.transferPolicy.tryCatch(p) && this.testOnBorrow(p)) {
                        this.waitQueue.remove(b);
                        PooledConnection pooledConnection = b.lastUsed = p;
                        return pooledConnection;
                    }
                } else if (s instanceof Throwable) {
                    this.waitQueue.remove(b);
                    throw s instanceof SQLException ? (SQLException)s : new PoolInternalException((Throwable)s);
                }
                if (failed) {
                    BorrowStUpd.compareAndSet(b, s, cause);
                    continue;
                }
                if (s instanceof PooledConnection) {
                    b.state = BOWER_NORMAL;
                    Thread.yield();
                    continue;
                }
                long t = deadline - System.nanoTime();
                if (t > 0L) {
                    if (b.state != BOWER_NORMAL || !BorrowStUpd.compareAndSet(b, BOWER_NORMAL, BOWER_WAITING)) continue;
                    if (this.servantTryCount.get() > 0 && this.servantState.get() == 1 && this.servantState.compareAndSet(1, 0)) {
                        LockSupport.unpark(this);
                    }
                    LockSupport.parkNanos(t);
                    if (thd.isInterrupted()) {
                        failed = true;
                        cause = new SQLException("Interrupted during getting connection");
                        BorrowStUpd.compareAndSet(b, BOWER_WAITING, cause);
                        continue;
                    }
                    if (b.state != BOWER_WAITING || !BorrowStUpd.compareAndSet(b, BOWER_WAITING, BOWER_NORMAL)) continue;
                    FastConnectionPool.yield();
                    continue;
                }
                failed = true;
                cause = new SQLTimeoutException("Get connection timeout");
            }
        }
        finally {
            this.semaphore.release();
        }
    }

    private PooledConnection searchOrCreate() throws SQLException {
        PooledConnection[] array;
        for (PooledConnection p : array = this.pooledArray) {
            if (p.state != 0 || !ConStUpd.compareAndSet(p, 0, 1) || !this.testOnBorrow(p)) continue;
            return p;
        }
        if (this.pooledArray.length < this.poolMaxSize) {
            return this.createPooledConn(1);
        }
        return null;
    }

    private void tryWakeupServantThread() {
        int c;
        do {
            if ((c = this.servantTryCount.get()) < this.poolMaxSize) continue;
            return;
        } while (!this.servantTryCount.compareAndSet(c, c + 1));
        if (!this.waitQueue.isEmpty() && this.servantState.get() == 1 && this.servantState.compareAndSet(1, 0)) {
            LockSupport.unpark(this);
        }
    }

    public final void recycle(PooledConnection p) {
        if (this.isCompeteMode) {
            p.state = 0;
        }
        block0: for (Borrower b : this.waitQueue) {
            Object state;
            do {
                if (p.state != this.stateCodeOnRelease) {
                    return;
                }
                state = b.state;
                if (!(state instanceof BorrowerState)) continue block0;
            } while (!BorrowStUpd.compareAndSet(b, state, p));
            if (state == BOWER_WAITING) {
                LockSupport.unpark(b.thread);
            }
            return;
        }
        if (this.isFairMode) {
            p.state = 0;
        }
        this.tryWakeupServantThread();
    }

    private void transferException(Throwable e) {
        for (Borrower b : this.waitQueue) {
            Object state;
            while ((state = b.state) instanceof BorrowerState) {
                if (!BorrowStUpd.compareAndSet(b, state, e)) continue;
                if (state == BOWER_WAITING) {
                    LockSupport.unpark(b.thread);
                }
                return;
            }
        }
    }

    final void abandonOnReturn(PooledConnection p, String reason) {
        this.removePooledConn(p, reason);
        this.tryWakeupServantThread();
    }

    private boolean testOnBorrow(PooledConnection p) {
        if (System.currentTimeMillis() - p.lastAccessTime > this.validAssumeTime && !this.conValidTest.isValid(p)) {
            this.removePooledConn(p, "bad");
            this.tryWakeupServantThread();
            return false;
        }
        return true;
    }

    public final int getStateCodeOnRelease() {
        return 0;
    }

    public final boolean tryCatch(PooledConnection p) {
        return p.state == 0 && ConStUpd.compareAndSet(p, 0, 1);
    }

    private boolean existBorrower() {
        return this.semaphoreSize > this.semaphore.availablePermits();
    }

    private void shutdownPoolThread() {
        int curState = this.servantState.get();
        this.servantState.set(2);
        if (curState == 1) {
            LockSupport.unpark(this);
        }
        curState = this.idleScanState.get();
        this.idleScanState.set(2);
        if (curState == 1) {
            LockSupport.unpark(this.idleScanThread);
        }
    }

    public void run() {
        while (this.poolState != 2) {
            int c;
            while (!(this.servantState.get() != 0 || (c = this.servantTryCount.get()) <= 0 || this.waitQueue.isEmpty() && this.servantTryCount.compareAndSet(c, 0))) {
                this.servantTryCount.decrementAndGet();
                try {
                    PooledConnection p = this.searchOrCreate();
                    if (p == null) continue;
                    this.recycle(p);
                }
                catch (Throwable e) {
                    this.transferException(e);
                }
            }
            if (this.servantState.get() == 2) break;
            if (this.servantTryCount.get() != 0 || !this.servantState.compareAndSet(0, 1)) continue;
            LockSupport.park();
        }
    }

    private void closeIdleTimeoutConnection() {
        if (this.poolState == 1) {
            PooledConnection[] array;
            for (PooledConnection p : array = this.pooledArray) {
                int state = p.state;
                if (state == 0 && !this.existBorrower()) {
                    boolean isTimeoutInIdle;
                    boolean bl = isTimeoutInIdle = System.currentTimeMillis() - p.lastAccessTime >= this.idleTimeoutMs;
                    if (!isTimeoutInIdle || !ConStUpd.compareAndSet(p, state, 2)) continue;
                    this.removePooledConn(p, "idle");
                    this.tryWakeupServantThread();
                    continue;
                }
                if (state == 1) {
                    if (System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs) continue;
                    ProxyConnectionBase proxyInUsing = p.proxyInUsing;
                    if (proxyInUsing != null) {
                        PoolStaticCenter.oclose(proxyInUsing);
                        continue;
                    }
                    this.removePooledConn(p, "bad");
                    this.tryWakeupServantThread();
                    continue;
                }
                if (state != 2) continue;
                this.removePooledConn(p, "closed");
                this.tryWakeupServantThread();
            }
        }
        if (this.printRuntimeLog) {
            ConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})-{idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean force) {
        if (PoolStateUpd.compareAndSet(this, 1, 3)) {
            Log.info("BeeCP({})begin to remove connections", (Object)this.poolName);
            this.removeAllConnections(force, "clear");
            this.poolState = 1;
            Log.info("BeeCP({})all connections were removed and restored to accept new requests", (Object)this.poolName);
        }
    }

    private void removeAllConnections(boolean force, String source) {
        this.semaphore.interruptWaitingThreads();
        PoolClosedException exception = new PoolClosedException("Pool has shut down or in clearing");
        while (!this.waitQueue.isEmpty()) {
            this.transferException(exception);
        }
        while (this.pooledArray.length > 0) {
            PooledConnection[] array;
            for (PooledConnection p : array = this.pooledArray) {
                int state = p.state;
                if (state == 0) {
                    if (!ConStUpd.compareAndSet(p, 0, 2)) continue;
                    this.removePooledConn(p, source);
                    continue;
                }
                if (state == 1) {
                    ProxyConnectionBase proxyInUsing = p.proxyInUsing;
                    if (proxyInUsing != null) {
                        if (!force && System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs) continue;
                        PoolStaticCenter.oclose(proxyInUsing);
                        if (!ConStUpd.compareAndSet(p, 0, 2)) continue;
                        this.removePooledConn(p, source);
                        continue;
                    }
                    this.removePooledConn(p, source);
                    continue;
                }
                if (state != 2) continue;
                this.removePooledConn(p, source);
            }
            if (this.pooledArray.length <= 0) continue;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
        if (this.printRuntimeLog) {
            ConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})-{idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
    }

    public boolean isClosed() {
        return this.poolState == 2;
    }

    public void close() {
        while (true) {
            int poolStateCode;
            if (((poolStateCode = this.poolState) == 0 || poolStateCode == 1) && PoolStateUpd.compareAndSet(this, poolStateCode, 2)) {
                Log.info("BeeCP({})begin to shutdown", (Object)this.poolName);
                this.shutdownPoolThread();
                this.unregisterJmx();
                this.removeAllConnections(this.poolConfig.isForceCloseUsingOnClear(), "destroy");
                if (this.networkTimeoutExecutor != null) {
                    this.networkTimeoutExecutor.shutdown();
                }
                try {
                    Runtime.getRuntime().removeShutdownHook(this.exitHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Log.info("BeeCP({})has shutdown", (Object)this.poolName);
                break;
            }
            if (poolStateCode == 2) break;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
    }

    public void setPrintRuntimeLog(boolean indicator) {
        this.printRuntimeLog = indicator;
    }

    public int getTotalSize() {
        return this.pooledArray.length;
    }

    public int getIdleSize() {
        PooledConnection[] array;
        int idleSize = 0;
        for (PooledConnection p : array = this.pooledArray) {
            if (p.state != 0) continue;
            ++idleSize;
        }
        return idleSize;
    }

    public int getUsingSize() {
        int active = this.pooledArray.length - this.getIdleSize();
        return active > 0 ? active : 0;
    }

    public int getSemaphoreWaitingSize() {
        return this.semaphore.getQueueLength();
    }

    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowSemaphoreSize() - this.semaphore.availablePermits();
    }

    public int getTransferWaitingSize() {
        int size = 0;
        for (Borrower borrower : this.waitQueue) {
            if (!(borrower.state instanceof BorrowerState)) continue;
            ++size;
        }
        return size;
    }

    private void registerJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJmxBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Exception e) {
            Log.warn("BeeCP({})failed to register jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJmxBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Exception e) {
            Log.warn("BeeCP({})failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    public final boolean isValid(PooledConnection p) {
        block3: {
            try {
                if (p.rawConn.isValid(this.validTestTimeout)) {
                    p.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                if (!this.printRuntimeLog) break block3;
                Log.warn("BeeCP({})failed to test connection with 'isValid' method", (Object)this.poolName, (Object)e);
            }
        }
        return false;
    }

    private ConnectionPoolMonitorVo createPoolMonitorVo() {
        Thread currentThread = Thread.currentThread();
        this.poolThreadId = currentThread.getId();
        this.poolThreadName = currentThread.getName();
        try {
            this.poolHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Log.info("BeeCP({})failed to resolve pool hose ip", (Object)this.poolName);
        }
        return new ConnectionPoolMonitorVo();
    }

    public ConnectionPoolMonitorVo getPoolMonitorVo() {
        this.monitorVo.setPoolName(this.poolName);
        this.monitorVo.setPoolMode(this.poolMode);
        this.monitorVo.setPoolMaxSize(this.poolMaxSize);
        this.monitorVo.setThreadId(this.poolThreadId);
        this.monitorVo.setThreadName(this.poolThreadName);
        this.monitorVo.setHostIP(this.poolHostIP);
        int totSize = this.getTotalSize();
        int idleSize = this.getIdleSize();
        this.monitorVo.setPoolState(this.poolState);
        this.monitorVo.setIdleSize(idleSize);
        this.monitorVo.setUsingSize(totSize - idleSize);
        this.monitorVo.setSemaphoreWaitingSize(this.getSemaphoreWaitingSize());
        this.monitorVo.setTransferWaitingSize(this.getTransferWaitingSize());
        return this.monitorVo;
    }

    static {
        PoolStaticCenter.checkJdbcProxyClass();
    }

    private final class PooledConnectionValidTestBySql
    implements PooledConnectionValidTest {
        private final String testSql;
        private final boolean isDefaultAutoCommit;
        private final boolean supportQueryTimeout;

        PooledConnectionValidTestBySql(String testSql, boolean isDefaultAutoCommit, boolean supportQueryTimeout) {
            this.testSql = testSql;
            this.isDefaultAutoCommit = isDefaultAutoCommit;
            this.supportQueryTimeout = supportQueryTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isValid(PooledConnection p) {
            Statement st = null;
            boolean changed = false;
            Connection rawConn = p.rawConn;
            boolean checkPassed = true;
            try {
                block21: {
                    if (this.isDefaultAutoCommit) {
                        rawConn.setAutoCommit(false);
                        changed = true;
                    }
                    st = rawConn.createStatement();
                    if (this.supportQueryTimeout) {
                        try {
                            st.setQueryTimeout(FastConnectionPool.this.validTestTimeout);
                        }
                        catch (Throwable e) {
                            if (!FastConnectionPool.this.printRuntimeLog) break block21;
                            Log.warn("BeeCP({})failed to setQueryTimeout", (Object)FastConnectionPool.this.poolName, (Object)e);
                        }
                    }
                }
                try {
                    st.execute(this.testSql);
                    p.lastAccessTime = System.currentTimeMillis();
                }
                finally {
                    rawConn.rollback();
                }
            }
            catch (Throwable e) {
                checkPassed = false;
                if (FastConnectionPool.this.printRuntimeLog) {
                    Log.warn("BeeCP({})failed to test connection by sql", (Object)FastConnectionPool.this.poolName, (Object)e);
                }
            }
            finally {
                if (st != null) {
                    PoolStaticCenter.oclose(st);
                }
                if (changed) {
                    try {
                        rawConn.setAutoCommit(true);
                    }
                    catch (Throwable e) {
                        Log.warn("BeeCP({})failed to rest autoCommit to default value:true after sql-test", (Object)FastConnectionPool.this.poolName, (Object)e);
                        checkPassed = false;
                    }
                }
            }
            return checkPassed;
        }
    }

    private static final class FairTransferPolicy
    implements PooledConnectionTransferPolicy {
        private FairTransferPolicy() {
        }

        public int getStateCodeOnRelease() {
            return 1;
        }

        public final boolean tryCatch(PooledConnection p) {
            return p.state == 1;
        }
    }

    private static class ConnectionPoolHook
    extends Thread {
        private final FastConnectionPool pool;

        ConnectionPoolHook(FastConnectionPool pool) {
            this.pool = pool;
        }

        public void run() {
            try {
                Log.info("BeeCP({})ConnectionPoolHook Running", (Object)this.pool.poolName);
                this.pool.close();
            }
            catch (Throwable e) {
                Log.error("BeeCP({})Error at closing connection pool,cause:", (Object)this.pool.poolName, (Object)e);
            }
        }
    }

    private static final class IdleTimeoutScanThread
    extends Thread {
        private final FastConnectionPool pool;
        private final AtomicInteger idleScanState;

        IdleTimeoutScanThread(FastConnectionPool pool) {
            this.pool = pool;
            this.idleScanState = pool.idleScanState;
        }

        public void run() {
            long checkTimeIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pool.poolConfig.getTimerCheckInterval());
            while (this.idleScanState.get() == 0) {
                LockSupport.parkNanos(checkTimeIntervalNanos);
                try {
                    this.pool.closeIdleTimeoutConnection();
                }
                catch (Throwable e) {
                    Log.warn("BeeCP({})Error at closing idle timeout connections,cause:", (Object)this.pool.poolName, (Object)e);
                }
            }
        }
    }

    private static final class PoolSemaphore
    extends Semaphore {
        PoolSemaphore(int permits, boolean fair) {
            super(permits, fair);
        }

        void interruptWaitingThreads() {
            for (Thread thread : this.getQueuedThreads()) {
                Thread.State state = thread.getState();
                if (state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING) continue;
                thread.interrupt();
            }
        }
    }

    private static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final Random seqRandom = new Random();

        public PoolThreadThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.poolName + " - networkTimeoutRestThread -" + this.seqRandom.nextInt());
            th.setDaemon(true);
            return th;
        }
    }
}

