/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.echarts.json;

import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Chord;
import com.github.abel533.echarts.series.Force;
import com.github.abel533.echarts.series.Funnel;
import com.github.abel533.echarts.series.Gauge;
import com.github.abel533.echarts.series.Island;
import com.github.abel533.echarts.series.K;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Map;
import com.github.abel533.echarts.series.Pie;
import com.github.abel533.echarts.series.Radar;
import com.github.abel533.echarts.series.Scatter;
import com.github.abel533.echarts.series.Series;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class SeriesDeserializer
implements JsonDeserializer<Series> {
    public Series deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String _type = jsonObject.get("type").getAsString();
        SeriesType type = SeriesType.valueOf(_type);
        Series series = null;
        switch (type) {
            case line: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Line.class);
                break;
            }
            case bar: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Bar.class);
                break;
            }
            case scatter: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Scatter.class);
                break;
            }
            case funnel: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Funnel.class);
                break;
            }
            case pie: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Pie.class);
                break;
            }
            case force: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Force.class);
                break;
            }
            case gauge: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Gauge.class);
                break;
            }
            case map: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Map.class);
                break;
            }
            case island: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Island.class);
                break;
            }
            case k: {
                series = (Series)context.deserialize((JsonElement)jsonObject, K.class);
                break;
            }
            case radar: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Radar.class);
                break;
            }
            case chord: {
                series = (Series)context.deserialize((JsonElement)jsonObject, Chord.class);
            }
        }
        return series;
    }
}

