/*
 * Decompiled with CFR 0.152.
 */
package fox.base;

import fox.base.IConfigElement;
import fox.base.IExtension;
import fox.base.IExtensionPoint;
import fox.base.IllegalFormatException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ExtensionRegistry {
    private Map<String, IExtensionPoint> extensionPointMap = new HashMap<String, IExtensionPoint>();

    public void load(File file, String encoding) throws XmlPullParserException, IllegalFormatException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        this.load(in, encoding);
    }

    public void load(InputStream in, String encoding) throws XmlPullParserException, IllegalFormatException, IOException {
        this.parserFile(in, encoding, this.extensionPointMap);
    }

    private void parserFile(InputStream input, String encoding, Map<String, IExtensionPoint> extensionPointMap) throws XmlPullParserException, IllegalFormatException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(input, encoding);
        int eventType = parser.getEventType();
        if (eventType != 0) {
            throw new IllegalFormatException("Not starting with 'start_document'");
        }
        Stack<StackNode> stack = new Stack<StackNode>();
        eventType = parser.next();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String tagName = parser.getName();
                    if ("plugins".equals(tagName)) break;
                    if ("extension".equals(tagName)) {
                        Extension extension = new Extension();
                        int count = parser.getAttributeCount();
                        String name = "";
                        for (int i = 0; i < count; ++i) {
                            String key = parser.getAttributeName(i);
                            String value = parser.getAttributeValue(i);
                            if ("point".equalsIgnoreCase(key)) {
                                name = value;
                            }
                            extension.setAttribute(key, value);
                        }
                        StackNode node = new StackNode();
                        node.name = name;
                        node.obj = extension;
                        stack.push(node);
                        break;
                    }
                    int count = parser.getAttributeCount();
                    ConfigElement configElement = new ConfigElement();
                    configElement.setName(tagName);
                    for (int i = 0; i < count; ++i) {
                        String key = parser.getAttributeName(i);
                        String value = parser.getAttributeValue(i);
                        configElement.setAttribute(key, value);
                    }
                    StackNode node = new StackNode();
                    node.name = tagName;
                    node.obj = configElement;
                    stack.push(node);
                    break;
                }
                case 3: {
                    String tagName = parser.getName();
                    if (!"plugins".equals(tagName)) {
                        StackNode node;
                        if ("extension".equals(tagName)) {
                            node = (StackNode)stack.pop();
                            Extension extension = (Extension)node.obj;
                            ExtensionPoint extensionPoint = (ExtensionPoint)extensionPointMap.get(node.name);
                            if (extensionPoint == null) {
                                extensionPoint = new ExtensionPoint();
                                extensionPointMap.put(node.name, extensionPoint);
                            }
                            extensionPoint.addExtension(extension);
                        } else {
                            if (stack.isEmpty()) break;
                            node = (StackNode)stack.pop();
                            if (stack.isEmpty()) break;
                            StackNode parent = (StackNode)stack.peek();
                            if (parent.obj instanceof Extension) {
                                Extension extension = (Extension)parent.obj;
                                ConfigElement configElement = (ConfigElement)node.obj;
                                extension.addConfigElement(configElement);
                                break;
                            }
                            if (!(parent.obj instanceof IConfigElement)) break;
                            ConfigElement parentElement = (ConfigElement)parent.obj;
                            ConfigElement subElement = (ConfigElement)node.obj;
                            parentElement.addChildren(node.name, subElement);
                            break;
                        }
                    }
                }
                case 4: {
                    if (stack.isEmpty()) break;
                    StackNode node = (StackNode)stack.peek();
                    if (!(node.obj instanceof IConfigElement)) break;
                    ConfigElement subElement = (ConfigElement)node.obj;
                    subElement.setText(parser.getText());
                }
            }
            eventType = parser.next();
        }
    }

    public IExtensionPoint getExtensionPoint(String pointName) {
        IExtensionPoint extensionPoint = this.extensionPointMap.get(pointName);
        return extensionPoint;
    }

    private class ConfigElement
    implements IConfigElement {
        private String name;
        private String text;
        private Map<String, String> attributes = new HashMap<String, String>();
        private Map<String, List<IConfigElement>> childrenMap = new HashMap<String, List<IConfigElement>>();

        private ConfigElement() {
        }

        @Override
        public List<String> attributeKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(this.attributes.keySet());
            return keys;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String getAttribute(String key) {
            String value = this.attributes.get(key);
            return value;
        }

        public void setAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        @Override
        public IConfigElement[] getChildren(String name) {
            List<IConfigElement> list = this.childrenMap.get(name);
            if (list == null) {
                return new IConfigElement[0];
            }
            IConfigElement[] children = list.toArray(new IConfigElement[0]);
            return children;
        }

        public void addChildren(String name, IConfigElement configElement) {
            List<IConfigElement> list = this.childrenMap.get(name);
            if (list == null) {
                list = new ArrayList<IConfigElement>();
                this.childrenMap.put(name, list);
            }
            list.add(configElement);
        }
    }

    private class Extension
    implements IExtension {
        private Map<String, String> attributes = new HashMap<String, String>();
        private List<IConfigElement> children = new ArrayList<IConfigElement>();

        private Extension() {
        }

        @Override
        public IConfigElement[] getConfigElements() {
            IConfigElement[] list = new IConfigElement[]{};
            list = this.children.toArray(list);
            return list;
        }

        public void addConfigElement(IConfigElement configElement) {
            this.children.add(configElement);
        }

        @Override
        public List<String> attributeKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(this.attributes.keySet());
            return keys;
        }

        @Override
        public String getAttribute(String key) {
            String value = this.attributes.get(key);
            return value;
        }

        public void setAttribute(String key, String value) {
            this.attributes.put(key, value);
        }
    }

    private class ExtensionPoint
    implements IExtensionPoint {
        private List<IExtension> children = new ArrayList<IExtension>();

        private ExtensionPoint() {
        }

        @Override
        public IExtension[] getExtensions() {
            IExtension[] list = new IExtension[]{};
            list = this.children.toArray(list);
            return list;
        }

        public void addExtension(IExtension extension) {
            this.children.add(extension);
        }
    }

    private class StackNode {
        public String name;
        public Object obj;

        private StackNode() {
        }
    }
}

