package fox.base;

import java.util.List;

/**
 * 扩展点配置
 * <p>
 * Created by 江成 on 2016/10/13.
 */

public interface IConfigElement {

    /**
     * 获取扩展点配置名称
     *
     * @return
     */
     String getName();

    /**
     * key集合
     * @return
     */
     List<String> attributeKeys();

    /**
     * 获取扩展点属性
     *
     * @param key
     * @return
     */
     String getAttribute(String key);

    /**
     * 获取扩展点的文本
     *
     * @return
     */
     String getText();

    /**
     * 获取指定名称的扩展点配置
     *
     * @param name
     * @return
     */
     IConfigElement[] getChildren(String name);
}
