/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.filter;

import com.alibaba.dubbo.common.beanutil.JavaBeanAccessor;
import com.alibaba.dubbo.common.beanutil.JavaBeanDescriptor;
import com.alibaba.dubbo.common.beanutil.JavaBeanSerializeUtil;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.Serialization;
import com.alibaba.dubbo.common.utils.PojoUtils;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.service.GenericException;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.dubbo.rpc.support.ProtocolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@Activate(group={"provider"}, order=-20000)
public class GenericFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(GenericFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        if (inv.getMethodName().equals("$invoke") && inv.getArguments() != null && inv.getArguments().length == 3 && !invoker.getInterface().equals(GenericService.class)) {
            String name = ((String)inv.getArguments()[0]).trim();
            String[] types = (String[])inv.getArguments()[1];
            Object[] args = (Object[])inv.getArguments()[2];
            try {
                RpcResult rpcResult;
                int i;
                String generic;
                Method method = ReflectUtils.findMethodByMethodSignature(invoker.getInterface(), (String)name, (String[])types);
                Class[] params = method.getParameterTypes();
                if (args == null) {
                    args = new Object[params.length];
                }
                if (StringUtils.isBlank((String)(generic = inv.getAttachment("generic")))) {
                    generic = RpcContext.getContext().getAttachment("generic");
                }
                if (StringUtils.isEmpty((String)generic) || ProtocolUtils.isDefaultGenericSerialization(generic)) {
                    args = PojoUtils.realize((Object[])args, (Class[])params, (Type[])method.getGenericParameterTypes());
                } else if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                    if (!this.nativeJavaSerializerEnabled()) {
                        String notice = "Trigger the safety barrier! Native Java Serializer is not allowed by default.This means currently maybe being attacking by others. If you are sure this is a mistake, please set `dubbo.security.serialize.generic.native-java-enable` enable in configuration! Before doing so, please make sure you have configure JEP290 to prevent serialization attack.";
                        logger.error(notice);
                        throw new RpcException(new IllegalStateException(notice));
                    }
                    for (i = 0; i < args.length; ++i) {
                        if (byte[].class == args[i].getClass()) {
                            try {
                                UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream((byte[])args[i]);
                                args[i] = ((Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava")).deserialize(null, (InputStream)is).readObject();
                                continue;
                            }
                            catch (Exception e) {
                                throw new RpcException("Deserialize argument [" + (i + 1) + "] failed.", (Throwable)e);
                            }
                        }
                        throw new RpcException("Generic serialization [nativejava] only support message type " + byte[].class + " and your message type is " + args[i].getClass());
                    }
                } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                    for (i = 0; i < args.length; ++i) {
                        if (!(args[i] instanceof JavaBeanDescriptor)) {
                            throw new RpcException("Generic serialization [bean] only support message type " + JavaBeanDescriptor.class.getName() + " and your message type is " + args[i].getClass().getName());
                        }
                        args[i] = JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)((JavaBeanDescriptor)args[i]));
                    }
                }
                Result result = invoker.invoke(new RpcInvocation(method, args, inv.getAttachments()));
                if (result.hasException() && !(result.getException() instanceof GenericException)) {
                    return new RpcResult(new GenericException(result.getException()));
                }
                if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                    try {
                        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(512);
                        ((Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava")).serialize(null, (OutputStream)os).writeObject(result.getValue());
                        rpcResult = new RpcResult(os.toByteArray());
                    }
                    catch (IOException e) {
                        throw new RpcException("Serialize result failed.", (Throwable)e);
                    }
                } else {
                    rpcResult = ProtocolUtils.isBeanGenericSerialization(generic) ? new RpcResult(JavaBeanSerializeUtil.serialize((Object)result.getValue(), (JavaBeanAccessor)JavaBeanAccessor.METHOD)) : new RpcResult(PojoUtils.generalize((Object)result.getValue()));
                }
                rpcResult.setAttachments(result.getAttachments());
                return rpcResult;
            }
            catch (NoSuchMethodException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
        }
        return invoker.invoke(inv);
    }

    private boolean nativeJavaSerializerEnabled() {
        return Boolean.parseBoolean(System.getProperty("dubbo.security.serialize.generic.native-java-enable")) || Boolean.parseBoolean(System.getenv("dubbo.security.serialize.generic.native-java-enable")) || Boolean.parseBoolean(System.getenv(StringUtils.toOSStyleKey((String)"dubbo.security.serialize.generic.native-java-enable")));
    }
}

