/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core.fsm.repository.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.pack.alpha.core.fsm.SuspendedType;
import org.apache.servicecomb.pack.alpha.core.fsm.TransactionType;
import org.apache.servicecomb.pack.alpha.core.fsm.event.base.BaseEvent;
import org.apache.servicecomb.pack.alpha.core.fsm.repository.model.SagaSubTransaction;

public class GlobalTransaction {
    private String globalTxId;
    private TransactionType type;
    private String serviceName;
    private String instanceId;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    private Date beginTime;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    private Date endTime;
    private String state;
    private Integer subTxSize;
    private Long durationTime;
    private List<SagaSubTransaction> subTransactions = new ArrayList<SagaSubTransaction>();
    private List<Map<String, Object>> events = new LinkedList<Map<String, Object>>();
    private SuspendedType suspendedType;

    public String getGlobalTxId() {
        return this.globalTxId;
    }

    public TransactionType getType() {
        return this.type;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getState() {
        return this.state;
    }

    public Integer getSubTxSize() {
        return this.subTxSize;
    }

    public Long getDurationTime() {
        return this.durationTime;
    }

    public List<SagaSubTransaction> getSubTransactions() {
        return this.subTransactions;
    }

    public List<Map<String, Object>> getEvents() {
        return this.events;
    }

    public SuspendedType getSuspendedType() {
        return this.suspendedType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String globalTxId;
        private TransactionType type;
        private String serviceName;
        private String instanceId;
        private Date beginTime;
        private Date endTime;
        private String state;
        private Integer subTxSize;
        private List<SagaSubTransaction> subTransactions;
        private List<BaseEvent> events;
        private SuspendedType suspendedType;

        private Builder() {
        }

        public Builder globalTxId(String globalTxId) {
            this.globalTxId = globalTxId;
            return this;
        }

        public Builder type(TransactionType type) {
            this.type = type;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder beginTime(Date beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder subTxSize(Integer subTxSize) {
            this.subTxSize = subTxSize;
            return this;
        }

        public Builder subTransactions(List<SagaSubTransaction> subTransactions) {
            this.subTransactions = subTransactions;
            return this;
        }

        public Builder events(List<BaseEvent> events) {
            this.events = events;
            return this;
        }

        public Builder suspendedType(SuspendedType suspendedType) {
            this.suspendedType = suspendedType;
            return this;
        }

        public GlobalTransaction build() {
            GlobalTransaction globalTransaction = new GlobalTransaction();
            globalTransaction.instanceId = this.instanceId;
            globalTransaction.state = this.state;
            globalTransaction.type = this.type;
            globalTransaction.serviceName = this.serviceName;
            globalTransaction.beginTime = this.beginTime;
            globalTransaction.endTime = this.endTime;
            globalTransaction.globalTxId = this.globalTxId;
            globalTransaction.subTxSize = this.subTxSize;
            globalTransaction.durationTime = this.endTime.getTime() - this.beginTime.getTime();
            globalTransaction.subTransactions = this.subTransactions;
            globalTransaction.suspendedType = this.suspendedType;
            for (BaseEvent event : this.events) {
                try {
                    globalTransaction.events.add(event.toMap());
                }
                catch (Exception e) {
                    new RuntimeException(e.getMessage(), e);
                }
            }
            return globalTransaction;
        }
    }
}

