/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.sequence.config;

import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.sequence.repository.mapper.SequenceConfigMapper;
import cn.com.yusys.yusp.sequence.service.SequenceConfigService;
import cn.com.yusys.yusp.sequence.service.SequenceTemplateService;
import cn.com.yusys.yusp.sequence.service.impl.SequenceTemplateServiceImpl;
import cn.com.yusys.yusp.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.sequence.web.rest.SequenceConfigResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

public class DbSequenceConfigAutoConfiguration {
    @Bean
    public ApplicationRunner dbSequenceConfigRunner() {
        return args -> {
            SequenceConfigMapper mapper = (SequenceConfigMapper)SpringContextUtils.getBean(SequenceConfigMapper.class);
            List configs = mapper.selectList((Wrapper)Wrappers.emptyWrapper());
            configs.forEach(SequenceUtils::addSequenceConfig);
        };
    }

    @Bean
    public MapperScanBasePackage sequenceMicroServiceMapperPackage() {
        return () -> Collections.singletonList("cn.com.yusys.yusp.sequence.repository.mapper");
    }

    @Bean
    public SequenceTemplateService sequenceTemplateService() {
        return new SequenceTemplateServiceImpl();
    }

    @Bean
    public SequenceConfigService sequenceConfigService(SequenceConfigMapper mapper) {
        return new SequenceConfigService(mapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public SequenceConfigResource sequenceConfigResource(SequenceConfigService service) {
        return new SequenceConfigResource(service);
    }
}

