/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.elsearch.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsearchRestService {
    private final Logger log = LoggerFactory.getLogger(ElsearchRestService.class);
    private static final RequestOptions COMMON_OPTIONS;
    @Autowired
    private RestHighLevelClient restClient;

    public String commonService(String method, String endpoint, Map<String, String> parameters, NStringEntity entity) throws Exception {
        Request request = new Request(method, endpoint);
        request.addParameter("pretty", "true");
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
                request.addParameter(entry.getKey(), entry.getValue());
            }
        }
        if (entity != null) {
            System.out.println(JSONObject.toJSON((Object)entity).toString());
            request.setEntity((HttpEntity)entity);
        }
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseBody;
    }

    public String add(String indexEndpoint, String id, Object obj) throws Exception {
        String endpoint = indexEndpoint + id;
        Request request = new Request("POST", endpoint);
        NStringEntity entity = new NStringEntity(JSONObject.toJSON((Object)obj).toString(), Charset.forName("UTF-8"));
        request.setEntity((HttpEntity)entity);
        this.log.info("add \u65b0\u589e\u6570\u636e request\uff0cindexEndpoint:{}, id:{}, obj:{}", new Object[]{indexEndpoint, id, JSONObject.toJSON((Object)obj)});
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        this.log.info("add \u65b0\u589e\u6570\u636e response\uff0c\u7ed3\u679c:{}", (Object)response);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseBody;
    }

    public String update(String indexEndpoint, String id, Object obj) throws Exception {
        String endpoint = indexEndpoint + id + "/_update";
        Request request = new Request("POST", endpoint);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("doc", obj);
        NStringEntity entity = new NStringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        this.log.info("update \u4fee\u6539\u66ff\u6362\u6570\u636e request\uff0cindexEndpoint:{}, id:{}, obj:{}", new Object[]{indexEndpoint, id, JSONObject.toJSON((Object)obj)});
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        this.log.info("update \u4fee\u6539\u66ff\u6362\u6570\u636e response\uff0c\u7ed3\u679c:{}", (Object)response);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseBody;
    }

    public String updateFields(String indexEndpoint, String id, Map<String, Object> fieldsMap) throws Exception {
        String endpoint = indexEndpoint + id + "/_update";
        Request request = new Request("POST", endpoint);
        JSONObject jsonObject = new JSONObject();
        StringBuffer op1 = new StringBuffer();
        for (Map.Entry<String, Object> entry : fieldsMap.entrySet()) {
            op1.append("ctx._source.").append(entry.getKey()).append("='").append(entry.getValue()).append("';");
        }
        op1.delete(op1.length() - 1, op1.length());
        jsonObject.put("script", (Object)op1);
        NStringEntity entity = new NStringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        this.log.info("updateFields \u4fee\u6539\u6307\u5b9a\u5b57\u6bb5 request\uff0cindexEndpoint:{}, id:{}, fieldsMap:{}", new Object[]{indexEndpoint, id, JSONObject.toJSON(fieldsMap)});
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        this.log.info("updateFields \u4fee\u6539\u6307\u5b9a\u5b57\u6bb5 response\uff0c\u7ed3\u679c:{}", (Object)response);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseBody;
    }

    public String delete(String indexEndpoint, String id) throws Exception {
        String endpoint = indexEndpoint + id;
        Request request = new Request("DELETE", endpoint);
        this.log.info("delete \u6839\u636eID\u5220\u9664\u6570\u636e request\uff0cindexEndpoint:{}, id:{}", (Object)indexEndpoint, (Object)id);
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        this.log.info("delete \u6839\u636eID\u5220\u9664\u6570\u636e response\uff0c\u7ed3\u679c:{}", (Object)response);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseBody;
    }

    public <T> T getOne(String indexEndpoint, String id, Class<T> clazz) throws Exception {
        Object result = null;
        String endpoint = indexEndpoint + id;
        Request request = new Request("GET", endpoint);
        request.addParameter("pretty", "true");
        try {
            this.log.info("getOne \u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6570\u636e request\uff0cindexEndpoint:{}, id:{}, clazz:{}", new Object[]{indexEndpoint, id, clazz.getSimpleName()});
            Response response = this.restClient.getLowLevelClient().performRequest(request);
            this.log.info("getOne \u6839\u636e\u4e3b\u952e\u67e5\u8be2\u6570\u636e response\uff0c\u7ed3\u679c:{}", (Object)response);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = JSONObject.parseObject((String)responseBody).getJSONObject("_source");
            result = JSONObject.parseObject((String)jsonObject.toString(), clazz);
        }
        catch (ResponseException resEx) {
            if ("Not Found".equals(resEx.getResponse().getStatusLine().getReasonPhrase())) {
                return null;
            }
            this.log.error(resEx.getMessage());
            throw resEx;
        }
        return (T)result;
    }

    public <T> List<T> queryAll(String indexEndpoint, Class<T> clazz, String sortField) throws Exception {
        ArrayList<Object> resList = null;
        String endpoint = indexEndpoint + "_search";
        Request request = new Request("POST", endpoint);
        NStringEntity entity = new NStringEntity("{ \"query\": { \"match_all\": {}}, \"size\": 5000}", ContentType.APPLICATION_JSON);
        if (sortField != null) {
            entity = new NStringEntity("{ \"query\": { \"match_all\": {}}, \"sort\": \"" + sortField + "\", \"size\": 5000}", ContentType.APPLICATION_JSON);
        }
        request.setEntity((HttpEntity)entity);
        try {
            this.log.info("queryAll \u67e5\u8be2\u6240\u6709\u6570\u636e request\uff0cindexEndpoint:{}, clazz:{}", (Object)indexEndpoint, (Object)clazz.getSimpleName());
            Response response = this.restClient.getLowLevelClient().performRequest(request);
            this.log.info("queryAll \u67e5\u8be2\u6240\u6709\u6570\u636e response\uff0c\u7ed3\u679c:{}", (Object)response);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject hits = JSONObject.parseObject((String)responseBody).getJSONObject("hits");
            int hits_total = (Integer)hits.get((Object)"total");
            if (hits_total > 0) {
                JSONArray jsonArray = hits.getJSONArray("hits");
                resList = new ArrayList<Object>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    Object t = JSONObject.parseObject((String)jsonObject.get((Object)"_source").toString(), clazz);
                    resList.add(t);
                }
            }
        }
        catch (ResponseException resEx) {
            if ("Not Found".equals(resEx.getResponse().getStatusLine().getReasonPhrase())) {
                return null;
            }
            this.log.error(resEx.getMessage());
            throw resEx;
        }
        return resList;
    }

    public <T> List<T> queryByField(String indexEndpoint, String fieldName, Object fieldValue, Class<T> clazz) throws Exception {
        ArrayList<Object> resList = null;
        String endpoint = indexEndpoint + "_search";
        Request request = new Request("POST", endpoint);
        IndexRequest indexRequest = new IndexRequest();
        XContentBuilder builder = JsonXContent.contentBuilder().startObject().startObject("query").startObject("term").field(fieldName + ".keyword", fieldValue).endObject().endObject().field("sort", fieldName + ".keyword").field("size", 5000).endObject();
        indexRequest.source(builder);
        String source = indexRequest.source().utf8ToString();
        NStringEntity entity = new NStringEntity(source, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        try {
            this.log.info("queryByField \u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u6570\u636e request\uff0cindexEndpoint:{}, fieldName{}, fieldValue{} clazz:{}", new Object[]{indexEndpoint, fieldName, fieldValue, clazz.getSimpleName()});
            Response response = this.restClient.getLowLevelClient().performRequest(request);
            this.log.info("queryByField \u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2\u6570\u636e response\uff0c\u7ed3\u679c:{}", (Object)response);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject hits = JSONObject.parseObject((String)responseBody).getJSONObject("hits");
            int hits_total = (Integer)hits.get((Object)"total");
            if (hits_total > 0) {
                JSONArray jsonArray = hits.getJSONArray("hits");
                resList = new ArrayList<Object>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    Object t = JSONObject.parseObject((String)jsonObject.get((Object)"_source").toString(), clazz);
                    resList.add(t);
                }
            }
        }
        catch (ResponseException resEx) {
            if ("Not Found".equals(resEx.getResponse().getStatusLine().getReasonPhrase())) {
                return null;
            }
            this.log.error(resEx.getMessage());
            throw resEx;
        }
        return resList;
    }

    public List<String> search(Map<String, String> matchQueryMaps) throws Exception {
        ArrayList<String> resList = null;
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        SearchRequest searchRequest = new SearchRequest(new String[]{"filebeat*"});
        searchRequest.scroll(scroll);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        boolean searchKeyWord = false;
        for (Map.Entry<String, String> entry : matchQueryMaps.entrySet()) {
            if ("message".equals(entry.getKey())) {
                StringBuffer sbf = new StringBuffer();
                builder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)("\"" + entry.getValue() + "\"")).defaultField(entry.getKey()).analyzeWildcard(Boolean.valueOf(true)));
                searchKeyWord = true;
                continue;
            }
            if ("time".equals(entry.getKey())) {
                String[] queryTime = entry.getValue().split(" - ");
                builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"time").from((Object)queryTime[0].replace(" ", "T")).to((Object)queryTime[1].replace(" ", "T")));
                continue;
            }
            if ("service".equals(entry.getKey()) || "ip".equals(entry.getKey())) {
                String[] paramArr = entry.getValue().split(",");
                BoolQueryBuilder shoudBuilder = QueryBuilders.boolQuery();
                for (String param : paramArr) {
                    shoudBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)entry.getKey(), (Object)param));
                }
                builder.must((QueryBuilder)shoudBuilder);
                continue;
            }
            builder.must((QueryBuilder)QueryBuilders.matchQuery((String)entry.getKey(), (Object)entry.getValue()));
        }
        searchSourceBuilder.query((QueryBuilder)builder).timeout(new TimeValue(60L, TimeUnit.SECONDS)).size(1000);
        if (searchKeyWord) {
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            highlightBuilder.preTags(new String[]{"<span style=\"background: #ffff00;\">"});
            highlightBuilder.postTags(new String[]{"</span>"});
            highlightBuilder.field("message");
            highlightBuilder.fragmentSize(Integer.valueOf(Integer.MAX_VALUE));
            searchSourceBuilder.highlighter(highlightBuilder);
        } else {
            searchSourceBuilder.sort("time", SortOrder.DESC);
        }
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.restClient.search(searchRequest, COMMON_OPTIONS);
        if (searchResponse.getHits().totalHits == 0L) {
            return null;
        }
        if ("OK".equals(searchResponse.status().toString())) {
            SearchHit[] searchHits;
            resList = new ArrayList<String>();
            for (SearchHit hit : searchHits = searchResponse.getHits().getHits()) {
                String res = hit.getSourceAsString();
                if (hit.getHighlightFields() != null && hit.getHighlightFields().size() > 0) {
                    JSONObject resJson = JSONObject.parseObject((String)res);
                    HighlightField highlightField = (HighlightField)hit.getHighlightFields().get("message");
                    String highlighMessage = highlightField.getFragments()[0].string();
                    String repMessage = highlighMessage.replace("\\tat", "&nbsp;&nbsp;&nbsp;&nbsp;");
                    resJson.put("message", (Object)repMessage);
                    resList.add(resJson.toJSONString());
                    continue;
                }
                String repMessage = res.replace("\\tat", "&nbsp;&nbsp;&nbsp;&nbsp;");
                resList.add(repMessage);
            }
            System.out.println(searchResponse.getHits().totalHits);
        } else {
            this.log.warn("\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return resList;
    }

    public String putPipelineGrok(String pipelineId, String pattern, String timeFormat) throws Exception {
        String endpoint = "_ingest/pipeline/" + pipelineId;
        Request request = new Request("PUT", endpoint);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("description", (Object)("pipeline_" + pipelineId));
        ArrayList<JSONObject> processors = new ArrayList<JSONObject>();
        JSONObject grokProcessor = new JSONObject();
        JSONObject grok = new JSONObject();
        grok.put("field", (Object)"message");
        String[] patterns = pattern.split("&END&");
        List<String> patternList = Arrays.asList(patterns);
        grok.put("patterns", patternList);
        HashMap<String, String> patternDefs = new HashMap<String, String>();
        patternDefs.put("LOGDATETIME", "%{YEAR}-%{MONTHNUM}-%{MONTHDAY}[T ]%{ISO8601_HOUR}:?%{MINUTE}(?::?%{SECOND})");
        patternDefs.put("LOGDATETIME_EVENT", "%{YEAR}%{MONTHNUM}%{MONTHDAY}[T ]%{ISO8601_HOUR}:?%{MINUTE}(?::?%{SECOND})");
        grok.put("pattern_definitions", patternDefs);
        grokProcessor.put("grok", (Object)grok);
        processors.add(grokProcessor);
        JSONObject dateProcessor = new JSONObject();
        JSONObject date = new JSONObject();
        date.put("field", (Object)"doctime");
        date.put("target_field", (Object)"time");
        ArrayList<String> timeFormats = new ArrayList<String>();
        timeFormats.add(timeFormat);
        date.put("formats", timeFormats);
        dateProcessor.put("date", (Object)date);
        processors.add(dateProcessor);
        jsonObject.put("processors", processors);
        ArrayList<JSONObject> onFailure = new ArrayList<JSONObject>();
        JSONObject onFailureSetField = new JSONObject();
        JSONObject setField = new JSONObject();
        setField.put("field", (Object)"error");
        setField.put("value", (Object)"{{ _ingest.on_failure_message }}");
        onFailureSetField.put("set", (Object)setField);
        onFailure.add(onFailureSetField);
        jsonObject.put("on_failure", onFailure);
        NStringEntity entity = new NStringEntity(jsonObject.toString());
        request.setEntity((HttpEntity)entity);
        this.log.info("putPipelineGrok \u65b0\u589e Pipeline request\uff0cpipelineId:{}, pattern:{}", (Object)pipelineId, (Object)pattern);
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        this.log.info("putPipelineGrok \u65b0\u589e Pipeline response\uff0c\u7ed3\u679c:{}", (Object)response);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseBody;
    }

    public boolean havePipeline(String pipelineId) throws Exception {
        String endpoint = "_ingest/pipeline/" + pipelineId;
        Request request = new Request("GET", endpoint);
        try {
            this.log.info("getPipelineGrok \u67e5\u8be2 Pipeline request\uff0cpipelineId:{}", (Object)pipelineId);
            Response response = this.restClient.getLowLevelClient().performRequest(request);
            this.log.info("getPipelineGrok \u67e5\u8be2 Pipeline response\uff0c\u7ed3\u679c:{}", (Object)response);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return responseBody.indexOf(pipelineId) > 0;
        }
        catch (ResponseException resEx) {
            if ("Not Found".equals(resEx.getResponse().getStatusLine().getReasonPhrase())) {
                return false;
            }
            this.log.error(resEx.getMessage());
            throw resEx;
        }
    }

    public boolean deletePipeline(String pipelineId) throws Exception {
        String endpoint = "_ingest/pipeline/" + pipelineId;
        Request request = new Request("DELETE", endpoint);
        try {
            this.log.info("deletePipeline \u5220\u9664 Pipeline request\uff0cpipelineId:{}", (Object)pipelineId);
            Response response = this.restClient.getLowLevelClient().performRequest(request);
            this.log.info("deletePipeline \u5220\u9664 Pipeline response\uff0c\u7ed3\u679c:{}", (Object)response);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return responseBody.indexOf("true") > 0;
        }
        catch (ResponseException resEx) {
            if ("Not Found".equals(resEx.getResponse().getStatusLine().getReasonPhrase())) {
                return true;
            }
            this.log.error(resEx.getMessage());
            throw resEx;
        }
    }

    public String simulatePipeline(String pattern, String simulateMessage, String timeFormat) throws Exception {
        String endpoint = "_ingest/pipeline/_simulate";
        Request request = new Request("POST", endpoint);
        JSONObject topJson = new JSONObject();
        JSONObject pipelinJson = new JSONObject();
        pipelinJson.put("description", (Object)"pipeline_simulate");
        ArrayList<JSONObject> processors = new ArrayList<JSONObject>();
        JSONObject processor = new JSONObject();
        JSONObject grok = new JSONObject();
        grok.put("field", (Object)"message");
        String[] patterns = pattern.split("&END&");
        List<String> patternList = Arrays.asList(patterns);
        grok.put("patterns", patternList);
        HashMap<String, String> patternDefs = new HashMap<String, String>();
        patternDefs.put("LOGDATETIME", "%{YEAR}-%{MONTHNUM}-%{MONTHDAY}[T ]%{ISO8601_HOUR}:?%{MINUTE}(?::?%{SECOND})");
        patternDefs.put("LOGDATETIME_EVENT", "%{YEAR}%{MONTHNUM}%{MONTHDAY}[T ]%{ISO8601_HOUR}:?%{MINUTE}(?::?%{SECOND})");
        grok.put("pattern_definitions", patternDefs);
        processor.put("grok", (Object)grok);
        processors.add(processor);
        JSONObject dateProcessor = new JSONObject();
        JSONObject date = new JSONObject();
        date.put("field", (Object)"doctime");
        date.put("target_field", (Object)"time");
        ArrayList<String> timeFormats = new ArrayList<String>();
        timeFormats.add(timeFormat);
        date.put("formats", timeFormats);
        dateProcessor.put("date", (Object)date);
        processors.add(dateProcessor);
        pipelinJson.put("processors", processors);
        ArrayList<JSONObject> onFailure = new ArrayList<JSONObject>();
        JSONObject onFailureSetField = new JSONObject();
        JSONObject setField = new JSONObject();
        setField.put("field", (Object)"error");
        setField.put("value", (Object)"{{ _ingest.on_failure_message }}");
        onFailureSetField.put("set", (Object)setField);
        onFailure.add(onFailureSetField);
        pipelinJson.put("on_failure", onFailure);
        ArrayList docList = new ArrayList();
        HashMap docContent = new HashMap();
        HashMap<String, String> sourceContent = new HashMap<String, String>();
        sourceContent.put("message", simulateMessage);
        docContent.put("_source", sourceContent);
        docList.add(docContent);
        topJson.put("pipeline", (Object)pipelinJson);
        topJson.put("docs", docList);
        NStringEntity entity = new NStringEntity(topJson.toString());
        request.setEntity((HttpEntity)entity);
        this.log.info("simulatePipeline \u6a21\u62df\u6d4b\u8bd5 Pipeline request\uff0cpattern:{}\uff0csimulateMessage:{}", (Object)pattern, (Object)simulateMessage);
        Response response = this.restClient.getLowLevelClient().performRequest(request);
        this.log.info("simulatePipeline \u6a21\u62df\u6d4b\u8bd5 Pipeline response\uff0c\u7ed3\u679c:{}", (Object)response);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        if (responseBody.indexOf("error") < 0) {
            JSONArray docsJson = JSONObject.parseObject((String)responseBody).getJSONArray("docs");
            JSONObject resSource = ((JSONObject)docsJson.get(0)).getJSONObject("doc").getJSONObject("_source");
            this.log.info("simulatePipeline \u6a21\u62df\u6d4b\u8bd5 Pipeline response\uff0c\u7ed3\u679cdoc_Source:{}", (Object)resSource);
            return resSource.toString();
        }
        this.log.info("simulatePipeline \u6a21\u62df\u6d4b\u8bd5 Pipeline response\uff0c\u7ed3\u679cresponseBody:{}", (Object)responseBody);
        return responseBody;
    }

    static {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        COMMON_OPTIONS = builder.build();
    }
}

