/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.elsearch.rest;

import cn.com.yusys.yusp.elsearch.service.ElsearchRestService;
import cn.com.yusys.yusp.msm.common.ResultDto;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elsearch"})
public class ElsearchController {
    @Autowired
    private ElsearchRestService elsearchRestService;

    @RequestMapping(value={"/es"}, method={RequestMethod.GET})
    public ResultDto<String> getEsInfo() {
        ResultDto result = new ResultDto();
        try {
            String res = this.elsearchRestService.commonService("GET", "/", null, null);
            result.setData((Object)res);
            result.setMessage("success");
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @PostMapping(value={"/searchLog"})
    public ResultDto<List<String>> searchLog(@RequestBody Map<String, Object> params) {
        ResultDto result = new ResultDto();
        try {
            Map maps = (Map)JSONObject.parse((String)params.get("params").toString());
            List<String> res = this.elsearchRestService.search(maps);
            if (res != null) {
                List<String> resultList = this.getPagedList(Integer.parseInt(params.get("page").toString()), Integer.parseInt(params.get("size").toString()), res);
                Collections.reverse(resultList);
                result.setData(resultList);
                result.setTotal((long)res.size());
            }
            result.setMessage("success");
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private List<String> getPagedList(int page, int size, List<String> res) {
        int toIndex;
        int fromIndex;
        if (page == 0) {
            page = 1;
        }
        if ((fromIndex = (page - 1) * size) >= res.size()) {
            return Collections.emptyList();
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((toIndex = page * size) >= res.size() || size == 0) {
            toIndex = res.size();
        }
        return res.subList(fromIndex, toIndex);
    }

    @PostMapping(value={"/simulatePattern"})
    public ResultDto<String> simulatePattern(@RequestBody String params) {
        ResultDto result = new ResultDto();
        try {
            Map maps = (Map)JSONObject.parse((String)params);
            String pattern = (String)maps.get("pattern");
            String simulateMessage = (String)maps.get("simulateMessage");
            String timeFormat = (String)maps.get("timeFormat");
            if (StringUtils.isBlank((CharSequence)pattern) || StringUtils.isBlank((CharSequence)simulateMessage) || StringUtils.isBlank((CharSequence)timeFormat)) {
                throw new Exception("\u6a21\u62df\u6d4b\u8bd5\u89e3\u6790\u8868\u8fbe\u5f0f\u5408\u6cd5\u6027\uff0ctimeFormat\u5b57\u6bb5\uff0cpattern\u5b57\u6bb5\uff0csimulateMessage\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String res = this.elsearchRestService.simulatePipeline(pattern, simulateMessage, timeFormat);
            if (res.indexOf("\"error\"") > -1) {
                result.setData((Object)res);
                result.setMessage("error");
            } else {
                result.setData((Object)res);
                result.setMessage("success");
            }
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
        }
        return result;
    }
}

