/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.elsearch.config;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RestConfig {
    private static final int ADDRESS_LENGTH = 2;
    private static final String HTTP_SCHEME = "http";
    @Value(value="${elasticsearch.ip}")
    String[] ipAddress;

    @Bean
    public RestClientBuilder restClientBuilder() {
        HttpHost[] hosts = (HttpHost[])Arrays.stream(this.ipAddress).map(this::makeHttpHost).filter(Objects::nonNull).toArray(HttpHost[]::new);
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])hosts);
        Header[] defaultHeaders = new Header[]{new BasicHeader("content-type", "application/json; charset=UTF-8")};
        clientBuilder.setDefaultHeaders(defaultHeaders);
        return clientBuilder;
    }

    @Bean(name={"restClient"})
    public RestHighLevelClient highLevelClient(@Autowired RestClientBuilder restClientBuilder) {
        restClientBuilder.setMaxRetryTimeoutMillis(60000);
        return new RestHighLevelClient(restClientBuilder);
    }

    private HttpHost makeHttpHost(String s) {
        assert (StringUtils.isNotEmpty((CharSequence)s));
        String[] address = s.split(":");
        if (address.length == 2) {
            String ip = address[0];
            int port = Integer.parseInt(address[1]);
            return new HttpHost(ip, port, HTTP_SCHEME);
        }
        return null;
    }
}

