/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.websocket.service;

import cn.com.yusys.yusp.control.websocket.common.SshClient;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.repository.mapper.HostServiceDBMapper;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket/terminal/{ip}")
@Component
public class WebTerminalService {
    private static HostServiceDBMapper hostServiceDBMapper;
    private SshClient client;

    @Autowired
    public void setHostServiceDBMapper(HostServiceDBMapper hostServiceDBMapper) {
        WebTerminalService.hostServiceDBMapper = hostServiceDBMapper;
    }

    @OnOpen
    public void onOpen(Session websocketSession, @PathParam(value="ip") String ip) {
        if (StringUtils.isNotEmpty((CharSequence)ip)) {
            HostDomain host = hostServiceDBMapper.queryByHostIP(ip);
            if (host == null) {
                return;
            }
            this.client = new SshClient(host, websocketSession);
            this.client.connect();
        }
    }

    @OnMessage
    public void onMessage(String message, Session websocketSession) {
        if (this.client != null) {
            this.client.write(message);
        }
    }

    @OnClose
    public void onClose(Session websocketSession) {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    @OnError
    public void onError(Session websocketSession, Throwable error) {
        error.printStackTrace();
    }
}

