/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.websocket.service;

import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.websocket.common.SshClient;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.repository.mapper.HostServiceDBMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket/console/{instanceId}")
@Component
public class WebConsoleService {
    private static ApplicationRepository repository;
    private static HostServiceDBMapper hostServiceDBMapper;
    private static Map<String, Map<String, String>> envMap;
    private static Map<String, SshClient> sshClientMap;
    private static final String TAIL_COMMAND = "tail -f ";

    @Autowired
    public void setRepository(ApplicationRepository repository) {
        WebConsoleService.repository = repository;
    }

    @Autowired
    public void setHostServiceDBMapper(HostServiceDBMapper hostServiceDBMapper) {
        WebConsoleService.hostServiceDBMapper = hostServiceDBMapper;
    }

    @OnOpen
    public void onOpen(Session websocketSession, @PathParam(value="instanceId") String instanceId) {
        if (StringUtils.isNotEmpty((CharSequence)instanceId)) {
            SshClient client = sshClientMap.get(instanceId);
            if (client == null) {
                Map<String, String> env = this.getEvnInfo(instanceId);
                if (env == null || env.size() == 0) {
                    return;
                }
                String ip = env.get("ip");
                String logFile = env.get("logFile");
                if (StringUtils.isEmpty((CharSequence)ip)) {
                    return;
                }
                HostDomain host = hostServiceDBMapper.queryByHostIP(ip);
                if (host == null) {
                    return;
                }
                client = new SshClient(host, websocketSession);
                if (client.connect()) {
                    client.write(TAIL_COMMAND + logFile + "\r\n");
                    sshClientMap.putIfAbsent(instanceId, client);
                }
            } else {
                client.addSession(websocketSession);
            }
        }
    }

    @OnMessage
    public void onMessage(String message, Session websocketSession) {
    }

    @OnClose
    public void onClose(Session websocketSession, @PathParam(value="instanceId") String instanceId) {
        SshClient client = sshClientMap.get(instanceId);
        if (client != null) {
            client.removeSession(websocketSession);
            if (client.getSessionNum() == 0) {
                client.disconnect();
                client = null;
                sshClientMap.remove(instanceId);
            }
        }
    }

    @OnError
    public void onError(Session websocketSession, Throwable error) {
        error.printStackTrace();
    }

    private Map<String, String> getEvnInfo(String id) {
        Map<String, String> map = envMap.get(id);
        if (map == null) {
            map = new HashMap<String, String>(2);
            String env = null;
            try {
                env = repository.proxy(id, "env", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (StringUtils.isEmpty((CharSequence)env)) {
                return null;
            }
            String userDir = "";
            String logPath = "";
            String logFile = "";
            String ip = null;
            try {
                JSONObject object = JSONObject.fromObject((Object)env);
                for (Object o : object.getJSONArray("propertySources")) {
                    if ("systemProperties".equals(((JSONObject)o).getString("name"))) {
                        userDir = ((JSONObject)o).getJSONObject("properties").getJSONObject("user.dir").getString("value");
                    }
                    if (((JSONObject)o).getString("name").startsWith("applicationConfig")) {
                        JSONObject logJson = ((JSONObject)o).getJSONObject("properties").getJSONObject("logging.file");
                        JSONObject pathJson = ((JSONObject)o).getJSONObject("properties").getJSONObject("logging.path");
                        if (pathJson.size() != 0) {
                            logPath = pathJson.getString("value");
                        }
                        if (logJson.size() != 0) {
                            logFile = logJson.getString("value");
                        }
                    }
                    if (!"springCloudClientHostInfo".equals(((JSONObject)o).getString("name"))) continue;
                    ip = ((JSONObject)o).getJSONObject("properties").getJSONObject("spring.cloud.client.ip-address").getString("value");
                }
                map.put("ip", ip);
                map.put("logFile", userDir + "/" + logPath + "/" + logFile);
                envMap.putIfAbsent(id, map);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return map;
    }

    static {
        envMap = new ConcurrentHashMap<String, Map<String, String>>();
        sshClientMap = new ConcurrentHashMap<String, SshClient>();
    }
}

