/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.websocket.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.Session;

public class SshWriteThread
implements Runnable {
    private boolean isStop = false;
    private InputStream in;
    private Set<Session> sessionSet = new CopyOnWriteArraySet<Session>();
    private static final String ENCODING = "UTF-8";

    public SshWriteThread(InputStream in, Session websocketSession) {
        this.in = in;
        this.sessionSet.add(websocketSession);
    }

    public void stopThread() {
        this.isStop = true;
    }

    @Override
    public void run() {
        while (!this.isStop) {
            this.writeToWeb(this.in);
        }
    }

    public void removeSession(Session websocketSession) {
        this.sessionSet.remove(websocketSession);
        if (this.sessionSet.isEmpty()) {
            this.stopThread();
        }
    }

    public void addSession(Session websocketSession) {
        this.sessionSet.add(websocketSession);
    }

    public int getSessionNum() {
        return this.sessionSet.size();
    }

    private void writeToWeb(InputStream in) {
        try {
            int len;
            byte[] buff = new byte[8192];
            StringBuffer sb = new StringBuffer();
            while ((len = in.read(buff)) > 0) {
                sb.setLength(0);
                for (int i = 0; i < len; ++i) {
                    char c = (char)(buff[i] & 0xFF);
                    sb.append(c);
                }
                String line = new String(sb.toString().getBytes(StandardCharsets.ISO_8859_1), ENCODING);
                for (Session session : this.sessionSet) {
                    if (session == null || !session.isOpen()) continue;
                    session.getBasicRemote().sendText(line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

