/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.websocket.common;

import ch.ethz.ssh2.Connection;
import cn.com.yusys.yusp.control.websocket.common.SshWriteThread;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.websocket.Session;

public class SshClient {
    private HostDomain hostDomain;
    private int port;
    private Session websocketSession;
    private Connection conn = null;
    private ch.ethz.ssh2.Session ssh2Session = null;
    private SshWriteThread writeThread = null;
    private BufferedWriter out = null;

    public SshClient(HostDomain hostDomain, Session websocketSession) {
        this(hostDomain, 22, websocketSession);
    }

    public SshClient(HostDomain hostDomain, int port, Session websocketSession) {
        this.hostDomain = hostDomain;
        this.port = port;
        this.websocketSession = websocketSession;
    }

    public boolean connect() {
        try {
            String ip = this.hostDomain.getIp();
            String userName = this.hostDomain.getUserName();
            String password = this.hostDomain.getPassword();
            this.conn = new Connection(ip, this.port);
            this.conn.connect();
            boolean isAuthenticated = this.conn.authenticateWithPassword(userName, password);
            if (isAuthenticated) {
                this.ssh2Session = this.conn.openSession();
                this.ssh2Session.requestPTY("xterm", 175, 45, 0, 0, null);
                this.ssh2Session.startShell();
                this.startWriterThread();
                this.out = new BufferedWriter(new OutputStreamWriter(this.ssh2Session.getStdin(), "utf-8"));
                return true;
            }
            System.out.println("\u7528\u6237\u540d\u548c\u5bc6\u7801\u6821\u9a8c\u51fa\u9519\uff0c\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25...");
            this.disconnect();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disconnect();
            return false;
        }
    }

    private void startWriterThread() {
        this.writeThread = new SshWriteThread(this.ssh2Session.getStdout(), this.websocketSession);
        new Thread(this.writeThread).start();
    }

    public void disconnect() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.ssh2Session != null) {
            this.ssh2Session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.writeThread != null) {
            this.writeThread.stopThread();
        }
    }

    public boolean write(String cmd) {
        try {
            this.out.write(cmd);
            this.out.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void removeSession(Session websocketSession) {
        if (this.writeThread != null) {
            this.writeThread.removeSession(websocketSession);
        }
    }

    public void addSession(Session websocketSession) {
        if (this.writeThread != null) {
            this.writeThread.addSession(websocketSession);
        }
    }

    public int getSessionNum() {
        if (this.writeThread != null) {
            return this.writeThread.getSessionNum();
        }
        return 0;
    }
}

