/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.middleware.service;

import cn.com.yusys.yusp.control.middleware.domain.MiddleWareInfo;
import cn.com.yusys.yusp.control.middleware.repository.MiddleWareInfoRepository;
import cn.com.yusys.yusp.control.middleware.service.DeployTaskService;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.exception.DashboardSessionException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MiddleWareInfoService {
    @Autowired
    private MiddleWareInfoRepository middleWareInfoRepository;
    @Autowired
    private DeployTaskService deployTaskService;

    public void addInfo(MiddleWareInfo info) throws DashboardFileException {
        this.middleWareInfoRepository.addInfo(info);
    }

    public void delInfo(String ids) throws DashboardFileException {
        this.middleWareInfoRepository.delInfo(ids);
    }

    public List<MiddleWareInfo> getInfoListByUserId(String userId) throws DashboardSessionException {
        List<MiddleWareInfo> list = this.middleWareInfoRepository.getInfoListByUserId(userId);
        for (MiddleWareInfo info : list) {
            boolean flag = this.deployTaskService.getMiddleWareStatus(info.getMiddleWareName(), info.getHostName());
            if (flag) {
                info.setStatus(1);
                continue;
            }
            info.setStatus(-1);
        }
        return list;
    }

    public List<MiddleWareInfo> getInfoListByids(String ids) {
        ArrayList<MiddleWareInfo> list = new ArrayList<MiddleWareInfo>();
        for (String id : ids.split(",")) {
            list.add(this.middleWareInfoRepository.getInfoByid(id));
        }
        return list;
    }

    public MiddleWareInfo getInfoByid(String id) {
        return this.middleWareInfoRepository.getInfoByid(id);
    }
}

