/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.middleware.service;

import cn.com.yusys.yusp.control.middleware.domain.DeployTask;
import cn.com.yusys.yusp.control.middleware.domain.MiddleWareInfo;
import cn.com.yusys.yusp.control.middleware.repository.DeployTaskRepository;
import cn.com.yusys.yusp.control.middleware.service.MiddleWareInfoService;
import cn.com.yusys.yusp.control.middleware.service.MiddleWareService;
import cn.com.yusys.yusp.control.middleware.utils.MiddleWareConstants;
import cn.com.yusys.yusp.msm.common.DashboardCmdPair;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.host.repository.HostRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeployTaskService {
    @Autowired
    private DeployTaskRepository deployTaskRepository;
    @Autowired
    private HostRepository hostRepository;
    @Autowired
    private MiddleWareConstants middleWareConstants;
    @Autowired
    private MiddleWareService middleWareService;
    @Autowired
    private MiddleWareInfoService middleWareInfoService;

    public void addDeployTask(DeployTask deployTask) throws DashboardFileException {
        this.deployTaskRepository.addDeployTask(deployTask);
    }

    public void delDeployTask(String ids) throws DashboardFileException {
        this.deployTaskRepository.delDeployTask(ids);
    }

    public List<DeployTask> getDeployTaskSuccessfulList(String userId) {
        ArrayList<DeployTask> list = new ArrayList<DeployTask>();
        for (DeployTask task : this.getDeployTaskList(userId)) {
            if (task.getFlag() != 2) continue;
            list.add(task);
        }
        return list;
    }

    public List<DeployTask> getDeployTaskFailedList(String userId) {
        ArrayList<DeployTask> list = new ArrayList<DeployTask>();
        for (DeployTask task : this.getDeployTaskList(userId)) {
            if (task.getFlag() != -1) continue;
            list.add(task);
        }
        return list;
    }

    public List<DeployTask> getDeployTaskNotFailList(String userId) {
        ArrayList<DeployTask> list = new ArrayList<DeployTask>();
        for (DeployTask task : this.getDeployTaskList(userId)) {
            if (task.getFlag() != 2 && task.getFlag() != 1) continue;
            list.add(task);
        }
        return list;
    }

    public List<DeployTask> getDeployTaskList(String userId) {
        if (userId == null || userId.equals("")) {
            return this.deployTaskRepository.getDeployTaskList();
        }
        return this.deployTaskRepository.getDeployTaskListByUserId(userId);
    }

    public List<DeployTask> getDeployTaskListByIds(String ids) {
        ArrayList<DeployTask> list = new ArrayList<DeployTask>();
        for (String id : Arrays.asList(ids.split(","))) {
            list.add(this.deployTaskRepository.getDeployTaskByid(id));
        }
        return list;
    }

    public boolean getMiddleWareStatus(String middleName, String hostName) throws DashboardSessionException {
        boolean flag = false;
        try {
            String basePath = this.middleWareConstants.getTargetBasePath();
            String cmd = basePath + "monitor.sh " + middleName;
            DashboardCmdPair result = this.hostRepository.goCmd(hostName, "", cmd);
            flag = result.getOut().replaceAll("\n", "").length() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public void stop(String id) throws Exception {
        try {
            MiddleWareInfo info = this.middleWareInfoService.getInfoByid(id);
            if (this.getMiddleWareStatus(info.getMiddleWareName(), info.getHostName())) {
                String basePath = this.middleWareConstants.getTargetBasePath();
                String cmd = basePath + "stop.sh " + info.getMiddleWareName();
                DashboardCmdPair result = this.hostRepository.goCmd(info.getHostName(), "", cmd);
                System.out.println(result.getOut());
                if (result.getOut().contains("err")) {
                    throw new DashboardFileException(result.getOut());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void start(String id, String startConfig) throws Exception {
        try {
            MiddleWareInfo info = this.middleWareInfoService.getInfoByid(id);
            String pid = "";
            if (!this.getMiddleWareStatus(info.getMiddleWareName(), info.getHostName())) {
                String basePath = this.middleWareConstants.getTargetBasePath();
                String startFile = this.middleWareService.getMiddleWare(info.getMiddleWareName(), info.getMiddleWareVersion()).getStartFile();
                String path = startFile.substring(0, startFile.lastIndexOf("/") + 1);
                String file = "./" + startFile.substring(startFile.lastIndexOf("/") + 1, startFile.length());
                String cmd = basePath + "start.sh " + path + " " + file + " " + startConfig;
                DashboardCmdPair result = this.hostRepository.goCmd(info.getHostName(), "", cmd);
                pid = result.getOut().replace("\n", "");
                if (result.getOut().contains("err")) {
                    throw new DashboardFileException(result.getOut());
                }
                info.setPid(pid);
                info.setStartConfig(startConfig);
                this.middleWareInfoService.addInfo(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean countString(String str, String s) {
        int count = 0;
        while (str.indexOf(s) != -1) {
            str = str.substring(str.indexOf(s) + 1, str.length());
            if (++count < 3) continue;
            return true;
        }
        return false;
    }
}

