/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.middleware.repository;

import cn.com.yusys.yusp.control.middleware.domain.MiddleWareInfo;
import cn.com.yusys.yusp.msm.config.CommonProperties;
import cn.com.yusys.yusp.msm.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.log.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class MiddleWareInfoRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(MiddleWareInfoRepository.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public MiddleWareInfoRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{MiddleWareInfo.class});
    }

    public void addInfo(MiddleWareInfo info) throws DashboardFileException {
        List<MiddleWareInfo> list = this.getInfoList();
        boolean update = false;
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getId().equals(info.getId())) {
                update = true;
                index = i;
                break;
            }
            if (list.get(i).getDeployTaskId().equals(info.getDeployTaskId())) {
                info.setId(list.get(i).getId());
                update = true;
                index = i;
                break;
            }
            if (!list.get(i).equals(info)) continue;
            info.setId(list.get(i).getId());
            update = true;
            index = i;
            break;
        }
        if (update) {
            list.set(index, info);
        } else {
            list.add(info);
        }
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            this.log.error("\u6dfb\u52a0\u5931\u8d25: " + info + " error: " + e.getMessage());
            throw e;
        }
    }

    public void delInfo(String ids) throws DashboardFileException {
        List<MiddleWareInfo> list = this.getInfoList();
        ArrayList<MiddleWareInfo> removeList = null;
        List<String> idList = Arrays.asList(ids.split(","));
        for (MiddleWareInfo dr : list) {
            if (!idList.contains(dr.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<MiddleWareInfo>();
            }
            removeList.add(dr);
        }
        if (removeList == null) {
            return;
        }
        list.removeAll(removeList);
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.log.error("\u5220\u9664\u5931\u8d25: " + Arrays.asList(ids) + " error: " + e.getMessage());
            throw e;
        }
    }

    public List<MiddleWareInfo> getInfoList() {
        ArrayList<MiddleWareInfo> list = (ArrayList<MiddleWareInfo>)this.getLoadObj();
        if (list == null) {
            list = new ArrayList<MiddleWareInfo>();
        }
        Collections.sort(list, new Comparator<MiddleWareInfo>(){

            @Override
            public int compare(MiddleWareInfo o1, MiddleWareInfo o2) {
                try {
                    if (MiddleWareInfoRepository.this.sdf.parse(o1.getCreatedTime()).getTime() <= MiddleWareInfoRepository.this.sdf.parse(o2.getCreatedTime()).getTime()) {
                        return 1;
                    }
                    return -1;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        return list;
    }

    public List<MiddleWareInfo> getInfoListByUserId(String userId) {
        ArrayList<MiddleWareInfo> list = new ArrayList<MiddleWareInfo>();
        ArrayList list0 = (ArrayList)this.getLoadObj();
        if (list0 == null) {
            list0 = new ArrayList();
        }
        for (MiddleWareInfo result : list0) {
            if (!result.getUserId().equals(userId)) continue;
            list.add(result);
        }
        return list;
    }

    public MiddleWareInfo getInfoByid(String id) {
        MiddleWareInfo info = null;
        List list0 = (List)this.getLoadObj();
        if (list0 == null) {
            info = new MiddleWareInfo();
        }
        for (MiddleWareInfo result : list0) {
            if (!result.getId().equals(id)) continue;
            info = result;
        }
        return info;
    }
}

