/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.web.rest;

import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.DeployInfoHistory;
import cn.com.yusys.yusp.control.governance.domain.InstallInfo;
import cn.com.yusys.yusp.control.governance.install.DeployStatus;
import cn.com.yusys.yusp.control.governance.service.ApplicationInstallService;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.resource.Resource;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.websocket.server.PathParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/applicationinstall"})
public class ApplicationInstallResource
extends Resource {
    private final Logger logger = LoggerFactory.getLogger(ApplicationInstallResource.class);

    ApplicationInstallService ApplicationInstallService() {
        return (ApplicationInstallService)this.getService(ApplicationInstallService.class);
    }

    @PostMapping(value={"/install"})
    public ResultDto<String> install(@RequestBody InstallInfo installInfo) {
        this.logger.debug("installInfo:{}", (Object)installInfo);
        this.ApplicationInstallService().install(installInfo.getVersionInfo(), installInfo.getHostInfoList());
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/reinstall"})
    public ResultDto<String> reInstall(@RequestBody InstallInfo installInfo) {
        this.logger.debug("installInfo:{}", (Object)installInfo);
        this.ApplicationInstallService().reInstall(installInfo.getVersionInfo(), installInfo.getInstanceList());
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/remove"})
    public ResultDto<String> remove(@RequestBody InstallInfo installInfo) {
        this.logger.debug("instance:{}", (Object)installInfo);
        try {
            this.ApplicationInstallService().remove(installInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(10000, 0L, "\u79fb\u9664\u5931\u8d25,\u539f\u56e0:" + e.getMessage(), (Object)"failed");
        }
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/hostlist"})
    public ResultDto<Collection<HostDomain>> hostList(@RequestParam(value="name", required=false) String name, @RequestParam(value="cluster", required=false) String cluster, @RequestParam(value="page", required=false) int page, @RequestParam(value="size", required=false) int size) {
        List<HostDomain> collection = null;
        ArrayList<HostDomain> hostList = new ArrayList<HostDomain>();
        if (StringUtils.isBlank((CharSequence)cluster)) {
            this.logger.debug("Query hostList with name= {}", (Object)name);
            collection = this.ApplicationInstallService().findUnUsedHostList(name);
        } else {
            this.logger.debug("Query hostList with cluster= {}", (Object)cluster);
            collection = this.ApplicationInstallService().findUnUsedHostListByCluster(name, cluster);
        }
        for (int i = (page - 1) * size; i < collection.size() && hostList.size() < size; ++i) {
            hostList.add(collection.get(i));
        }
        return new ResultDto((long)collection.size(), hostList);
    }

    @GetMapping(value={"/history"})
    public ResultDto<List<DeployInfoHistory>> queryHistory(@PathParam(value="serviceName") String serviceName) {
        this.logger.debug("queryHistory with  appName={}", (Object)serviceName);
        List<DeployInfoHistory> list = this.ApplicationInstallService().queryHistory(serviceName);
        List deployInfoHistoryList = list.stream().sorted((s1, s2) -> s2.getUpdateTime().compareTo(s1.getUpdateTime())).collect(Collectors.toList());
        return new ResultDto(deployInfoHistoryList);
    }

    @GetMapping(value={"/log"})
    public ResultDto<String> queryStartLog(@PathParam(value="hostName") String hostName, @PathParam(value="logFile") String logFile) {
        this.logger.debug("queryInstallLog with hostName={}, appName={}", (Object)hostName, (Object)logFile);
        return new ResultDto((Object)this.ApplicationInstallService().queryStartLog(hostName, logFile, 0, 0));
    }

    @GetMapping(value={"/deploy"})
    public ResultDto<List<DeployInfo>> getDeployList(@PathParam(value="status") String status) {
        List list = this.ApplicationInstallService().queryDeployInfoList().stream().sorted((s1, s2) -> s2.getOpDate() != null ? s2.getOpDate().compareTo(s1.getOpDate()) : 1).collect(Collectors.toList());
        List deployList = "1".equals(status) ? list.stream().filter(d -> StringUtils.isEmpty((CharSequence)d.getEndTime())).collect(Collectors.toList()) : ("2".equals(status) ? list.stream().filter(d -> !StringUtils.isEmpty((CharSequence)d.getEndTime()) && d.getDeployNo() != DeployStatus.RUNNING.getStepNo()).collect(Collectors.toList()) : ("3".equals(status) ? list.stream().filter(d -> d.getDeployNo() == DeployStatus.RUNNING.getStepNo()).collect(Collectors.toList()) : list));
        return new ResultDto(deployList);
    }
}

