/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.repository.ServiceInfoRepository;
import cn.com.yusys.yusp.control.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.msm.ssh.Utils;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@EnableConfigurationProperties(value={ServiceFileProperties.class})
@Service
@StorageType(serviceType="file")
public class ServiceInfoServiceFileImpl
implements ServiceInfoService {
    private final Logger logger = LoggerFactory.getLogger(ServiceInfoServiceFileImpl.class);
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;
    @Autowired
    private ServiceFileProperties serviceFileProperties;

    @Override
    public List<ServiceInfoDomain> getServicesInfo() {
        this.logger.debug("\u83b7\u53d6\u670d\u52a1\u5217\u8868\u4fe1\u606f");
        return this.serviceInfoRepository.getServiceInfos();
    }

    @Override
    public List<ServiceInfoDomain> getServiceInfoListByCluster(String cluster) {
        return this.serviceInfoRepository.getServiceInfoListByCluster(cluster);
    }

    @Override
    public List<ServiceInfoDomain> getServicesInfoByName(String name) {
        this.logger.info("\u6839\u636e\u4e1a\u52a1\u9886\u57df\u540d\u79f0:{}\uff0c\u83b7\u53d6\u670d\u52a1\u5217\u8868", (Object)name);
        return this.serviceInfoRepository.getServiceInfos().stream().filter(list -> list.getName().equals(name)).collect(Collectors.toList());
    }

    @Override
    public boolean isJenkinsBuildNameExisted(String jenkinsBuildName, String id) {
        return this.serviceInfoRepository.getServiceInfos().stream().filter(service -> service.getJenkinsBuildName().equals(jenkinsBuildName)).findAny().isPresent();
    }

    @Override
    public Collection<VersionInfo> getVersionByName(String name) {
        this.logger.debug("\u8bf7\u6c42\u670d\u52a1:{}\u7684\u7248\u672c\u4fe1\u606f", (Object)name);
        if (StringUtils.isEmpty((CharSequence)name)) {
            return new ArrayList<VersionInfo>();
        }
        return this.serviceInfoRepository.getVersionByName(name).values();
    }

    @Override
    public int updateService(ServiceInfoDomain domain) {
        this.logger.debug("\u6dfb\u52a0\u670d\u52a1:Service:{}", (Object)domain);
        if (!domain.validate()) {
            return 2;
        }
        if (StringUtils.isEmpty((CharSequence)domain.getId())) {
            domain.setId(Utils.getUuid());
        }
        return this.serviceInfoRepository.updateService(domain, true);
    }

    @Override
    public int updateExpandShrinkDetails(ServiceInfoDomain domain) {
        this.logger.debug("\u6dfb\u52a0\u6536\u7f29\u8be6\u60c5:Service:{}", (Object)domain);
        return this.serviceInfoRepository.updateExpandShrinkDetails(domain, true);
    }

    @Override
    public int removeService(String ids) {
        this.logger.debug("\u5220\u9664\u670d\u52a1:service:{}", (Object)ids);
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return 1;
        }
        return this.serviceInfoRepository.removeService(ids);
    }

    @Override
    public int removeVersion(String serviceName, String fileList) {
        return this.serviceInfoRepository.removeVersion(serviceName, fileList);
    }

    @Override
    public String getDependJar(String serviceName, String fileName) {
        this.logger.debug("\u83b7\u53d6\u670d\u52a1:{}\u7684\u4f9d\u8d56jar", (Object)serviceName);
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return "\u670d\u52a1\u540d\u4e3a\u7a7a";
        }
        String path = this.serviceFileProperties.getPath(serviceName);
        StringBuffer sb = new StringBuffer();
        String command = "jar -tf " + path + fileName;
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(runtime.exec(command).getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains(".jar")) continue;
                sb.append(line + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public int uploadFile(MultipartFile file, VersionInfo versionInfo) {
        File fileDir;
        String serviceName = versionInfo.getName();
        String originalFilename = file.getOriginalFilename();
        String outFileName = versionInfo.getVersion() + "_" + originalFilename;
        String path = this.serviceFileProperties.getPath(serviceName);
        this.logger.info("\u4e0a\u4f20\u670d\u52a1:{}\u5bf9\u5e94\u8d44\u6e90\u5305", (Object)serviceName);
        File outfile = new File(path + outFileName);
        if (!(outfile.exists() || (fileDir = new File(path)).exists() && fileDir.isDirectory())) {
            fileDir.mkdir();
        }
        try (InputStream is = file.getInputStream();
             FileOutputStream os = new FileOutputStream(outfile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        int success = 1;
        return success;
    }

    @Override
    public int saveNodeInfo(String coordinate) {
        return this.serviceInfoRepository.saveNodeInfo(coordinate, true);
    }

    @Override
    public ServiceInfoDomain getServiceInfoByName(String name) {
        return this.serviceInfoRepository.getServiceInfoByName(name);
    }

    @Override
    public List<VersionInfo> getFileByServiceName(String serviceName) {
        this.logger.info("\u6839\u636e\u670d\u52a1\u540d\u83b7\u53d6\u7248\u672c\u6587\u4ef6\u5217\u8868");
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return new ArrayList<VersionInfo>();
        }
        return this.serviceInfoRepository.getFileByServiceName(serviceName);
    }

    @Override
    public List<VersionInfo> getServiceBasicInfo(String serviceName) {
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return new ArrayList<VersionInfo>();
        }
        return this.serviceInfoRepository.getServiceBasicInfo(serviceName);
    }

    @Override
    public List<Map<String, String>> getServiceNameList(String clusterId) {
        ArrayList<Map<String, String>> serviceNameList = new ArrayList<Map<String, String>>();
        List<Object> serviceInfoDomainList = new ArrayList();
        serviceInfoDomainList = clusterId != null && clusterId != "" ? this.getServiceInfoListByCluster(clusterId) : this.getServicesInfo();
        if (serviceInfoDomainList != null && !serviceInfoDomainList.isEmpty()) {
            for (ServiceInfoDomain serviceInfoDomain : serviceInfoDomainList) {
                String serviceName = serviceInfoDomain.getName();
                List<VersionInfo> fileList = this.getFileByServiceName(serviceName);
                if (fileList == null || fileList.isEmpty()) continue;
                HashMap<String, String> serviceMap = new HashMap<String, String>();
                serviceMap.put("key", serviceInfoDomain.getName());
                serviceMap.put("value", serviceInfoDomain.getName());
                serviceNameList.add(serviceMap);
            }
        } else {
            return new ArrayList<Map<String, String>>();
        }
        this.logger.info("\u67e5\u8be2\u7248\u672c\u4e0d\u4e3a\u7a7a\u7684\u670d\u52a1\uff0c\u6210\u529f\uff0c\u8fd4\u56de\u670d\u52a1\u540d\u5217\u8868");
        return serviceNameList;
    }
}

