/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.control.governance.domain.ServiceFlexInfo;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.executor.ServiceFileUtil;
import cn.com.yusys.yusp.control.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallHistoryServiceDBMapper;
import cn.com.yusys.yusp.control.repository.mapper.IndexDomainMapper;
import cn.com.yusys.yusp.control.repository.mapper.MsDeployMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceFlexHistoryMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceFlexMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceLimiterMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.user.repository.mapper.ClusterRelMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@EnableConfigurationProperties(value={ServiceFileProperties.class})
@Service
@StorageType(serviceType="database")
public class ServiceInfoServiceDBImpl
implements ServiceInfoService {
    private final Logger logger = LoggerFactory.getLogger(ServiceInfoServiceDBImpl.class);
    @Autowired
    private ServiceInfoMapper serviceInfoMapper;
    @Autowired
    private MsDeployMapper msDeployMapper;
    @Autowired
    private ApplicationInstallHistoryServiceDBMapper applicationInstallHistoryServiceDBMapper;
    @Autowired
    private ClusterRelMapper clusterRelMapper;
    @Autowired
    private ServiceFlexMapper serviceFlexMapper;
    @Autowired
    private ServiceFlexHistoryMapper serviceFlexHistoryMapper;
    @Autowired
    private IndexDomainMapper indexDomainMapper;
    @Autowired
    private ServiceLimiterMapper serviceLimiterMapper;
    @Autowired
    private ServiceFileProperties serviceFileProperties;
    public static final String SUCCESS = "\u6210\u529f";
    public static final String FAILURE = "\u5931\u8d25";

    @Override
    public List<ServiceInfoDomain> getServicesInfo() {
        this.logger.debug("\u83b7\u53d6\u670d\u52a1\u5217\u8868\u4fe1\u606f");
        List<ServiceInfoDomain> list = this.serviceInfoMapper.getServicesInfo();
        return this.getExtraInfo(list);
    }

    @Override
    public List<ServiceInfoDomain> getServiceInfoListByCluster(String cluster) {
        return this.getExtraInfo(this.serviceInfoMapper.getServiceInfoListByCluster(cluster));
    }

    private List<ServiceInfoDomain> getExtraInfo(List<ServiceInfoDomain> list) {
        for (ServiceInfoDomain domain : list) {
            List clusterIds = this.clusterRelMapper.getClusterIdFromServiceClusterRelByServiceId(domain.getId());
            domain.setClusters(clusterIds);
            domain.setClusterNum(clusterIds.size());
            domain.setIndexDomains(this.indexDomainMapper.getIndexByName(domain.getName()));
        }
        return list;
    }

    @Override
    public List<ServiceInfoDomain> getServicesInfoByName(String name) {
        this.logger.info("\u6839\u636e\u4e1a\u52a1\u9886\u57df\u540d\u79f0:{}\uff0c\u83b7\u53d6\u670d\u52a1\u5217\u8868", (Object)name);
        ServiceInfoDomain domain = this.serviceInfoMapper.getServiceInfoByName(name);
        if (null == domain) {
            return new ArrayList<ServiceInfoDomain>();
        }
        return new ArrayList<ServiceInfoDomain>(Arrays.asList(domain));
    }

    @Override
    public boolean isJenkinsBuildNameExisted(String jenkinsBuildName, String id) {
        return this.serviceInfoMapper.isJenkinsBuildNameExisted(jenkinsBuildName, id) > 0;
    }

    @Override
    public Collection<VersionInfo> getVersionByName(String name) {
        return null;
    }

    @Override
    public int updateService(ServiceInfoDomain domain) {
        int returnFlag = 0;
        if (StringUtils.isEmpty((CharSequence)domain.getId())) {
            domain.setId(UUID.randomUUID().toString());
            this.addServiceClusterRel(domain.getId(), domain.getClusters());
            ServiceFlexInfo flexInfo = new ServiceFlexInfo(UUID.randomUUID().toString(), domain.getId(), String.valueOf(domain.getExpandShrinkFrequency()), String.valueOf(domain.getExpandMax()), String.valueOf(domain.getShrinkMin()), domain.getExpandShrinkStrategy());
            this.serviceFlexMapper.addServiceFlex(flexInfo);
            returnFlag = this.serviceInfoMapper.addService(domain);
            if (returnFlag == 1) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u65b0\u589e\u670d\u52a1\u4fe1\u606f[{}]->{}", (Object[])new Object[]{domain.getName(), SUCCESS});
            } else {
                LogUtil.error((Object)ModulNameConstant.SERVICE_INFO, (String)"\u65b0\u589e\u670d\u52a1\u4fe1\u606f[{}]->{}", (Object[])new Object[]{domain.getName(), FAILURE});
            }
        } else {
            this.clusterRelMapper.deleteServiceClusterRel(domain.getId());
            this.addServiceClusterRel(domain.getId(), domain.getClusters());
            returnFlag = this.serviceInfoMapper.updateService(domain);
            if (returnFlag == 1) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u66f4\u65b0\u670d\u52a1\u4fe1\u606f[{}]->{}", (Object[])new Object[]{domain.getName(), SUCCESS});
            } else {
                LogUtil.error((Object)ModulNameConstant.SERVICE_INFO, (String)"\u66f4\u65b0\u670d\u52a1\u4fe1\u606f[{}]->{}", (Object[])new Object[]{domain.getName(), FAILURE});
            }
        }
        String relId = this.serviceInfoMapper.getServiceInfoRelByServiceId(domain.getId());
        if (relId != null && !relId.equals("")) {
            this.serviceInfoMapper.updateServiceInfoRel(domain.getId(), String.join((CharSequence)",", domain.getDependService()));
        } else {
            this.serviceInfoMapper.insertServiceInfoRel(UUID.randomUUID().toString(), domain.getId(), domain.getOffsetX() == null ? "0" : domain.getOffsetX(), domain.getOffsetY() == null ? "0" : domain.getOffsetY(), String.join((CharSequence)",", domain.getDependService()));
        }
        return returnFlag;
    }

    private void addServiceClusterRel(String serviceId, List<String> clusterIds) {
        for (String clusterId : clusterIds) {
            String id = UUID.randomUUID().toString();
            this.clusterRelMapper.addServiceClusterRel(id, serviceId, clusterId);
        }
    }

    @Override
    public int updateExpandShrinkDetails(ServiceInfoDomain domain) {
        List<ServiceInfoDomain> serviceInfoDomainList = this.serviceInfoMapper.getServicesInfo();
        for (ServiceInfoDomain service : serviceInfoDomainList) {
            ServiceFlexInfo serviceFlexInfo;
            if (!service.getName().equals(domain.getName()) || (serviceFlexInfo = this.serviceFlexMapper.selectFlexByService(service.getId())) == null) continue;
            serviceFlexInfo.setExpandShrinkFrequency(String.valueOf(domain.getExpandShrinkFrequency()));
            serviceFlexInfo.setExpandMax(String.valueOf(domain.getExpandMax()));
            serviceFlexInfo.setShrinkMin(String.valueOf(domain.getShrinkMin()));
            serviceFlexInfo.setExpandShrinkStrategy(domain.getExpandShrinkStrategy());
            if (this.serviceFlexMapper.updateServiceFlex(serviceFlexInfo) == 1) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u6dfb\u52a0\u6536\u7f29\u8be6\u60c5[{}]->{}", (Object[])new Object[]{domain.getName(), SUCCESS});
                return 0;
            }
            LogUtil.error((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u6dfb\u52a0\u6536\u7f29\u8be6\u60c5[{}]->{}", (Object[])new Object[]{domain.getName(), FAILURE});
            return 1;
        }
        LogUtil.error((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u6dfb\u52a0\u6536\u7f29\u8be6\u60c5[{}]->{}", (Object[])new Object[]{domain.getName(), FAILURE});
        return 1;
    }

    @Override
    public int removeService(String id) {
        this.logger.debug("\u5220\u9664\u670d\u52a1:service:{}", (Object)id);
        if (StringUtils.isEmpty((CharSequence)id)) {
            return 1;
        }
        String serviceName = this.serviceInfoMapper.getServiceByServiceId(id).getName();
        this.removeVersion(serviceName, "");
        this.indexDomainMapper.removeIndexByServiceName(serviceName);
        this.clusterRelMapper.deleteServiceClusterRel(id);
        this.serviceLimiterMapper.deleteLimitByServiceId(id);
        List<ServiceInfoDomain> list = this.serviceInfoMapper.getServicesInfo();
        HashMap<String, String> dependServiceMap = new HashMap<String, String>();
        for (ServiceInfoDomain s : list) {
            if (s.getDependService() == null || s.getDependService().size() <= 0 || !s.getDependService().contains(serviceName)) continue;
            ArrayList<String> l = new ArrayList<String>();
            for (String sName : s.getDependService()) {
                if (sName.equals(serviceName)) continue;
                l.add(sName);
            }
            if (l.size() == 0) {
                dependServiceMap.put(s.getId(), "");
                continue;
            }
            dependServiceMap.put(s.getId(), String.join((CharSequence)",", l));
        }
        if (!dependServiceMap.isEmpty()) {
            this.serviceInfoMapper.updateDependService(dependServiceMap);
        }
        this.serviceInfoMapper.deleteServiceInfoRel(id);
        this.serviceFlexMapper.removeServiceFlex(id);
        this.serviceFlexHistoryMapper.removeFlexHistory(serviceName);
        this.msDeployMapper.removeDeployByName(serviceName);
        this.applicationInstallHistoryServiceDBMapper.deleteHistoryByName(serviceName);
        int flag = this.serviceInfoMapper.removeService(id);
        if (flag == 1) {
            LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u5220\u9664\u670d\u52a1\u4fe1\u606f[{}]->{}", (Object[])new Object[]{serviceName, SUCCESS});
        } else {
            LogUtil.error((Object)ModulNameConstant.SERVICE_INFO, (String)"\u5220\u9664\u670d\u52a1\u4fe1\u606f[{}]->{}", (Object[])new Object[]{serviceName, FAILURE});
        }
        return flag;
    }

    @Override
    public int removeVersion(String serviceName, String fileList) {
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            File[] files;
            String path = this.serviceFileProperties.getPath(serviceName);
            File dirFile = new File(path);
            if (!dirFile.exists()) {
                this.logger.info("\u670d\u52a1:{}\u7684\u7248\u672c\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (Object)serviceName);
                return 0;
            }
            if (StringUtils.isNotEmpty((CharSequence)fileList)) {
                String[] files2;
                for (String file : files2 = fileList.split(",")) {
                    File tempfile = new File(path + file);
                    if (tempfile.exists()) {
                        if (tempfile.delete()) {
                            this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u6210\u529f", (Object)serviceName, (Object)file);
                            continue;
                        }
                        this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u5931\u8d25", (Object)serviceName, (Object)file);
                        LogUtil.error((Object)ModulNameConstant.SERVICE_INFO, (String)"\u5220\u9664\u670d\u52a1[{}]\u7248\u672c\u4fe1\u606f[{}]->{}", (Object[])new Object[]{serviceName, fileList, FAILURE});
                        return 1;
                    }
                    this.logger.info("\u670d\u52a1:{}\u7684\u7248\u672c:{}\u4e0d\u5b58\u5728", (Object)serviceName, (Object)file);
                }
                LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u5220\u9664\u670d\u52a1[{}]\u7248\u672c\u4fe1\u606f[{}]->{}", (Object[])new Object[]{serviceName, fileList, SUCCESS});
                return 0;
            }
            for (File file : files = dirFile.listFiles()) {
                if (file.exists()) {
                    if (file.delete()) {
                        this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u6210\u529f", (Object)serviceName, (Object)file.getName());
                        LogUtil.info((Object)ModulNameConstant.SERVICE_INFO, (String)"\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c\u6587\u4ef6:{},\u6210\u529f", (Object[])new Object[]{serviceName, file.getName()});
                        continue;
                    }
                    this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u5931\u8d25", (Object)serviceName, (Object)file.getName());
                    LogUtil.error((Object)ModulNameConstant.SERVICE_INFO, (String)"\u5220\u9664\u670d\u52a1[{}]\u7248\u672c\u4fe1\u606f[{}]->{}", (Object[])new Object[]{serviceName, fileList, FAILURE});
                    return 1;
                }
                this.logger.info("\u670d\u52a1:{}\u7684\u7248\u672c:{}\u4e0d\u5b58\u5728", (Object)serviceName, (Object)file.getName());
            }
            if (dirFile.delete()) {
                this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u6587\u4ef6\u5939,\u6210\u529f", (Object)serviceName);
                return 0;
            }
            this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u6587\u4ef6\u5939,\u5931\u8d25", (Object)serviceName);
            return 1;
        }
        return 1;
    }

    @Override
    public String getDependJar(String serviceName, String fileName) {
        this.logger.debug("\u83b7\u53d6\u670d\u52a1:{}\u7684\u4f9d\u8d56jar", (Object)serviceName);
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return "\u670d\u52a1\u540d\u4e3a\u7a7a";
        }
        String path = this.serviceFileProperties.getPath(serviceName);
        StringBuffer sb = new StringBuffer();
        String command = "jar -tf " + path + fileName;
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(runtime.exec(command).getInputStream()));
            while ((line = br.readLine()) != null) {
                if (!line.contains(".jar")) continue;
                sb.append(line + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public int uploadFile(MultipartFile file, VersionInfo versionInfo) {
        File fileDir;
        String serviceName = versionInfo.getName();
        String originalFilename = file.getOriginalFilename();
        String outFileName = versionInfo.getVersion() + "_" + originalFilename;
        String path = this.serviceFileProperties.getPath(serviceName);
        this.logger.info("\u4e0a\u4f20\u670d\u52a1:{}\u5bf9\u5e94\u8d44\u6e90\u5305", (Object)serviceName);
        File outfile = new File(path + outFileName);
        if (!(outfile.exists() || (fileDir = new File(path)).exists() && fileDir.isDirectory())) {
            fileDir.mkdir();
        }
        try (InputStream is = file.getInputStream();
             FileOutputStream os = new FileOutputStream(outfile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        int success = 1;
        return success;
    }

    @Override
    public int saveNodeInfo(String coordinate) {
        int flag = 0;
        JSONObject jsonObject = JSONObject.fromObject((Object)coordinate);
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonObject.get("coordinate"));
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jObj = jsonArray.getJSONObject(i);
            String nodeId = jObj.getString("nodeId");
            String offsetX = jObj.getString("offsetX");
            String offsetY = jObj.getString("offsetY");
            String relId = this.serviceInfoMapper.getServiceInfoRelByServiceId(nodeId);
            if (relId != null && !relId.equals("")) {
                flag += this.serviceInfoMapper.updateNodeInServiceInfoRel(nodeId, offsetX, offsetY);
                continue;
            }
            flag += this.serviceInfoMapper.insertServiceInfoRel(UUID.randomUUID().toString(), nodeId, offsetX, offsetY, "");
        }
        return flag;
    }

    @Override
    public ServiceInfoDomain getServiceInfoByName(String name) {
        return this.serviceInfoMapper.getServiceInfoByName(name);
    }

    @Override
    public List<VersionInfo> getFileByServiceName(String serviceName) {
        return ServiceFileUtil.getFileByServiceName(serviceName);
    }

    @Override
    public List<VersionInfo> getServiceBasicInfo(String serviceName) {
        return ServiceFileUtil.getServiceBasicInfo(serviceName);
    }

    @Override
    public List<Map<String, String>> getServiceNameList(String clusterId) {
        ArrayList<Map<String, String>> serviceNameList = new ArrayList<Map<String, String>>();
        List<Object> serviceInfoDomainList = new ArrayList();
        serviceInfoDomainList = StringUtils.isNotEmpty((CharSequence)clusterId) ? this.getServiceInfoListByCluster(clusterId) : this.getServicesInfo();
        if (serviceInfoDomainList != null && !serviceInfoDomainList.isEmpty()) {
            for (ServiceInfoDomain serviceInfoDomain : serviceInfoDomainList) {
                String serviceName = serviceInfoDomain.getName();
                List<VersionInfo> fileList = this.getFileByServiceName(serviceName);
                if (fileList == null || fileList.isEmpty()) continue;
                HashMap<String, String> serviceMap = new HashMap<String, String>();
                serviceMap.put("key", serviceInfoDomain.getName());
                serviceMap.put("value", serviceInfoDomain.getName());
                serviceNameList.add(serviceMap);
            }
        } else {
            return new ArrayList<Map<String, String>>();
        }
        this.logger.info("\u67e5\u8be2\u7248\u672c\u4e0d\u4e3a\u7a7a\u7684\u670d\u52a1\uff0c\u6210\u529f\uff0c\u8fd4\u56de\u670d\u52a1\u540d\u5217\u8868");
        return serviceNameList;
    }
}

