/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.IndexDomain;
import cn.com.yusys.yusp.control.governance.domain.ServiceFlexInfo;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.executor.ServiceFileUtil;
import cn.com.yusys.yusp.control.governance.executor.ServiceFlexTask;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.service.ServiceFlexService;
import cn.com.yusys.yusp.control.repository.mapper.IndexDomainMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceFlexMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.user.repository.mapper.ClusterRelMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@StorageType(serviceType="database")
public class ServiceFlexServiceDBImpl
implements ServiceFlexService {
    @Autowired
    private ServiceInfoMapper serviceInfoMapper;
    @Autowired
    private ClusterRelMapper clusterRelMapper;
    @Autowired
    private IndexDomainMapper indexDomainMapper;
    @Autowired
    private ServiceFlexMapper serviceFlexMapper;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private ServiceFlexTask task;

    @Override
    public List<ServiceInfoDomain> getServiceInfo() {
        Collection<Application> applications = this.applicationRepository.findAll();
        List<ServiceInfoDomain> serviceInfoDomains = this.serviceInfoMapper.getServicesInfo();
        ArrayList<ServiceInfoDomain> list0 = new ArrayList<ServiceInfoDomain>();
        for (int i = 0; i < serviceInfoDomains.size(); ++i) {
            List<VersionInfo> list;
            ServiceInfoDomain domain = serviceInfoDomains.get(i);
            if (domain == null || (list = ServiceFileUtil.getFileByServiceName(domain.getName())).size() == 0) continue;
            VersionInfo maxVersion = ServiceFileUtil.getMaxVersionByName(domain.getName());
            if (maxVersion != null) {
                HashMap<String, VersionInfo> map = new HashMap<String, VersionInfo>();
                map.put(maxVersion.getVersion(), maxVersion);
                domain.setVersionMap(map);
            }
            int instanceSize = 0;
            List application = applications.stream().filter(app -> StringUtils.equalsIgnoreCase((CharSequence)domain.getName(), (CharSequence)app.getName())).collect(Collectors.toList());
            if (application.size() > 0) {
                instanceSize = ((Application)application.get(0)).getInstances().size();
            }
            domain.setInstanceNum(instanceSize);
            List clusterIds = this.clusterRelMapper.getClusterIdFromServiceClusterRelByServiceId(domain.getId());
            domain.setClusters(clusterIds);
            domain.setClusterNum(instanceSize);
            ServiceFlexInfo info = this.serviceFlexMapper.selectFlexByService(domain.getId());
            if (null == info) continue;
            domain.setExpandShrinkFrequency(Integer.valueOf(info.getExpandShrinkFrequency()));
            domain.setExpandMax(Integer.valueOf(info.getExpandMax()));
            domain.setShrinkMin(Integer.valueOf(info.getShrinkMin()));
            domain.setExpandShrinkStrategy(info.getExpandShrinkStrategy());
            list0.add(domain);
        }
        return list0;
    }

    @Override
    public ServiceInfoDomain getServiceByName(String name) {
        List<ServiceInfoDomain> infos = this.getServiceInfo();
        if (!CollectionUtils.isEmpty(infos)) {
            return infos.stream().filter(d -> d.getName().equals(name)).findAny().orElse(null);
        }
        return null;
    }

    @Override
    public List<IndexDomain> getIndexByName(String name) {
        List<IndexDomain> indexList = this.indexDomainMapper.getIndexByName(name);
        for (int i = 0; i < indexList.size(); ++i) {
            indexList.set(i, this.loadMontiorValue(indexList.get(i)));
        }
        return indexList;
    }

    @Override
    public int updateIndexByName(String name, IndexDomain indexDomain) {
        if (StringUtils.isNotEmpty((CharSequence)name) && indexDomain != null && indexDomain.validate()) {
            indexDomain.setServiceName(name);
            if (this.indexDomainMapper.updateServiceIndex(indexDomain) == 1) {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public int addIndex(String name, IndexDomain indexDomain) {
        if (StringUtils.isNotEmpty((CharSequence)name) && indexDomain != null && indexDomain.validate()) {
            indexDomain.setId(UUID.randomUUID().toString());
            indexDomain.setServiceName(name);
            ServiceInfoDomain serviceInfoDomain = this.serviceInfoMapper.getServiceInfoByName(name);
            if (serviceInfoDomain != null && !serviceInfoDomain.isAutoExpand()) {
                serviceInfoDomain.setAutoExpand(true);
                this.serviceInfoMapper.updateService(serviceInfoDomain);
            }
            if (this.indexDomainMapper.addServiceIndex(indexDomain) == 1) {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public int removeIndexByName(String name, String ids) {
        if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] idList = ids.split(",");
            this.indexDomainMapper.removeServiceIndex(idList);
            List<IndexDomain> list = this.indexDomainMapper.getIndexByName(name);
            if (list == null || list.size() == 0) {
                ServiceInfoDomain serviceInfoDomain = this.serviceInfoMapper.getServiceInfoByName(name);
                serviceInfoDomain.setAutoExpand(false);
                this.serviceInfoMapper.updateService(serviceInfoDomain);
            }
            return 0;
        }
        return 1;
    }

    @Override
    public void updateInstance(String name, boolean expand, String host) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u521b\u5efa\u5f39\u6027\u4f38\u7f29\u8c03\u5ea6\u4efb\u52a1->\u6210\u529f", (Object[])new Object[0]);
        this.task.manualRun(name, expand, host);
    }

    @Override
    public IndexDomain loadMontiorValue(IndexDomain index) {
        return index;
    }

    @Override
    public HostDomain getRandomHost(String serviceName) {
        return this.task.getRandomHost(serviceName, true, null);
    }
}

