/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.commons.exception.YuspException;
import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.Instance;
import cn.com.yusys.yusp.control.governance.install.DeployStatus;
import cn.com.yusys.yusp.control.governance.install.DeployUtil;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.repository.eureka.EurekaRepository;
import cn.com.yusys.yusp.control.governance.service.EurekaOperationService;
import cn.com.yusys.yusp.control.governance.service.MsDeployService;
import cn.com.yusys.yusp.control.repository.mapper.MsDeployMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.ssh.common.ConnectionInfo;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.repository.mapper.HostServiceDBMapper;
import cn.com.yusys.yusp.registry.util.SshSessionUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class MsDeployServiceDbImpl
implements MsDeployService {
    private final Logger logger = LoggerFactory.getLogger(MsDeployService.class);
    @Autowired
    private MsDeployMapper msDeployMapper;
    @Autowired
    private HostServiceDBMapper hostServiceDBMapper;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private EurekaRepository eurekaRepository;
    @Autowired
    private EurekaOperationService eurekaOperationService;

    @Override
    public Collection<Instance> getDeployInstanceListByName(String name) {
        List<DeployInfo> deployInfoList = this.msDeployMapper.getDeployListByName(name);
        Application application = this.applicationRepository.findByName(name);
        List instances = null;
        if (deployInfoList != null && deployInfoList.size() > 0) {
            instances = deployInfoList.stream().map(MsDeployServiceDbImpl::deployInfo2Instance).collect(Collectors.toList());
            if (application != null) {
                for (int i = 0; i < instances.size(); ++i) {
                    Instance finalInstance = (Instance)instances.get(i);
                    List instanceList = application.getInstances().stream().filter(ins -> StringUtils.equals((CharSequence)ins.getIp(), (CharSequence)finalInstance.getIp())).collect(Collectors.toList());
                    if (instanceList == null || instanceList.size() != 1) continue;
                    instances.set(i, this.merge(finalInstance, (Instance)instanceList.get(0)));
                }
            }
        }
        return instances;
    }

    @Override
    public int removeDeployByDeployId(String deployId) throws Exception {
        String[] deployIds = deployId.split(",");
        List<DeployInfo> deployInfoList = this.msDeployMapper.getDeployListByDeployIds(deployIds);
        if (deployInfoList == null) {
            throw new YuspException("500", "500", "warn", new Object[]{"\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u90e8\u7f72\u4fe1\u606f!"});
        }
        String name = deployInfoList.get(0).getName();
        Application application = this.applicationRepository.findByName(name);
        if (application != null && application.getInstances() != null) {
            for (DeployInfo deployInfo : deployInfoList) {
                List instanceList = application.getInstances().stream().filter(instance -> StringUtils.equals((CharSequence)deployInfo.getIp(), (CharSequence)instance.getIp()) && deployInfo.getPort() == instance.getPort()).collect(Collectors.toList());
                if (instanceList != null && instanceList.size() == 1) {
                    String instanceId = ((Instance)instanceList.get(0)).getId();
                    this.logger.info("\u8c03\u7528\u5b9e\u4f8b\u7684shutdown\u63a5\u53e3");
                    this.eurekaRepository.proxyPost(instanceId, "shutdown", null, ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
                    this.eurekaOperationService.removeInstance(deployInfo.getName(), ((Instance)instanceList.get(0)).getName());
                }
                HostDomain hostDomain = this.hostServiceDBMapper.queryByHostName(deployInfo.getHostName());
                SshSessionUtil.remove((ConnectionInfo)SshSessionUtil.getConnectionInfo((HostDomain)hostDomain), (String)deployInfo.getAppName(), (String)DeployUtil.getAppPath(deployInfo.getDeployPath()));
            }
        }
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u4e0b\u7ebf\u670d\u52a1:{}[{}]", (Object[])new Object[]{name, deployInfoList.get(0).getIp()});
        return this.msDeployMapper.removeDeployByDeployId(deployIds);
    }

    private static Instance deployInfo2Instance(DeployInfo deployInfo) {
        Instance instance = new Instance();
        instance.setIp(deployInfo.getIp());
        instance.setDeployId(deployInfo.getDeployId());
        instance.setName(deployInfo.getName());
        instance.setDeployDesc(deployInfo.getDeployDesc());
        instance.setDeployNo(deployInfo.getDeployNo());
        instance.setPort(deployInfo.getPort());
        instance.setVersion(deployInfo.getVersion());
        instance.setStatus(DeployStatus.DOWN.name());
        return instance;
    }

    private Instance merge(Instance old, Instance newInstance) {
        if (StringUtils.isEmpty((CharSequence)newInstance.getDeployId())) {
            newInstance.setDeployId(old.getDeployId());
        }
        if (StringUtils.isEmpty((CharSequence)newInstance.getVersion())) {
            newInstance.setVersion(old.getVersion());
        }
        return newInstance;
    }
}

