/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.domain.Datacode;
import cn.com.yusys.yusp.control.governance.service.DataDictonaryService;
import cn.com.yusys.yusp.control.repository.mapper.DataDictionaryMapper;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class DataDictonaryServiceDBImpl
implements DataDictonaryService {
    @Autowired
    private DataDictionaryMapper mapper;
    public static final int FAILURE_HANDLE = -1;

    @Override
    public List<Datacode> getListByName(String name) {
        return this.mapper.getCodeListByName(name);
    }

    @Override
    public int updateDataCodeByName(String name, Datacode datacode) {
        List<Datacode> datacodeList;
        if (StringUtils.isEmpty((CharSequence)name) || null == datacode) {
            return -1;
        }
        if (StringUtils.isEmpty((CharSequence)datacode.getKey())) {
            datacode.setKey(UUID.randomUUID().toString());
        }
        if (null != (datacodeList = this.getListByName(name)) && !datacodeList.isEmpty()) {
            if (datacodeList.stream().noneMatch(d -> d.getKey().equals(datacode.getKey()))) {
                return this.mapper.addDataCode(name, datacode);
            }
            return this.mapper.updateDatacodeByName(name, datacode);
        }
        return this.mapper.addDataCode(name, datacode);
    }

    @Override
    public int removeDataCodeByName(String name, String keys) {
        if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)keys)) {
            return -1;
        }
        String[] key = keys.split(",");
        return this.mapper.removeDataCodeByName(name, key);
    }
}

