/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.domain.Cluster;
import cn.com.yusys.yusp.control.governance.service.ClusterService;
import cn.com.yusys.yusp.control.repository.mapper.ClusterMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class ClusterServiceDBImpl
implements ClusterService {
    @Autowired
    private ClusterMapper clusterMapper;

    @Override
    public int addCluster(Cluster cluster) {
        Cluster c1 = this.clusterMapper.getClusterByClusterId(cluster.getId());
        Cluster c2 = this.clusterMapper.getClusterByClusterName(cluster.getClusterName());
        if (c2 == null) {
            if (c1 == null) {
                LogUtil.info((Object)ModulNameConstant.CLUSTERMANAGER, (String)"\u65b0\u589e\u96c6\u7fa4 [{}]", (Object[])new Object[]{cluster.getClusterName()});
                return this.clusterMapper.addCluster(cluster);
            }
            LogUtil.info((Object)ModulNameConstant.CLUSTERMANAGER, (String)"\u4fee\u6539\u96c6\u7fa4 [{}] \u7684\u4fe1\u606f", (Object[])new Object[]{cluster.getClusterName()});
            return this.clusterMapper.updateCluster(cluster);
        }
        if (c1 != null && c1.getId().equals(c2.getId())) {
            LogUtil.info((Object)ModulNameConstant.CLUSTERMANAGER, (String)"\u4fee\u6539\u96c6\u7fa4 [{}] \u7684\u4fe1\u606f", (Object[])new Object[]{cluster.getClusterName()});
            return this.clusterMapper.updateCluster(cluster);
        }
        return 0;
    }

    @Override
    public List<Cluster> getClusterList() {
        return this.clusterMapper.getClusterList();
    }

    @Override
    public Cluster getClusterByClusterName(String clusterName) {
        return this.clusterMapper.getClusterByClusterName(clusterName);
    }

    @Override
    public void delClusterByIds(String ids) {
        String[] idArray = ids.split(",");
        StringBuffer sb = new StringBuffer();
        for (String id : idArray) {
            sb.append(this.clusterMapper.getClusterByClusterId(id).getClusterName() + ",");
        }
        this.clusterMapper.delClusterByIds(idArray);
        this.clusterMapper.delClusterFromUserClusterRel(idArray);
        this.clusterMapper.delClusterFromHostClusterRel(idArray);
        this.clusterMapper.delClusterFromServiceClusterRel(idArray);
        LogUtil.info((Object)ModulNameConstant.CLUSTERMANAGER, (String)("\u5220\u9664\u96c6\u7fa4[" + sb.toString().substring(0, sb.toString().length() - 1) + "]"), (Object[])new Object[0]);
    }
}

