/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.service.impl;

import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.Cluster;
import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.DeployInfoHistory;
import cn.com.yusys.yusp.control.governance.domain.InstallInfo;
import cn.com.yusys.yusp.control.governance.domain.Instance;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.install.DeployStatus;
import cn.com.yusys.yusp.control.governance.install.DeployUtil;
import cn.com.yusys.yusp.control.governance.install.ServiceInstallBatch;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.service.ApplicationInstallService;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallHistoryServiceDBMapper;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallServiceDBMapper;
import cn.com.yusys.yusp.control.repository.mapper.ClusterMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.ssh.cmd.SimpleCmd;
import cn.com.yusys.yusp.msm.ssh.common.ConnectionInfo;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.repository.mapper.HostServiceDBMapper;
import cn.com.yusys.yusp.registry.util.SshSessionUtil;
import cn.com.yusys.yusp.user.repository.mapper.ClusterRelMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class ApplicationInstallServiceDBImpl
implements ApplicationInstallService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInstallService.class);
    private static final int DEFUALT_LOG_PAGESIZE = 2000;
    @Autowired
    private HostServiceDBMapper hostServiceDBMapper;
    @Autowired
    ClusterMapper clusterMapper;
    @Autowired
    ApplicationRepository applicationRepository;
    @Autowired
    ApplicationInstallHistoryServiceDBMapper applicationInstallHistoryServiceDBMapper;
    @Autowired
    ServiceInstallBatch serviceInstallBatch;
    @Autowired
    ApplicationInstallServiceDBMapper applicationInstallServiceDBMapper;
    @Autowired
    private ServiceInfoMapper serviceInfoMapper;
    @Autowired
    private ClusterRelMapper clusterRelMapper;

    @Override
    public void install(VersionInfo versionInfo, List<HostDomain> hostDomainList) {
        this.serviceInstallBatch.installBatch(versionInfo, hostDomainList, ModulNameConstant.APPLICATION_INSTALL);
    }

    @Override
    public void reInstall(VersionInfo versioninfo, List<Instance> instanceList) {
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u91cd\u65b0\u90e8\u7f72->\u5f00\u59cb", (Object[])new Object[0]);
        if (instanceList == null) {
            return;
        }
        int total = instanceList.size();
        ArrayList<HostDomain> hostDomainList = new ArrayList<HostDomain>();
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u505c\u5e94\u7528\u5f00\u59cb,\u5f85\u5904\u7406\u6570[{}]", (Object[])new Object[]{total});
        for (Instance instance : instanceList) {
            try {
                List hostTmp;
                LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed->\u5f00\u59cb", (Object[])new Object[]{instance.getIp()});
                String responseMsg = null;
                if (instance.getStatus().equals(DeployStatus.UP.name())) {
                    responseMsg = this.shutDown(instance.getId());
                    LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed[{}]", (Object[])new Object[]{instance.getIp(), responseMsg});
                }
                if ((hostTmp = this.hostServiceDBMapper.queryAllHosts().stream().filter(host -> StringUtils.equalsIgnoreCase((String)host.getIp(), (String)instance.getIp())).collect(Collectors.toList())) == null || hostTmp.size() <= 0) continue;
                hostDomainList.add((HostDomain)hostTmp.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.error((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed\u5931\u8d25,\u6392\u9664\u90e8\u7f72", (Object[])new Object[]{instance.getIp()});
            }
        }
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u505c\u5e94\u7528\u7ed3\u675f", (Object[])new Object[0]);
        this.install(versioninfo, hostDomainList);
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u91cd\u65b0\u90e8\u7f72->\u7ed3\u675f", (Object[])new Object[0]);
    }

    @Override
    public List<HostDomain> findUnUsedHostList(String serviceName) {
        ArrayList<HostDomain> listHost = new ArrayList<HostDomain>();
        List<DeployInfo> listDeployInfo = this.applicationInstallServiceDBMapper.getList();
        ServiceInfoDomain serviceDomain = this.serviceInfoMapper.getServiceInfoByName(serviceName);
        List serviceOfClusterIds = this.clusterRelMapper.getClusterIdFromServiceClusterRelByServiceId(serviceDomain.getId());
        for (HostDomain host : this.hostServiceDBMapper.queryAllHosts()) {
            if (!this.chkDomain(host, serviceDomain)) continue;
            Application application = this.applicationRepository.findByName(serviceName);
            if (application != null && application.getInstances() != null) {
                DeployInfo delpoyInfo;
                List<Instance> instanceList = application.getInstances();
                int num = instanceList.stream().filter(ins -> StringUtils.equalsIgnoreCase((String)ins.getIp(), (String)host.getIp())).collect(Collectors.toList()).size();
                if (num > 0) {
                    log.info("\u5e94\u7528[{}],\u5df2\u90e8\u7f72\u4e3b\u673a[{}],\u7ee7\u7eed\u67e5\u627e", (Object)serviceName, (Object)host.getIp());
                    continue;
                }
                List temp = listDeployInfo.stream().filter(a -> host.getHostName().equals(a.getHostName())).collect(Collectors.toList());
                if (temp.size() > 0 && StringUtils.isEmpty((String)(delpoyInfo = (DeployInfo)temp.get(0)).getEndTime())) {
                    log.info("\u4e3b\u673a[{}],\u672a\u5b8c\u6210\u7684\u90e8\u7f72[{}],\u90e8\u7f72\u65f6\u95f4[{}],\u7ee7\u7eed\u67e5\u627e", new Object[]{host.getIp(), delpoyInfo.getAppName(), delpoyInfo.getStartTime()});
                    continue;
                }
            }
            log.info("\u5e94\u7528[{}],\u672a\u90e8\u7f72\u4e3b\u673a[{}],\u53ef\u7528", (Object)serviceName, (Object)host.getIp());
            List hostOfClusters = host.getClusters();
            if (!hostOfClusters.stream().anyMatch(serviceOfClusterIds::contains)) continue;
            listHost.add(host);
        }
        return listHost;
    }

    @Override
    public List<HostDomain> findUnUsedHostListByCluster(String name, String cluster) {
        ArrayList<HostDomain> listHost = new ArrayList<HostDomain>();
        List<DeployInfo> listDeployInfo = this.applicationInstallServiceDBMapper.getList();
        ServiceInfoDomain serviceDomain = this.serviceInfoMapper.getServiceInfoByName(name);
        Cluster cl = this.clusterMapper.getClusterByClusterId(cluster);
        for (HostDomain host : this.hostServiceDBMapper.queryByClusterId(cl.getId())) {
            if (!this.chkDomain(host, serviceDomain)) continue;
            Application application = this.applicationRepository.findByName(name);
            if (application != null && application.getInstances() != null) {
                DeployInfo delpoyInfo;
                List<Instance> instanceList = application.getInstances();
                int num = instanceList.stream().filter(ins -> StringUtils.equalsIgnoreCase((String)ins.getIp(), (String)host.getIp())).collect(Collectors.toList()).size();
                if (num > 0) {
                    log.info("\u5e94\u7528[{}],\u5df2\u90e8\u7f72\u4e3b\u673a[{}],\u7ee7\u7eed\u67e5\u627e", (Object)name, (Object)host.getIp());
                    continue;
                }
                List temp = listDeployInfo.stream().filter(a -> host.getHostName().equals(a.getHostName())).collect(Collectors.toList());
                if (temp.size() > 0 && StringUtils.isEmpty((String)(delpoyInfo = (DeployInfo)temp.get(0)).getEndTime())) {
                    log.info("\u4e3b\u673a[{}],\u672a\u5b8c\u6210\u7684\u90e8\u7f72[{}],\u90e8\u7f72\u65f6\u95f4[{}],\u7ee7\u7eed\u67e5\u627e", new Object[]{host.getIp(), delpoyInfo.getAppName(), delpoyInfo.getStartTime()});
                    continue;
                }
            }
            log.info("\u5e94\u7528[{}],\u672a\u90e8\u7f72\u4e3b\u673a[{}],\u53ef\u7528", (Object)name, (Object)host.getIp());
            listHost.add(host);
        }
        return listHost;
    }

    @Override
    public boolean chkDomain(HostDomain hostDomain, ServiceInfoDomain serviceDomain) {
        if (hostDomain.getBusinessDomains() == null || hostDomain.getBusinessDomains().size() == 0) {
            return true;
        }
        return hostDomain.getBusinessDomains().contains(serviceDomain.getBusinessDomain());
    }

    @Override
    public String shutDown(String instanceId) throws Exception {
        return this.applicationRepository.proxyPost(instanceId, "shutdown", null, null);
    }

    @Override
    public List<DeployInfoHistory> queryHistory(String serviceName) {
        return this.applicationInstallHistoryServiceDBMapper.getHistoryList().stream().filter(his -> StringUtils.equalsIgnoreCase((String)his.getName(), (String)serviceName)).sorted((s1, s2) -> s2.getOpDate().compareTo(s1.getOpDate())).collect(Collectors.toList());
    }

    @Override
    public String queryStartLog(String hostName, String name, int startPage, int pageSize) {
        String result;
        HostDomain hostInfo = this.hostServiceDBMapper.queryByHostName(hostName);
        if (hostInfo == null) {
            return "";
        }
        if (startPage <= 0) {
            startPage = 1;
        }
        if (pageSize <= 0) {
            pageSize = 2000;
        }
        int headNum = startPage * pageSize;
        int tailNum = pageSize;
        String targetPath = DeployUtil.getTargetPath(hostInfo);
        try {
            result = SshSessionUtil.goCmd((ConnectionInfo)this.getConnectionInfo(hostInfo), (String)DeployUtil.getLogPath(targetPath), (String)SimpleCmd.tailFile((int)headNum, (int)tailNum, (String)name)).getOut();
        }
        catch (Exception e) {
            result = "\u65e5\u5fd7\u52a0\u8f7d\u5f02\u5e38";
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<DeployInfo> queryDeployInfoList() {
        return this.applicationInstallServiceDBMapper.getList();
    }

    @Override
    public void remove(InstallInfo installInfo) throws Exception {
        for (Instance instance : installInfo.getInstanceList()) {
            LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b\u79fb\u9664\uff0c\u5b9e\u4f8bNAME:[{}],URL:[{}]", (Object[])new Object[]{instance.getId(), instance.getUrl()});
            List<DeployInfo> depoyAll = this.applicationInstallServiceDBMapper.getList();
            List depoyList = depoyAll.stream().filter(d -> d.getIp().equals(instance.getIp()) && d.getName().equals(instance.getId().split("@")[0])).sorted(Comparator.comparing(DeployInfo::getEndTime).reversed()).collect(Collectors.toList());
            if (!instance.getStatus().equals(DeployStatus.OFFLINE.name())) {
                this.shutDown(instance.getId());
            }
            if (depoyList.size() <= 0) continue;
            DeployInfo deployInfo = (DeployInfo)depoyList.get(0);
            DeployInfoHistory deployInfoHistory = new DeployInfoHistory();
            this.applicationInstallServiceDBMapper.remove(deployInfo);
            BeanUtils.copyProperties((Object)deployInfo, (Object)deployInfoHistory);
            deployInfoHistory.setUpdateTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
            deployInfoHistory.setUpdateType("\u79fb\u9664");
            this.applicationInstallHistoryServiceDBMapper.addHistory(deployInfoHistory);
        }
    }

    private ConnectionInfo getConnectionInfo(HostDomain host) {
        ConnectionInfo info = new ConnectionInfo();
        info.setHostName(host.getHostName());
        info.setPassword(host.getPassword());
        info.setUri(host.getIp());
        info.setUserName(host.getUserName());
        return info;
    }
}

