/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.repository.eureka;

import cn.com.yusys.yusp.commons.exception.YuspException;
import cn.com.yusys.yusp.control.governance.domain.Instance;
import cn.com.yusys.yusp.control.governance.repository.eureka.EurekaRepository;
import cn.com.yusys.yusp.msm.common.ResultDto;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class RemoteEurekaRepository
extends EurekaRepository {
    private static final Logger log = LoggerFactory.getLogger(RemoteEurekaRepository.class);
    private EurekaClient eurekaClient;
    private final HttpClient httpClient;

    public RemoteEurekaRepository(Optional<EurekaClient> eurekaClient, HttpClient httpClient) {
        if (eurekaClient.isPresent()) {
            this.eurekaClient = eurekaClient.get();
        }
        this.httpClient = httpClient;
    }

    @Override
    public Collection<cn.com.yusys.yusp.control.governance.domain.Application> findAll() {
        return this.eurekaClient.getApplications().getRegisteredApplications().stream().map(this.TO_APPLICATION).collect(Collectors.toList());
    }

    @Override
    public cn.com.yusys.yusp.control.governance.domain.Application findByName(String name) {
        return (cn.com.yusys.yusp.control.governance.domain.Application)this.TO_APPLICATION.apply(this.eurekaClient.getApplications().getRegisteredApplications(name));
    }

    @Override
    public InstanceInfo findInstanceInfo(@NotNull String id) {
        if (id == null) {
            return null;
        }
        String[] instanceIds = id.split("@", 2);
        String serviceName = instanceIds[0];
        String ipAndPort = instanceIds[1].replaceAll("_", ".");
        Application application = this.eurekaClient.getApplication(serviceName);
        if (application == null) {
            return null;
        }
        InstanceInfo instanceInfo = application.getByInstanceId(ipAndPort);
        if (instanceInfo != null) {
            return instanceInfo;
        }
        return this.eurekaClient.getApplication(serviceName).getInstancesAsIsFromEureka().stream().filter(instance -> ipAndPort.equalsIgnoreCase(instance.getHostName() + ":" + instance.getPort())).findFirst().orElse(null);
    }

    @Override
    public Collection<Instance> findAllInstance() {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        Collection<cn.com.yusys.yusp.control.governance.domain.Application> applicationList = this.findAll();
        for (cn.com.yusys.yusp.control.governance.domain.Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    @Override
    public String proxy(String id, String method, ServletRequest request) throws Exception {
        String managementUrl = this.getInstanceManagementUrl(id);
        String url = managementUrl + "/" + method;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (request != null) {
                request.getParameterMap().forEach((key, value) -> builder.setParameter(key, value[0]));
            }
            HttpGet httpGet = new HttpGet(builder.build());
            log.info("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, "HttpGet"});
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return result;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, e.getMessage()});
            throw e;
        }
    }

    @Override
    public String proxyPost(String id, String method, String body, HttpServletRequest request) throws Exception {
        String managementUrl = this.getInstanceManagementUrl(id);
        String url = managementUrl + "/" + method;
        try (CloseableHttpClient client = null;){
            URIBuilder builder = new URIBuilder(url);
            HttpPost post = new HttpPost(builder.build());
            if (request != null) {
                request.getParameterMap().forEach((key, value) -> builder.setParameter(key, value[0]));
            }
            if (body != null) {
                post.setEntity((HttpEntity)new StringEntity(body));
            }
            log.info("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, "HttpPost"});
            client = HttpClientBuilder.create().build();
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            int errorCode = 500;
            String errorMessage = "";
            if (response == null) {
                errorMessage = "\u65e0\u6cd5\u8bbf\u95ee\u5b9e\u4f8b:[" + id + "]";
            } else if (response.getStatusLine() == null) {
                errorMessage = "\u65e0\u6cd5\u8bbf\u95ee\u5b9e\u4f8b:[" + id + "],API:[" + url + "]";
            } else if (response.getStatusLine().getStatusCode() != 200) {
                errorCode = response.getStatusLine().getStatusCode();
                errorMessage = response.getStatusLine().getReasonPhrase();
            } else {
                log.info("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}]\u6210\u529f", (Object)id, (Object)url);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            throw new YuspException(String.valueOf(errorCode), errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ResultDto<String> logfile(String id, Long pos, int num) {
        ResultDto resultDto = new ResultDto();
        String managementUrl = this.getInstanceManagementUrl(id);
        String url = managementUrl + "/logfile";
        HttpURLConnection connection = null;
        try {
            ResultDto resultDto2;
            Throwable throwable;
            InputStream inputStream;
            block26: {
                block27: {
                    byte[] b;
                    connection = (HttpURLConnection)new URL(url).openConnection();
                    long total = connection.getContentLengthLong();
                    resultDto.setTotal(total);
                    inputStream = connection.getInputStream();
                    throwable = null;
                    if (pos != null && pos != 0L) {
                        b = new byte[(int)(total - pos)];
                        inputStream.skip(pos);
                    } else {
                        b = new byte[num];
                        inputStream.skip(total - (long)num);
                    }
                    inputStream.read(b);
                    resultDto.setData((Object)new String(b, Charset.defaultCharset()).trim());
                    resultDto2 = resultDto;
                    if (inputStream == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block26;
                }
                inputStream.close();
            }
            return resultDto2;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception exception) {
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

