/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.repository;

import cn.com.yusys.yusp.control.governance.domain.Cluster;
import cn.com.yusys.yusp.msm.config.CommonProperties;
import cn.com.yusys.yusp.msm.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.log.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class ClusterRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(ClusterRepository.class);

    public ClusterRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{Cluster.class});
    }

    public void addAndUpdateCluster(Cluster cluster) {
        List<Cluster> clusterList = this.getClusterList();
        boolean updateFlag = false;
        for (Cluster clusterItem : clusterList) {
            if (!clusterItem.getId().equals(cluster.getId())) continue;
            updateFlag = true;
            BeanUtils.copyProperties((Object)cluster, (Object)clusterItem);
        }
        if (!updateFlag) {
            clusterList.add(cluster);
        }
        try {
            this.getAfo().writeObject(clusterList);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            if (updateFlag) {
                this.log.error("\u66f4\u65b0\u96c6\u7fa4\u4fe1\u606f\u5931\u8d25\uff1a {} error: {}", (Object)cluster, (Object)e.getMessage());
            }
            this.log.error("\u6dfb\u52a0\u96c6\u7fa4\u4fe1\u606f\u5931\u8d25\uff1a {} error: {}", (Object)cluster, (Object)e.getMessage());
        }
    }

    public List<Cluster> getClusterList() {
        ArrayList clusterList = (ArrayList)this.getLoadObj();
        if (clusterList == null) {
            clusterList = new ArrayList();
        }
        return clusterList;
    }

    public Cluster getClusterByClusterName(String clusterName) {
        List clusterList = (List)this.getLoadObj();
        for (Cluster item : clusterList) {
            if (!clusterName.equals(item.getClusterName())) continue;
            return item;
        }
        this.log.error("\u96c6\u7fa4\u4e0d\u5b58\u5728,\u96c6\u7fa4\u540d\uff1a {}", (Object)clusterName);
        return null;
    }

    public void delClusterByIds(String ids) {
        List<Cluster> clusterList = this.getClusterList();
        ArrayList<Cluster> removeList = null;
        List<String> idList = Arrays.asList(ids.split(","));
        for (Cluster cluster : clusterList) {
            if (!idList.contains(cluster.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<Cluster>();
            }
            removeList.add(cluster);
        }
        if (removeList == null) {
            return;
        }
        clusterList.removeAll(removeList);
        try {
            this.getAfo().writeObject(clusterList);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.log.error("\u5220\u9664\u96c6\u7fa4\u5931\u8d25: " + Arrays.asList(ids) + " error: " + e.getMessage());
        }
    }
}

