/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.monitor;

import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.Instance;
import cn.com.yusys.yusp.control.governance.monitor.JenkinsBasicBuildParam;
import cn.com.yusys.yusp.control.governance.monitor.JenkinsBuildUtils;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.jenkins.service.JenkinsBuildService;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallServiceDBMapper;
import cn.com.yusys.yusp.msm.storage.service.StorageServiceFactory;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.BuildWithDetails;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionFileListener
extends FileAlterationListenerAdaptor {
    private static Logger log = LoggerFactory.getLogger(VersionFileListener.class);
    private static final String JAR_SUFFIX = ".jar";
    private static final String VERSION_DIVIDE = "_";
    private static final String JENKINS_PREFIX = "jenkins.";
    private final int SUCCESS = 5;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private StorageServiceFactory factory;
    @Autowired
    private ApplicationInstallServiceDBMapper installServiceDBMapper;
    @Autowired
    private ApplicationRepository applicationRepository;

    public JenkinsBuildService getJenkinsBuildService() {
        return (JenkinsBuildService)this.factory.getStorageService(JenkinsBuildService.class);
    }

    public void onFileCreate(File file) {
        log.debug("[\u65b0\u589e]:" + file.getAbsolutePath());
        this.addDeployInfo(file);
    }

    public void onFileChange(File file) {
        log.debug("[\u4fee\u6539]:" + file.getAbsolutePath());
        this.addDeployInfo(file);
    }

    public boolean addDeployInfo(File file) {
        String fileName = file.getName();
        if (fileName.endsWith(JAR_SUFFIX) && fileName.startsWith(JENKINS_PREFIX)) {
            JenkinsServer server = this.getJenkinsBuildService().jenkinsServer();
            try {
                String jobName = fileName.substring(JENKINS_PREFIX.length(), fileName.indexOf(VERSION_DIVIDE));
                BuildWithDetails details = JenkinsBuildUtils.getBuildWithDetails(server, jobName);
                JenkinsBasicBuildParam param = JenkinsBuildUtils.getBasicParam(details);
                if (param.isAnyEmpty()) {
                    log.warn("jenkins\u6784\u5efa\u4efb\u52a1\u6ca1\u6709\u63d0\u4f9b\u5fc5\u987b\u53c2\u6570\uff01,\u65e0\u6cd5\u8bb0\u5f55\u7248\u672c\u4fe1\u606f");
                } else {
                    DeployInfo deployInfo2;
                    List oldList = this.installServiceDBMapper.getList().stream().filter(deployInfo -> StringUtils.equals((CharSequence)deployInfo.getName(), (CharSequence)param.getServiceName()) && StringUtils.equals((CharSequence)deployInfo.getIp(), (CharSequence)param.getDestIp())).collect(Collectors.toList());
                    boolean update = true;
                    String serviceName = file.getParentFile().getName();
                    if (oldList == null || oldList.size() == 0) {
                        update = false;
                        deployInfo2 = new DeployInfo();
                        deployInfo2.setDeployId(UUID.randomUUID().toString().replaceAll("-", ""));
                        deployInfo2.setName(serviceName);
                        deployInfo2.setVersion(param.getServiceVersion());
                        deployInfo2.setIp(param.getDestIp());
                        deployInfo2.setAppName(fileName);
                    } else {
                        deployInfo2 = (DeployInfo)oldList.get(0);
                    }
                    deployInfo2.setDeployDesc("jenkins\u81ea\u52a8\u6784\u5efa\u4efb\u52a1\uff1a" + jobName);
                    this.addCommonInfo(deployInfo2, details, param);
                    if (update) {
                        this.installServiceDBMapper.update(deployInfo2);
                    } else {
                        this.installServiceDBMapper.add(deployInfo2);
                    }
                    new Thread(() -> {
                        int tryTime = 10;
                        while (tryTime > 0) {
                            List instances;
                            --tryTime;
                            Application application = this.applicationRepository.findByName(serviceName);
                            if (application != null && (instances = application.getInstances().stream().filter(instance -> StringUtils.equals((CharSequence)param.getDestIp(), (CharSequence)instance.getIp())).collect(Collectors.toList())) != null && instances.size() == 1) {
                                deployInfo2.setPort(((Instance)instances.get(0)).getPort());
                                log.info("\u53d8\u66f4\u670d\u52a1:{}\u7aef\u53e3\u53f7:{}", (Object)deployInfo2.getName(), (Object)((Instance)instances.get(0)).getPort());
                                this.installServiceDBMapper.update(deployInfo2);
                                break;
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void addCommonInfo(DeployInfo deployInfo, BuildWithDetails details, JenkinsBasicBuildParam param) {
        long time = details.getTimestamp();
        deployInfo.setStartTime(this.simpleDateFormat.format(new Date(time)));
        deployInfo.setEndTime(this.simpleDateFormat.format(new Date(time += details.getDuration())));
        deployInfo.setOpDate(deployInfo.getStartTime().substring(0, 10));
        deployInfo.setDeployPath(param.getDeployPath());
        deployInfo.setDeployNo(5);
        deployInfo.setDeployResult(details.getResult().toString());
    }

    public void onFileDelete(File file) {
        log.info("[\u5220\u9664]:" + file.getAbsolutePath());
    }

    public void onDirectoryCreate(File directory) {
        log.info("[\u65b0\u5efa]:" + directory.getAbsolutePath());
    }

    public void onDirectoryChange(File directory) {
        log.info("[\u4fee\u6539]:" + directory.getAbsolutePath());
    }

    public void onDirectoryDelete(File directory) {
        log.info("[\u5220\u9664]:" + directory.getAbsolutePath());
    }

    public void onStart(FileAlterationObserver observer) {
        super.onStart(observer);
    }

    public void onStop(FileAlterationObserver observer) {
        super.onStop(observer);
    }
}

