/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.install;

import cn.com.yusys.yusp.control.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.control.governance.domain.DeployInfo;
import cn.com.yusys.yusp.control.governance.domain.DeployInfoHistory;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.install.DeployMonitor;
import cn.com.yusys.yusp.control.governance.install.DeployStatus;
import cn.com.yusys.yusp.control.governance.install.DeployUtil;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallHistoryServiceDBMapper;
import cn.com.yusys.yusp.control.repository.mapper.ApplicationInstallServiceDBMapper;
import cn.com.yusys.yusp.msm.common.DashboardCmdPair;
import cn.com.yusys.yusp.msm.exception.DashboardSessionException;
import cn.com.yusys.yusp.msm.ssh.cmd.SimpleCmd;
import cn.com.yusys.yusp.msm.ssh.common.ConnectionInfo;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.repository.mapper.HostServiceDBMapper;
import cn.com.yusys.yusp.registry.util.SshSessionUtil;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@EnableConfigurationProperties(value={ServiceFileProperties.class})
@Component
public class ServiceInstall {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstall.class);
    @Autowired
    private HostServiceDBMapper hostServiceDBMapper;
    @Autowired
    ServiceFileProperties serviceFileProperties;
    @Autowired
    ApplicationInstallHistoryServiceDBMapper applicationInstallHistoryServiceDBMapper;
    @Autowired
    ApplicationInstallServiceDBMapper applicationInstallServiceDBMapper;
    @Autowired
    DeployMonitor deployMonitor;
    @Value(value="${deploy-file-path}")
    String deployFilePath;
    private String startShellName;
    private DeployStatus deployStatus;
    private DeployInfo deployInfo;
    private DeployInfoHistory deployInfoHistory;

    public void install(DeployInfo deployInfo, VersionInfo versionInfo, HostDomain hostInfo) throws Exception {
        String result = "success";
        String appName = versionInfo.getFileName();
        String fielFullPath = this.serviceFileProperties.getPath(versionInfo.getName()) + appName;
        this.deployInfo = deployInfo;
        this.deployInfoHistory = this.buildHistory(deployInfo, versionInfo, hostInfo);
        String targetPath = deployInfo.getDeployPath();
        String logFileName = deployInfo.getLogFile();
        String jvmOpts = deployInfo.getJvmOpts();
        String bootOpts = deployInfo.getBootOpts();
        try {
            this.chk(hostInfo.getHostName(), targetPath);
            log.info("file source path :{}, target path: {}", (Object)fielFullPath, (Object)targetPath);
            this.upLoadServiceFile(SshSessionUtil.getConnectionInfo((HostDomain)hostInfo), fielFullPath, targetPath);
            this.deploy(SshSessionUtil.getConnectionInfo((HostDomain)hostInfo), targetPath, appName, logFileName, jvmOpts, bootOpts, versionInfo.getName());
            this.addMonitor();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = this.deployStatus.getDesc() + "\u5931\u8d25,\u9519\u8bef\u539f\u56e0:[" + e.getMessage() + "]";
            log.error(result);
            deployInfo.setDeployResult(result);
            deployInfo.setEndTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
            this.applicationInstallServiceDBMapper.add(deployInfo);
            throw e;
        }
        finally {
            this.applicationInstallHistoryServiceDBMapper.addHistory(this.deployInfoHistory);
        }
    }

    private void addMonitor() {
        this.deployMonitor.add(this.deployInfo);
    }

    private void chk(String hostName, String targetPath) throws Exception {
        this.deployStatus = DeployStatus.CHECK;
        this.startShellName = this.getStartFileName();
        HostDomain hostDomain = this.hostServiceDBMapper.queryByHostName(hostName);
        this.uploadStartFile(SshSessionUtil.getConnectionInfo((HostDomain)hostDomain), targetPath);
        this.deployInfo.setDeployNo(this.deployStatus.getStepNo());
        this.deployInfo.setDeployDesc(this.deployStatus.getDesc());
        this.applicationInstallServiceDBMapper.update(this.deployInfo);
    }

    private String getStartFileName() throws Exception {
        return this.deployFilePath.substring(this.deployFilePath.lastIndexOf(DeployUtil.getFileSeparator()) + 1);
    }

    private void uploadStartFile(ConnectionInfo connectionInfo, String targetPath) throws Exception {
        InputStream inputStream = null;
        try {
            File file = new File(this.deployFilePath);
            if (!file.exists()) {
                ClassPathResource resource = new ClassPathResource(this.deployFilePath);
                inputStream = resource.getInputStream();
            } else {
                inputStream = new FileInputStream(file);
            }
            SshSessionUtil.upload((ConnectionInfo)connectionInfo, (InputStream)inputStream, (String)this.getStartFileName(), (String)DeployUtil.getBinPath(targetPath), (boolean)false);
        }
        catch (DashboardSessionException | JSchException | SftpException | FileNotFoundException e) {
            throw e;
        }
        finally {
            try {
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private DeployInfoHistory buildHistory(DeployInfo deployInfo, VersionInfo versionInfo, HostDomain hostInfo) {
        this.deployStatus = DeployStatus.BEGIN;
        String startTime = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
        DeployInfoHistory deployInfoHistory = new DeployInfoHistory();
        BeanUtils.copyProperties((Object)deployInfo, (Object)deployInfoHistory);
        deployInfoHistory.setUpdateTime(startTime);
        deployInfoHistory.setUpdateType("\u53d1\u5e03");
        deployInfo.setStartTime(startTime);
        deployInfo.setDeployNo(this.deployStatus.getStepNo());
        deployInfo.setDeployDesc(this.deployStatus.getDesc());
        this.applicationInstallServiceDBMapper.update(deployInfo);
        return deployInfoHistory;
    }

    private void upLoadServiceFile(ConnectionInfo connectionInfo, String fielFullPath, String targetPath) throws FileNotFoundException, DashboardSessionException, JSchException, SftpException {
        File file = new File(fielFullPath);
        this.deployStatus = DeployStatus.UPLOAD;
        SshSessionUtil.upload((ConnectionInfo)connectionInfo, (File)file, (String)DeployUtil.getAppPath(targetPath), (boolean)true);
        this.deployInfo.setDeployNo(this.deployStatus.getStepNo());
        this.deployInfo.setDeployDesc(this.deployStatus.getDesc());
        this.applicationInstallServiceDBMapper.update(this.deployInfo);
    }

    private void deploy(ConnectionInfo connectionInfo, String targetPath, String appName, String logName, String jvmOpts, String bootOpts, String serviceName) throws Exception {
        this.deployStatus = DeployStatus.STARTING;
        DashboardCmdPair cmdPair = SshSessionUtil.goCmd((ConnectionInfo)connectionInfo, (String)DeployUtil.getBinPath(targetPath), (String)SimpleCmd.shellStart((String)this.startShellName, (String)appName, (String)logName, (String)jvmOpts, (String)bootOpts));
        this.deployInfo.setDeployResult(cmdPair.getOut());
        this.deployInfo.setDeployNo(this.deployStatus.getStepNo());
        this.deployInfo.setDeployDesc(this.deployStatus.getDesc());
        this.applicationInstallServiceDBMapper.update(this.deployInfo);
    }

    public String sendCmdStart(DeployInfo deployInfo) throws Exception {
        HostDomain hostDomain = this.hostServiceDBMapper.queryByHostName(deployInfo.getHostName());
        ConnectionInfo info = SshSessionUtil.getConnectionInfo((HostDomain)hostDomain);
        String shellName = this.getStartFileName();
        DashboardCmdPair dashboardCmdPair = SshSessionUtil.goCmd((ConnectionInfo)info, (String)DeployUtil.getBinPath(deployInfo.getDeployPath()), (String)SimpleCmd.shellStart((String)shellName, (String)deployInfo.getAppName(), (String)deployInfo.getLogFile(), (String)deployInfo.getJvmOpts(), (String)deployInfo.getBootOpts()));
        return dashboardCmdPair.getOut();
    }
}

