/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.executor;

import cn.com.yusys.yusp.control.governance.domain.Application;
import cn.com.yusys.yusp.control.governance.domain.IndexDomain;
import cn.com.yusys.yusp.control.governance.domain.Instance;
import cn.com.yusys.yusp.control.governance.domain.ServiceFlexHistory;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.VersionInfo;
import cn.com.yusys.yusp.control.governance.executor.FlexMonitor;
import cn.com.yusys.yusp.control.governance.executor.ServiceFileUtil;
import cn.com.yusys.yusp.control.governance.install.ServiceInstallBatch;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.governance.service.ServiceFlexHistoryService;
import cn.com.yusys.yusp.control.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.msm.exception.DashboardSessionException;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.storage.service.StorageService;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.service.HostService;
import cn.com.yusys.yusp.registry.util.SshSessionUtil;
import cn.com.yusys.yusp.user.repository.mapper.ClusterRelMapper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceFlexTask
extends StorageService {
    private static final Logger log = LoggerFactory.getLogger(ServiceFlexTask.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ServiceInstallBatch serviceInstallBatch;
    @Autowired
    private FlexMonitor monitor;
    @Autowired
    private ServiceInfoMapper serviceInfoMapper;
    @Autowired
    private ClusterRelMapper clusterRelMapper;
    @Autowired
    private ApplicationRepository applicationRepository;

    public void manualRun(String serviceName, boolean expand, String host) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u8c03\u5ea6\u5f39\u6027\u4f38\u7f29->\u5f00\u59cb", (Object[])new Object[0]);
        ServiceInfoDomain domain = ((ServiceInfoService)this.getService(ServiceInfoService.class)).getServiceInfoByName(serviceName);
        this.manualFlexService(domain.getName(), expand, host);
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u8c03\u5ea6\u5f39\u6027\u4f38\u7f29->\u7ed3\u675f", (Object[])new Object[0]);
    }

    public void autoFlexService(List<ServiceInfoDomain> serviceInfoDomains) {
        for (ServiceInfoDomain serviceInfoDomain : serviceInfoDomains) {
            Application application = this.applicationRepository.findByName(serviceInfoDomain.getName());
            if (application == null) continue;
            List<Instance> instanceList = application.getInstances();
            ArrayList<IndexDomain> expandList = null;
            ArrayList<IndexDomain> shrinkList = null;
            if (serviceInfoDomain.getIndexDomains() == null) continue;
            for (IndexDomain indexDomain : serviceInfoDomain.getIndexDomains()) {
                if (indexDomain.getFlexType().equals("E")) {
                    if (expandList == null) {
                        expandList = new ArrayList<IndexDomain>();
                    }
                    expandList.add(indexDomain);
                    continue;
                }
                if (shrinkList == null) {
                    shrinkList = new ArrayList<IndexDomain>();
                }
                shrinkList.add(indexDomain);
            }
            if (expandList != null && instanceList.size() < serviceInfoDomain.getExpandMax() && this.isFlag(expandList, serviceInfoDomain)) {
                this.expandService(serviceInfoDomain.getName(), null, true);
                LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u670d\u52a1[{}]\u6269\u5bb9\uff0c\u6267\u884c\u65b9\u5f0f->\u81ea\u52a8", (Object[])new Object[]{serviceInfoDomain.getName()});
            }
            if (shrinkList == null || instanceList.size() <= serviceInfoDomain.getShrinkMin() || !this.isFlag(shrinkList, serviceInfoDomain)) continue;
            this.shrinkService(serviceInfoDomain.getName(), true);
            LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u670d\u52a1[{}]\u6536\u7f29\uff0c\u6267\u884c\u65b9\u5f0f->\u81ea\u52a8", (Object[])new Object[]{serviceInfoDomain.getName()});
        }
    }

    public boolean isFlag(List<IndexDomain> list, ServiceInfoDomain serviceInfoDomain) {
        boolean[] flags = new boolean[list.size()];
        int i = 0;
        for (IndexDomain indexDomain : list) {
            flags[i] = this.monitor.beyondIndex(indexDomain).isFlag();
            ++i;
        }
        boolean flag = false;
        if (serviceInfoDomain.getExpandShrinkStrategy().equals("AND")) {
            for (boolean b : flags) {
                if (!b) {
                    flag = false;
                    break;
                }
                flag = true;
            }
        } else {
            for (boolean b : flags) {
                if (b) {
                    flag = true;
                    break;
                }
                flag = false;
            }
        }
        if (flag) {
            List<ServiceFlexHistory> list2 = ((ServiceFlexHistoryService)this.getService(ServiceFlexHistoryService.class)).getHistoryByName(serviceInfoDomain.getName());
            Date time = null;
            int t = 0;
            if (list2.size() == 0) {
                ServiceFlexHistory history = new ServiceFlexHistory();
                String t0 = this.sdf.format(new Date().getTime() - 600000L);
                history.setTime(t0);
                ((ServiceFlexHistoryService)this.getService(ServiceFlexHistoryService.class)).addFlexHistory(serviceInfoDomain.getName(), history);
                list2.add(history);
            }
            try {
                time = this.sdf.parse(list2.get(0).getTime());
                t = (int)((new Date().getTime() - time.getTime()) / 60000L);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (time == null || t >= serviceInfoDomain.getExpandShrinkFrequency()) {
                return true;
            }
        }
        return false;
    }

    private void manualFlexService(String serviceName, boolean expand, String host) {
        if (expand) {
            LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u670d\u52a1[{}]\u6269\u5bb9\uff0c\u6267\u884c\u65b9\u5f0f->\u624b\u52a8", (Object[])new Object[]{serviceName});
            this.expandService(serviceName, host, false);
        } else {
            LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u670d\u52a1[{}]\u6536\u7f29\uff0c\u6267\u884c\u65b9\u5f0f->\u624b\u52a8", (Object[])new Object[]{serviceName});
            this.shrinkService(serviceName, false);
        }
    }

    private void shrinkService(String serviceName, boolean isAuto) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5355\u4e2a\u670d\u52a1{}->\u6536\u7f29", (Object[])new Object[]{serviceName});
        Instance instance = this.getInstanceHost(serviceName);
        if (instance != null) {
            LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5173\u95ed[{},{},{}]\u5b9e\u4f8b->\u5f00\u59cb\u8c03\u7528\u63a5\u53e3", (Object[])new Object[]{instance.getIp(), instance.getPort(), serviceName});
            try {
                this.applicationRepository.proxyPost(instance.getId(), "shutdown", null, null);
                this.addHistory(serviceName, instance.getName(), false, isAuto);
                LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5173\u95ed[\u670d\u52a1:{},{}:{}]\u5b9e\u4f8b->\u6210\u529f", (Object[])new Object[]{serviceName, instance.getIp(), instance.getPort()});
            }
            catch (Exception e) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5173\u95ed[\u670d\u52a1:{},{}:{}]\u5b9e\u4f8b->\u5931\u8d25,\u9519\u8bef\u4fe1\u606f[{}]", (Object[])new Object[]{serviceName, instance.getIp(), instance.getPort(), e.getMessage()});
            }
        }
    }

    private void expandService(String serviceName, String hostName, boolean isAuto) {
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5355\u4e2a\u670d\u52a1{}->\u6269\u5bb9", (Object[])new Object[]{serviceName});
        HostDomain host = this.getRandomHost(serviceName, true, hostName);
        if (host != null) {
            LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u90e8\u7f72\u5b9e\u4f8b[{},{}]->\u5f00\u59cb", (Object[])new Object[]{host.getIp(), serviceName});
            VersionInfo maxVersion = ServiceFileUtil.getMaxVersionByName(serviceName);
            if (maxVersion != null) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u90e8\u7f72\u5b9e\u4f8b[{},{}]->\u5f00\u59cb", (Object[])new Object[]{host.getIp(), hostName});
                ArrayList<HostDomain> hostList = new ArrayList<HostDomain>();
                hostList.add(host);
                this.serviceInstallBatch.installBatch(maxVersion, hostList, ModulNameConstant.SERVICE_FLEX);
                this.addHistory(serviceName, host.getHostName(), true, isAuto);
            } else {
                LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5355\u4e2a\u670d\u52a1{}->\u6269\u5bb9\u5931\u8d25,\u65e0\u53ef\u7528\u7248\u672c", (Object[])new Object[]{hostName});
            }
        } else {
            LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u5355\u4e2a\u670d\u52a1{}->\u6269\u5bb9\u5931\u8d25,\u65e0\u53ef\u7528\u4e3b\u673a", (Object[])new Object[]{hostName});
        }
    }

    private void addHistory(String serviceName, String hostName, boolean expand, boolean isAuto) {
        ServiceFlexHistory history = new ServiceFlexHistory();
        history.setId(UUID.randomUUID().toString());
        history.setName(serviceName);
        history.setHost(hostName);
        history.setDesc("");
        if (expand) {
            history.setType("E");
        } else {
            history.setType("S");
        }
        if (isAuto) {
            history.setAuto("0");
        } else {
            history.setAuto("1");
        }
        history.setTime(this.sdf.format(new Date()));
        ((ServiceFlexHistoryService)this.getService(ServiceFlexHistoryService.class)).addFlexHistory(serviceName, history);
    }

    public HostDomain getRandomHost(String name, boolean expand, String hostName) {
        HostDomain hostDomain = null;
        ServiceInfoDomain serviceDomain = this.serviceInfoMapper.getServiceInfoByName(name);
        List serviceOfClusterIds = this.clusterRelMapper.getClusterIdFromServiceClusterRelByServiceId(serviceDomain.getId());
        String serviceBusinessDomain = ((ServiceInfoService)this.getService(ServiceInfoService.class)).getServiceInfoByName(name).getBusinessDomain();
        ArrayList<HostDomain> emptyList = new ArrayList<HostDomain>();
        ArrayList<HostDomain> list0 = new ArrayList<HostDomain>();
        if (StringUtils.isEmpty((CharSequence)hostName)) {
            for (HostDomain host : ((HostService)this.getService(HostService.class)).getHosts()) {
                List hostBusinessDomains = host.getBusinessDomains();
                if (host.getClusters().stream().noneMatch(serviceOfClusterIds::contains)) continue;
                if (hostBusinessDomains == null || hostBusinessDomains.size() == 0) {
                    emptyList.add(host);
                    continue;
                }
                if (!hostBusinessDomains.contains(serviceBusinessDomain)) continue;
                list0.add(host);
            }
            list0.addAll(emptyList);
            for (HostDomain h : list0) {
                Application application = this.applicationRepository.findByName(name);
                if (expand && application == null) {
                    try {
                        SshSessionUtil.collectInfo((HostDomain)hostDomain);
                    }
                    catch (DashboardSessionException e) {
                        log.warn("\u4e3b\u673a:{}\u65e0\u6cd5\u8fde\u63a5!", (Object)hostDomain);
                        continue;
                    }
                    hostDomain = h;
                    break;
                }
                List<Instance> instanceList = application.getInstances();
                int num = instanceList.stream().filter(ins -> StringUtils.equalsIgnoreCase((CharSequence)ins.getIp(), (CharSequence)h.getIp())).collect(Collectors.toList()).size();
                if ((!expand || num >= 1) && (expand || num < 1)) continue;
                hostDomain = h;
                break;
            }
        } else {
            hostDomain = ((HostService)this.getService(HostService.class)).getHostByHostName(hostName);
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_FLEX, (String)"\u83b7\u53d6\u4e3b\u673a->{}", (Object[])new Object[]{hostDomain != null ? hostDomain.getIp() : "null"});
        return hostDomain;
    }

    public Instance getInstanceHost(String name) {
        Application application = this.applicationRepository.findByName(name);
        if (application == null) {
            return null;
        }
        List<Instance> instanceList = application.getInstances();
        List hostList = ((HostService)this.getService(HostService.class)).getHosts();
        if (instanceList.size() == 0 || hostList.size() == 0) {
            return null;
        }
        int index = (int)(Math.random() * (double)instanceList.size());
        Instance instance = instanceList.get(index);
        return instance;
    }

    public String formatDouble(double d) {
        BigDecimal b = BigDecimal.valueOf(d);
        return b.setScale(2, 4).toPlainString();
    }

    public boolean compare(double d1, double d2, String str) {
        boolean flag = false;
        if (str.equals("gte")) {
            boolean bl = flag = d1 >= d2;
        }
        if (str.equals("lte")) {
            flag = d1 <= d2;
        }
        return flag;
    }
}

