/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.governance.config;

import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.executor.ServiceFlexTask;
import cn.com.yusys.yusp.control.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.msm.storage.service.StorageServiceFactory;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class ThreadPoolTaskSchedulerConfig {
    @Autowired
    private StorageServiceFactory factory;
    @Autowired
    private ServiceFlexTask serviceFlexTask;

    private ServiceInfoService getServiceInfo() {
        return (ServiceInfoService)this.factory.getStorageService(ServiceInfoService.class);
    }

    @Bean
    @Primary
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(20);
        scheduler.initialize();
        return scheduler;
    }

    @Scheduled(cron="0 0/10  *  * * ?")
    public void serviceOrderTask() {
        List<ServiceInfoDomain> serviceInfoDomains = this.getServiceInfo().getServicesInfo();
        if (serviceInfoDomains != null) {
            this.serviceFlexTask.autoFlexService(serviceInfoDomains);
        }
    }
}

