/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.gateway.web.rest;

import cn.com.yusys.yusp.control.gateway.domain.DashboardGatewayFilter;
import cn.com.yusys.yusp.control.gateway.service.GateWayFilterService;
import cn.com.yusys.yusp.control.gateway.service.IRefreshGateway;
import cn.com.yusys.yusp.msm.common.ResultDto;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import cn.com.yusys.yusp.msm.log.util.ModulNameConstant;
import cn.com.yusys.yusp.msm.resource.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class GateWayConfigResource
extends Resource {
    private final Logger log = LoggerFactory.getLogger(GateWayConfigResource.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private IRefreshGateway refreshGateway;

    GateWayFilterService getGateWayFilterService() {
        return (GateWayFilterService)this.getService(GateWayFilterService.class);
    }

    @GetMapping(value={"/dashboard/gatewayconfig/changedisable"})
    public ResultDto changeFilterDisable(@RequestParam(required=true) String filtername, @RequestParam String filtertype, String disabled) {
        String logInfo = (Boolean.valueOf(disabled) != false ? "\u505c\u7528" : "\u542f\u7528") + "\u7f51\u5173Filter  \u3010\u540d\u79f0\uff1a" + filtername + "\u3011";
        this.log.info(logInfo);
        String key = String.format("zuul.%s.%s.disable", StringUtils.capitalize((String)filtername), filtertype);
        ResultDto<Map<String, String>> ret = this.refreshGateway.reflushConf(key, disabled);
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)logInfo, (Object[])new Object[]{ret});
        return ret;
    }

    @GetMapping(value={"/dashboard/gatewayconfig/getfilterconfig"})
    public ResultDto<List<DashboardGatewayFilter>> getFilterConfig() {
        return new ResultDto(this.getGateWayFilterService().findGatewayFilter());
    }

    @PostMapping(value={"/api/dashboard/gatewayconfig/disablefilter"})
    public ResultDto<Integer> disableFilter(@RequestBody DashboardGatewayFilter t) {
        this.log.info("\u505c\u7528\u7f51\u5173Filter  \u3010\u540d\u79f0\uff1a" + t.getFiltername() + "\u3011");
        int result = this.getGateWayFilterService().saveGatewayFilter(t);
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u505c\u7528\u7f51\u5173Filter[{}]->{}", (Object[])new Object[]{t.getFiltername(), result});
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/api/dashboard/gatewayconfig/removedisablefilter"})
    public ResultDto<Integer> removedisablefilter(@RequestParam(required=true) String filtername) {
        this.log.info("\u542f\u7528\u7f51\u5173Filter  \u3010\u540d\u79f0\uff1a" + filtername + "\u3011");
        int result = this.getGateWayFilterService().removeGatewayFilter(filtername);
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u542f\u7528\u7f51\u5173Filter[{}]->{}", (Object[])new Object[]{filtername, result});
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/api/gatewayapi/gatewayconfig/getallfilter"})
    public ResultDto<List<Map>> getAllFilter(@RequestParam int page, @RequestParam int size) {
        ResponseEntity r = null;
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u83b7\u53d6\u5df2\u7ecf\u52a0\u8f7d\u7684Filter\u5217\u8868->\u5f00\u59cb", (Object[])new Object[0]);
        List serviceInstances = this.discoveryClient.getInstances("gateway");
        if (serviceInstances == null || serviceInstances.size() == 0) {
            ResultDto t = new ResultDto();
            t.setCode(1);
            t.setMessage("\u6ca1\u6709\u90e8\u7f72\u7f51\u5173,\u8bf7\u90e8\u7f72\u7f51\u5173\u540e\u518d\u4f7f\u7528");
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u6ca1\u6709\u90e8\u7f72\u7f51\u5173,\u8bf7\u90e8\u7f72\u7f51\u5173\u540e\u518d\u4f7f\u7528", (Object[])new Object[0]);
            return t;
        }
        try {
            r = this.restTemplate.getForEntity("http://gateway/api/gatewayapi/gatewayconfig/getallfilter?page=" + page + "&size=" + size, ResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u7f51\u5173\u4fe1\u606f\u5f02\u5e38[{}]", (Object)e.getMessage());
            ResultDto t = new ResultDto();
            t.setCode(1);
            t.setMessage("\u83b7\u53d6\u7f51\u5173\u4fe1\u606f\u5f02\u5e38");
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u83b7\u53d6\u7f51\u5173\u4fe1\u606f->\u5f02\u5e38", (Object[])new Object[0]);
            return t;
        }
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u83b7\u53d6\u5df2\u7ecf\u52a0\u8f7d\u7684Filter\u5217\u8868->\u7ed3\u675f", (Object[])new Object[0]);
        return (ResultDto)r.getBody();
    }

    @GetMapping(value={"/api/gatewayapi/gatewayconfig/getallgateway"})
    public ResultDto<List<Map<String, String>>> getAllGateWay() {
        ArrayList gateWays = new ArrayList();
        List serviceInstances = this.discoveryClient.getInstances("gateway");
        for (ServiceInstance si : serviceInstances) {
            HashMap<String, String> gatewayMap = new HashMap<String, String>();
            gatewayMap.put("gatewayurl", si.getUri().toString());
            gatewayMap.put("metadata", si.getMetadata().toString());
            gatewayMap.put("isOk", "");
            gateWays.add(gatewayMap);
        }
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u83b7\u53d6\u7f51\u5173\u96c6\u7fa4\u5730\u5740\u4fe1\u606f", (Object[])new Object[0]);
        return new ResultDto((long)gateWays.size(), gateWays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/api/gatewayapi/gatewayconfig/maintenancefilterzuul"})
    public ResultDto<Map<String, String>> maintenanceFilterZuul(HttpServletRequest request, @RequestParam String filterName, @RequestParam String opStr, @RequestParam String host) {
        ResultDto err2;
        ResponseEntity r;
        block5: {
            r = null;
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u5f00\u59cb", (Object[])new Object[]{filterName, opStr});
            r = this.restTemplate.getForEntity("http://gateway/api/gatewayapi/gatewayconfig/maintenancefilterzuul?filterName=" + filterName + "&opStr=" + opStr + "&host=" + host, ResultDto.class, new Object[0]);
            if (r.getStatusCodeValue() == 200) break block5;
            ResultDto err2 = new ResultDto();
            err2.setCode(r.getStatusCodeValue());
            err2.setMessage("\u5237\u65b0\u7f51\u5173Filter\u914d\u7f6e\u9519\u8bef");
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u5237\u65b0\u7f51\u5173Filter\u914d\u7f6e\u9519\u8bef", (Object[])new Object[]{filterName, opStr});
            ResultDto resultDto = err2;
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u7ed3\u675f", (Object[])new Object[]{filterName, opStr});
            return resultDto;
        }
        try {
            err2 = (ResultDto)r.getBody();
        }
        catch (Exception e) {
            ResultDto resultDto;
            try {
                this.log.error("\u5237\u65b0\u7f51\u5173Filter\u914d\u7f6e\u9519\u8bef[{}]", (Object)e.getMessage());
                ResultDto err3 = new ResultDto();
                err3.setCode(1);
                err3.setMessage("\u5237\u65b0\u7f51\u5173Filter\u914d\u7f6e\u9519\u8bef");
                LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u5f02\u5e38\u9000\u51fa", (Object[])new Object[]{filterName, opStr});
                resultDto = err3;
            }
            catch (Throwable throwable) {
                LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u7ed3\u675f", (Object[])new Object[]{filterName, opStr});
                throw throwable;
            }
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u7ed3\u675f", (Object[])new Object[]{filterName, opStr});
            return resultDto;
        }
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u52a8\u6001\u7ef4\u62a4\u8fc7\u6ee4\u5668\u7684\u542f\u505c[{}/{}]->\u7ed3\u675f", (Object[])new Object[]{filterName, opStr});
        return err2;
    }

    @GetMapping(value={"/api/gatewayapi/swaggerapi/info"})
    public ResultDto<Map<String, String>> getSwaggerapi(@RequestParam String name) {
        ResultDto result = new ResultDto();
        ResponseEntity r = null;
        Map swaggerapiMap = null;
        try {
            name = name.toLowerCase();
            r = this.restTemplate.getForEntity("http://" + name + "/v2/api-docs", Map.class, new Object[0]);
            if (r.getStatusCodeValue() == 200) {
                swaggerapiMap = (Map)r.getBody();
                HashMap<String, Cloneable> returnData = new HashMap<String, Cloneable>();
                result.setData(returnData);
                List tagsList = (List)swaggerapiMap.get("tags");
                Map pathsMap = (Map)swaggerapiMap.get("paths");
                if (tagsList != null) {
                    ArrayList tagsData = new ArrayList();
                    for (Map tags : tagsList) {
                        HashMap tagsT = new HashMap();
                        tagsT.put("key", tags.get("name"));
                        tagsT.put("value", tags.get("name"));
                        tagsData.add(tagsT);
                    }
                    returnData.put("tagsData", tagsData);
                }
                if (pathsMap != null) {
                    Set pathsEntry = pathsMap.entrySet();
                    Iterator it = pathsEntry.iterator();
                    HashMap pathsData = new HashMap();
                    while (it.hasNext()) {
                        List<HashMap<String, String>> dd;
                        Map.Entry emsmm1;
                        Map emsmm;
                        List this_tags;
                        Map.Entry e = it.next();
                        String this_url = (String)e.getKey();
                        Map em = (Map)e.getValue();
                        Set ems = em.entrySet();
                        Iterator emsm = ems.iterator();
                        if (!emsm.hasNext() || (this_tags = (List)(emsmm = (Map)(emsmm1 = emsm.next()).getValue()).get("tags")) == null || this_tags.size() <= 0) continue;
                        String this_tag = (String)this_tags.get(0);
                        HashMap<String, String> url_map = new HashMap<String, String>();
                        url_map.put("key", this_url);
                        url_map.put("value", this_url);
                        if (pathsData.containsKey(this_tag)) {
                            dd = (List)pathsData.get(this_tag);
                            dd.add(url_map);
                            continue;
                        }
                        dd = new ArrayList();
                        dd.add(url_map);
                        pathsData.put(this_tag, dd);
                    }
                    returnData.put("pathsData", pathsData);
                }
            } else {
                result.setCode(1);
                result.setMessage("\u901a\u8fc7\u8c03\u7528swagger\u83b7\u53d6API\u6587\u6863,\u8fd4\u56de\u9519\u8bef");
            }
        }
        catch (Exception e) {
            this.log.error("\u901a\u8fc7\u8c03\u7528swagger\u83b7\u53d6API\u6587\u6863\u9519\u8bef", (Throwable)e);
            result.setCode(1);
            result.setMessage("\u901a\u8fc7\u8c03\u7528swagger\u83b7\u53d6API\u6587\u6863\u5f02\u5e38");
        }
        return result;
    }
}

