/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.gateway.service.impl;

import cn.com.yusys.yusp.control.gateway.service.ServiceLimiterService;
import cn.com.yusys.yusp.control.governance.domain.LimitArgs;
import cn.com.yusys.yusp.control.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.control.governance.domain.ServiceLimitDomain;
import cn.com.yusys.yusp.control.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.control.repository.mapper.LimitDetailedMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceInfoMapper;
import cn.com.yusys.yusp.control.repository.mapper.ServiceLimiterMapper;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class ServiceLimiterServiceDBImpl
implements ServiceLimiterService {
    @Autowired
    ApplicationRepository applicationRepository;
    @Autowired
    private ServiceInfoMapper serviceInfoMapper;
    @Autowired
    ServiceLimiterMapper serviceLimiterMapper;
    @Autowired
    LimitDetailedMapper limitDetailedMapper;

    @Override
    public List<ServiceInfoDomain> getServiceLimitInfo() {
        List<ServiceInfoDomain> list = this.serviceInfoMapper.getServicesInfo();
        for (ServiceInfoDomain s : list) {
            s.setLimitDomains(this.serviceLimiterMapper.getLimitByServiceId(s.getId()));
            List<ServiceLimitDomain> limitList = s.getLimitDomains();
            for (ServiceLimitDomain serviceLimit : limitList) {
                serviceLimit.setLimitArgs(this.limitDetailedMapper.getLimitDetailedByLimitId(serviceLimit.getLimitId()));
            }
        }
        return list;
    }

    @Override
    public List<ServiceLimitDomain> getLimitParameter(String name) {
        ServiceInfoDomain s = this.serviceInfoMapper.getServiceInfoByName(name);
        if (s == null) {
            return null;
        }
        String[] limitMode = new String[]{"IP", "LOGIN", "URI", "QPS", "TPS"};
        List<ServiceLimitDomain> list = null;
        if (s != null) {
            list = this.serviceLimiterMapper.getLimitByServiceId(s.getId());
        }
        ArrayList<ServiceLimitDomain> listR = new ArrayList<ServiceLimitDomain>();
        for (int i = 0; i < limitMode.length; ++i) {
            ServiceLimitDomain limitParam = new ServiceLimitDomain();
            limitParam.setLimitId(UUID.randomUUID().toString());
            limitParam.setServiceId(s.getId());
            limitParam.setLimitMode(limitMode[i]);
            limitParam.setIntervalPeriod("60");
            limitParam.setLimitValue("100");
            limitParam.setLimitState("I");
            if (list == null || !list.contains(limitParam)) {
                limitParam.setLimitArgs(null);
                listR.add(limitParam);
                continue;
            }
            int index = list.indexOf(limitParam);
            list.get(index).setLimitArgs(this.limitDetailedMapper.getLimitDetailedByLimitId(list.get(index).getLimitId()));
            listR.add(list.get(index));
        }
        return listR;
    }

    @Override
    public int updateLimitParameter(String name, ServiceLimitDomain serviceLimitDomain) {
        ServiceInfoDomain serviceInfoDomain = this.serviceInfoMapper.getServiceInfoByName(name);
        List<ServiceLimitDomain> serviceLimitList = this.serviceLimiterMapper.getLimitByServiceId(serviceInfoDomain.getId());
        this.limitDetailedMapper.deleteLimitDetailedByLimitId(serviceLimitDomain.getLimitId());
        if (serviceLimitDomain.getLimitArgs() != null) {
            for (LimitArgs limitArgs : serviceLimitDomain.getLimitArgs()) {
                limitArgs.setLimitInfoId(UUID.randomUUID().toString());
                limitArgs.setLimitId(serviceLimitDomain.getLimitId());
                this.limitDetailedMapper.insertLimitDetailed(limitArgs);
            }
        }
        if (serviceLimitList.size() > 0) {
            for (ServiceLimitDomain s : serviceLimitList) {
                if (!serviceLimitDomain.getLimitMode().equals(s.getLimitMode())) continue;
                return this.serviceLimiterMapper.updateLimit(serviceLimitDomain);
            }
        }
        return this.serviceLimiterMapper.insertLimit(serviceLimitDomain);
    }
}

