/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.gateway.service.impl;

import cn.com.yusys.yusp.control.gateway.service.IRefreshGateway;
import cn.com.yusys.yusp.msm.common.ResultDto;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class ApolloOpenApiRefreshGateway
implements IRefreshGateway {
    private final Logger log = LoggerFactory.getLogger(ApolloOpenApiRefreshGateway.class);
    @Value(value="${apollo.portal.url}")
    private String portalUrl;
    @Value(value="${apollo.open-api.token}")
    private String token;
    @Value(value="${apollo.open-api.cluster-name:default}")
    private String clusterName;
    @Value(value="${apollo.gateway.modify-by:apollo}")
    private String modifiedBy;
    @Value(value="${apollo.gateway.env:dev}")
    private String env;
    @Value(value="${apollo.gateway.appId:yusp-gateway}")
    private String appId;
    @Value(value="${apollo.gateway.namespace:application}")
    private String namespace;
    private ApolloOpenApiClient client;

    @ApolloConfigChangeListener
    public void onChange(ConfigChangeEvent changeEvent) {
        boolean apolloPropertiesChanged = false;
        for (String changedKey : changeEvent.changedKeys()) {
            if (!changedKey.startsWith("apollo.")) continue;
            apolloPropertiesChanged = true;
            break;
        }
        if (apolloPropertiesChanged) {
            this.initClient();
        }
    }

    private void initClient() {
        this.log.info("\u521d\u59cb\u5316ApolloOpenApi\u7b2c\u4e09\u65b9\u63a5\u5165\u5ba2\u6237\u7aef\uff01");
        this.client = ApolloOpenApiClient.newBuilder().withPortalUrl(this.portalUrl).withToken(this.token).build();
        if (this.log.isDebugEnabled()) {
            this.log.debug("ApolloOpenApi\u521d\u59cb\u5316\u53c2\u6570\uff1aportalUrl={},token={}", (Object)this.portalUrl, (Object)this.token);
        }
    }

    @Override
    public ResultDto<Map<String, String>> reflushConf(String key, String value) {
        if (this.client == null) {
            this.initClient();
        }
        ResultDto ret = new ResultDto();
        try {
            OpenItemDTO item = new OpenItemDTO();
            item.setKey(key);
            item.setValue(value);
            item.setDataChangeLastModifiedBy(this.modifiedBy);
            item.setDataChangeCreatedTime(new Date());
            this.client.updateItem(this.appId, this.env, this.clusterName, this.namespace, item);
            this.log.info("\u66f4\u65b0Apollo\u914d\u7f6e\u9879\uff01appId={},env={},clusterName={},namespace={},key={}", new Object[]{this.appId, this.env, this.clusterName, this.namespace, key});
            Thread.sleep(500L);
            NamespaceReleaseDTO releaseDTO = new NamespaceReleaseDTO();
            releaseDTO.setReleaseTitle("update by program");
            releaseDTO.setReleasedBy(this.modifiedBy);
            releaseDTO.setEmergencyPublish(true);
            releaseDTO.setReleaseComment("");
            this.client.publishNamespace(this.appId, this.env, this.clusterName, this.namespace, releaseDTO);
            this.log.info("\u53d1\u5e03Apollo\u914d\u7f6e\u9879\u6210\u529f\uff01appId={},env={},key={}", new Object[]{this.appId, this.env, key});
            ret.setCode(0);
            ret.setMessage("\u5b9e\u65f6\u540c\u6b65Apollo\u6210\u529f\uff01");
        }
        catch (Exception e) {
            ret.setCode(1);
            ret.setMessage("\u5b9e\u65f6\u540c\u6b65Apollo\u5f02\u5e38\uff1a" + e.getMessage());
            this.log.error("\u53d1\u5e03Apollo\u914d\u7f6e\u9879\u5931\u8d25\uff01", (Throwable)e);
        }
        return ret;
    }
}

