/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.client.web.rest;

import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.control.client.domain.MsAuthClient;
import cn.com.yusys.yusp.control.client.domain.MsAuthResource;
import cn.com.yusys.yusp.control.client.service.AuthClientService;
import cn.com.yusys.yusp.control.client.service.AuthResService;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth/resource"})
public class AuthServiceResource {
    @Autowired
    private AuthResService authResService;
    @Autowired
    private AuthClientService authClientService;

    @GetMapping(value={"/getauthresbyname"})
    public ResultDto<List<MsAuthResource>> getAuthResByName(@RequestParam(required=false) String serviceName) {
        ResultDto dto = new ResultDto(this.authResService.getResByName(serviceName));
        if (!StringUtils.isEmpty((Object)serviceName)) {
            LogUtil.info((Object)"authService", (String)"\u83b7\u53d6\u670d\u52a1\u540d\u4e3a\uff1a{}\u7684\u670d\u52a1\u5217\u8868->\u6210\u529f", (Object[])new Object[]{serviceName});
        }
        return dto;
    }

    @GetMapping(value={"/getclientsbyserviceid"})
    public ResultDto<List<MsAuthClient>> getClientsByServiceId(@RequestParam String serviceId) {
        ResultDto dto = new ResultDto(this.authClientService.getClientsByServiceId(serviceId));
        LogUtil.info((Object)"authService", (String)"\u83b7\u53d6\u670d\u52a1:{}\u7684\u6388\u6743\u5ba2\u6237\u7aef\u5217\u8868->\u6210\u529f", (Object[])new Object[]{serviceId});
        return dto;
    }

    @GetMapping(value={"/getunauthresbyid"})
    public ResultDto<List<MsAuthResource>> getUnauthResById(String clientId, String serviceName) {
        ResultDto dto = new ResultDto(this.authResService.getUnauthResById(clientId, serviceName));
        LogUtil.info((Object)"authService", (String)"\u83b7\u53d6:clientId:{},serviceName:{}\u7684\u672a\u6388\u6743\u670d\u52a1\u5217\u8868->\u6210\u529f", (Object[])new Object[]{clientId, serviceName});
        return dto;
    }

    @PostMapping(value={"/saveorupdateservice"})
    public ResultDto<MsAuthResource> saveOrUpdateService(@RequestBody MsAuthResource msAuthResource) {
        ResultDto resultDto = new ResultDto((Object)this.authResService.saveOrUpdateService(msAuthResource));
        return resultDto;
    }

    @PostMapping(value={"/deleteservice"})
    public ResultDto<Integer> deleteService(@RequestBody String ids) {
        ResultDto resultDto = new ResultDto((Object)this.authResService.deleteServiceById(ids));
        LogUtil.info((Object)"authService", (String)"\u5220\u9664\u670d\u52a1\uff1a{}->\u6210\u529f", (Object[])new Object[]{ids});
        return resultDto;
    }
}

