/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.client.service;

import cn.com.yusys.yusp.control.client.domain.MsAuthResource;
import cn.com.yusys.yusp.control.client.repository.mapper.AuthResMapper;
import cn.com.yusys.yusp.msm.log.util.LogUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AuthResService {
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private AuthResMapper authResMapper;

    public List<MsAuthResource> getAuthResById(String clientId) {
        return this.authResMapper.getAuthResById(clientId);
    }

    public List<MsAuthResource> getUnauthResById(String clientId, String serviceName) {
        return this.authResMapper.getUnauthResById(clientId, serviceName);
    }

    public List<MsAuthResource> getServiceByServiceId(String serviceId) {
        return this.authResMapper.getServiceByServiceId(serviceId);
    }

    public List<MsAuthResource> getResByName(String serviceName) {
        return this.authResMapper.getResByName(serviceName);
    }

    public MsAuthResource saveOrUpdateService(MsAuthResource msAuthResource) {
        String serviceId = msAuthResource.getServiceId();
        String userName = SecurityContextHolder.getContext().getAuthentication().getName();
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            serviceId = UUID.randomUUID().toString().replace("-", "");
            msAuthResource.setServiceId(serviceId);
            String time = formatter.format(LocalDateTime.now());
            msAuthResource.setCreator(userName);
            msAuthResource.setCreateTime(time);
            msAuthResource.setUpdateTime(time);
            msAuthResource.setUpdateUser(msAuthResource.getCreator());
            this.authResMapper.registerService(msAuthResource);
            LogUtil.info((Object)"authService", (String)"\u65b0\u589e\u670d\u52a1,\u670d\u52a1Id\uff1a{}->\u6210\u529f", (Object[])new Object[]{serviceId});
        } else {
            List<MsAuthResource> oldList = this.authResMapper.getServiceByServiceId(serviceId);
            if (oldList == null | oldList.size() != 1) {
                LogUtil.error((Object)"authService", (String)"\u83b7\u53d6ServiceId:{}\u5bf9\u5e94\u8d44\u6e90->\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u8d44\u6e90", (Object[])new Object[]{serviceId});
            }
            msAuthResource.setUpdateUser(userName);
            msAuthResource.setUpdateTime(formatter.format(LocalDateTime.now()));
            this.authResMapper.updateService(msAuthResource);
            LogUtil.info((Object)"authService", (String)"\u53d8\u66f4\u670d\u52a1,\u670d\u52a1Id\uff1a{}->\u6210\u529f", (Object[])new Object[]{serviceId});
        }
        return msAuthResource;
    }

    public int deleteServiceById(String ids) {
        String[] idArray = ids.split(",");
        this.authResMapper.deleteAuthServiceById(idArray);
        return this.authResMapper.deleteServiceById(idArray);
    }
}

