/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.control.apollo.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"redis.cache.enabled"})
@ConfigurationProperties(prefix="redis.cache")
@Component(value="sampleRedisConfig")
@RefreshScope
public class SampleRedisConfig {
    private static final Logger logger = LoggerFactory.getLogger(SampleRedisConfig.class);
    private int expireSeconds;
    private String clusterNodes;
    private int commandTimeout;
    private Map<String, String> someMap = Maps.newLinkedHashMap();
    private List<String> someList = Lists.newLinkedList();

    @PostConstruct
    private void initialize() {
        logger.info("SampleRedisConfig initialized - expireSeconds: {}, clusterNodes: {}, commandTimeout: {}, someMap: {}, someList: {}", new Object[]{this.expireSeconds, this.clusterNodes, this.commandTimeout, this.someMap, this.someList});
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public Map<String, String> getSomeMap() {
        return this.someMap;
    }

    public List<String> getSomeList() {
        return this.someList;
    }

    public String toString() {
        return String.format("[SampleRedisConfig] expireSeconds: %d, clusterNodes: %s, commandTimeout: %d, someMap: %s, someList: %s", this.expireSeconds, this.clusterNodes, this.commandTimeout, this.someMap, this.someList);
    }
}

