/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.license;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacUtil {
    public static final String SPLIT_CHAR = "-";

    static String getMacAddress() {
        StringBuffer sb = new StringBuffer();
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            while (el.hasMoreElements()) {
                byte[] mac = el.nextElement().getHardwareAddress();
                if (mac == null || mac.length <= 0) continue;
                String hexstr = MacUtil.byte2HexString(mac);
                sb.append(String.valueOf(hexstr) + SPLIT_CHAR);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String byte2HexString(byte[] src) {
        StringBuffer sb = new StringBuffer();
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            String hex = Integer.toHexString(src[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static List<String> macStringToList(String mac) {
        if (mac == null || "".equals(mac)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(mac.split(SPLIT_CHAR)));
    }

    public static boolean retainMac(String a, String b) {
        List<String> listA = MacUtil.macStringToList(a);
        List<String> listB = MacUtil.macStringToList(b);
        listA.retainAll(listB);
        return !listA.isEmpty();
    }
}

