/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.license;

import cn.com.yusys.license.LicenseException;
import cn.com.yusys.license.ResourceUtils;
import cn.com.yusys.license.VerityLicenseAssist;
import com.yuchenglicense.LicenseVerify;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class LicenseManager {
    static final String LICENSE_DEV = "TRIAL";
    static final String LICENSE_DEP = "PRO";
    static final String licenseType = "\u5ba2\u6237\u9500\u552e\u8bb8\u53ef\u8bc1";
    static final int DAYS = 30;
    static String LICENSE_ERROR = "The license has not been enabled for more than the specified time. It is invalid! Please contact the sales to apply again!";
    private String licenseModel = "PRO";
    private String licenseFile = "";
    private String macFile = "";
    private InputStream inputStream = null;
    private boolean verified = false;
    private LicenseVerify licenseVerify;
    private String licensePath = String.valueOf(ResourceUtils.getFilePath(LicenseManager.class)) + File.separator;
    private static LicenseManager instance;
    private String errorMessage;
    private final String line = System.getProperty("line.separator");

    private LicenseManager() {
    }

    public static LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    @Deprecated
    public String initialize() {
        return this.initialize(null, null);
    }

    public String initialize(String productCode) {
        return this.initialize(productCode, null);
    }

    public String initialize(String productCode, String expendInfo) {
        this.verified = this.verifyLicense(productCode, expendInfo);
        if (!this.verified) {
            throw new LicenseException(String.valueOf(this.errorMessage) + this.getLicenseInfo());
        }
        return this.getLicenseInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyLicense(String productCode, String expendInfo) {
        try {
            if (this.inputStream == null) {
                File file = new File(this.licenseFile);
                if (!file.exists()) {
                    this.licenseFile = String.valueOf(this.licensePath) + this.licenseFile;
                    file = new File(this.licenseFile);
                }
                if (!file.exists()) {
                    return false;
                }
                this.inputStream = new FileInputStream(file);
            }
            this.licenseVerify = new LicenseVerify(this.inputStream);
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        if (productCode == null) {
            this.errorMessage = "product code must not be null";
            return false;
        }
        if (!this.licenseVerify.licenseValid()) {
            this.errorMessage = this.licenseVerify.getErrorMessage();
            return false;
        }
        if (this.licenseFile == null && (!LICENSE_DEV.equals(this.licenseModel) && !LICENSE_DEP.equals(this.licenseModel) || LICENSE_DEV.equals(this.licenseModel) && this.valLicenseModel() || LICENSE_DEP.equals(this.licenseModel) && !this.valLicenseModel())) {
            this.errorMessage = "license file mode configuration error!";
            return false;
        }
        if (LICENSE_DEP.equals(this.licenseModel) && this.macFile != null && !"".equals(this.macFile) && !this.assistVerify()) {
            this.errorMessage = LICENSE_ERROR;
            return false;
        }
        if (productCode.equals(this.licenseVerify.getProductCode())) {
            return true;
        }
        if (expendInfo == null) {
            this.errorMessage = "The product number is inconsistent with the License or the extended information does not contain the product";
            return false;
        }
        HashMap expendMap = this.licenseVerify.getExpendInfo();
        if (expendMap.containsKey(expendInfo) && "true".equalsIgnoreCase(String.valueOf(expendMap.get(expendInfo)))) {
            return true;
        }
        this.errorMessage = "The product is not included in the License extended information";
        return false;
    }

    private boolean valLicenseModel() {
        return licenseType.equals(this.licenseVerify.getLicenseType());
    }

    private boolean assistVerify() {
        VerityLicenseAssist ass = new VerityLicenseAssist();
        return ass.valAppBuildTime(this.licenseVerify.getBuildTime());
    }

    private String getLicenseInfo() {
        StringBuilder lic = new StringBuilder();
        lic.append(this.line).append("License creation time:").append(this.licenseVerify.getBuildTime());
        lic.append(this.line).append("License No.:").append(this.licenseVerify.getLicenseCode());
        lic.append(this.line).append("Product No.:").append(this.licenseVerify.getProductCode());
        lic.append(this.line).append("Chinese name of product:").append(this.licenseVerify.getProductNameZh());
        lic.append(this.line).append("Product abbreviation:").append(this.licenseVerify.getProductNameEn());
        lic.append(this.line).append("Product version No.:").append(this.licenseVerify.getVersionMajor()).append('.').append(this.licenseVerify.getVersionSub()).append('.').append(this.licenseVerify.getVersionPublish());
        lic.append(this.line).append("Product compile date:").append(this.licenseVerify.getComplieDate());
        lic.append(this.line).append("Product license type:").append(this.licenseVerify.getLicenseType());
        lic.append(this.line).append("Product customer use name:").append(this.licenseVerify.getCustomerName());
        lic.append(this.line).append("Product sales contract No.:").append(this.licenseVerify.getContractCode());
        lic.append(this.line).append("Including technical products:").append(this.licenseVerify.getExpendInfo().keySet());
        lic.append(this.line).append("Start Date:").append(this.licenseVerify.getLicenseStartTime());
        lic.append(this.line).append("End Date:").append(this.licenseVerify.getLicenseEndTime());
        lic.append(this.line);
        return lic.toString();
    }

    public LicenseVerify getLicenseVerify() {
        return this.licenseVerify;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getMacFile() {
        return this.macFile;
    }

    public void setMacFile(String macFile) {
        this.macFile = macFile;
    }
}

