/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.swagger;

import cn.com.yusys.yusp.commons.fee.common.SwaggerHotLoad;
import cn.com.yusys.yusp.commons.fee.common.component.Definition;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.core.FeeRunner;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import cn.com.yusys.yusp.commons.fee.core.init.definition.ParamDefinition;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationModelContextsBuilder;

public class SwaggerModelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerModelProcessor.class);
    private static final String POST_PARAM_MODEL_CLASS_PREFIX = "cn.com.yusys.yusp.commons.fee.core.swagger.dynamic.InputModel";
    private static final String OUTPUT_MODEL_CLASS_PREFIX = "cn.com.yusys.yusp.commons.fee.core.swagger.dynamic.OutputModel";
    private Map<String, Model> models = new WeakHashMap<String, Model>();
    private Map<String, Class> paramPostModel = new WeakHashMap<String, Class>();
    private Map<String, Class> resultModel = new WeakHashMap<String, Class>();
    private int modelSeq = 0;
    @Autowired
    private FlowDefinitionRegistry flowDefinitionRegistry;
    @Autowired
    @Qualifier(value="default")
    private ModelProvider modelProvider;
    @Autowired(required=false)
    private SwaggerHotLoad hotLoadSwagger;
    @Autowired
    private FeeRunner feeRunner;

    public void addModel(DocumentationContext context) {
        OperationModelContextsBuilder builder = new OperationModelContextsBuilder(context.getGroupName(), context.getDocumentationType(), context.getAlternateTypeProvider(), context.getGenericsNamingStrategy(), context.getIgnorableParameterTypes());
        Map allFlow = this.flowDefinitionRegistry.getAllFlow();
        for (Map.Entry entry : allFlow.entrySet()) {
            FlowDefinition flowDefinition = (FlowDefinition)entry.getValue();
            if (!flowDefinition.isPublish()) continue;
            List input = flowDefinition.getInput();
            String requestType = flowDefinition.getRequestType();
            if ("GET".equalsIgnoreCase(requestType)) {
                this.addGetParam(builder, input);
            } else if ("POST".equalsIgnoreCase(requestType)) {
                this.addPostParam(builder, input, flowDefinition.getFlowId());
            }
            this.addReturn(builder, flowDefinition);
        }
        Set modelContexts = builder.build();
        if (modelContexts != null && !modelContexts.isEmpty()) {
            Map modelsMap = modelContexts.stream().map(arg_0 -> ((ModelProvider)this.modelProvider).modelFor(arg_0)).filter(Optional::isPresent).collect(Collectors.toMap(o -> ((Model)o.get()).getName(), Optional::get, (a, b) -> a, HashMap::new));
            this.models.putAll(modelsMap);
        }
    }

    private void addPostParam(OperationModelContextsBuilder builder, List<Definition> input, String flowId) {
        if (input != null && !input.isEmpty()) {
            ParamDefinition firstParamDefinition = (ParamDefinition)input.get(0);
            if (input.size() == 1 && !ClassUtil.isBasicType((StringBuilder)new StringBuilder(firstParamDefinition.getClassName()))) {
                this.addParam(builder, firstParamDefinition);
            } else {
                try {
                    Class clazz = this.createParamModel(input, flowId);
                    builder.addInputParam((Type)clazz);
                    this.paramPostModel.put(flowId, clazz);
                }
                catch (Exception e) {
                    logger.debug("", (Throwable)e);
                }
            }
        }
    }

    private void addGetParam(OperationModelContextsBuilder builder, List<Definition> input) {
        if (input != null && !input.isEmpty()) {
            for (Definition d : input) {
                ParamDefinition p = (ParamDefinition)d;
                this.addParam(builder, p);
            }
        }
    }

    private void addParam(OperationModelContextsBuilder builder, ParamDefinition p) {
        StringBuilder className = new StringBuilder(p.getClassName());
        ClassUtil.isBasicType((StringBuilder)className);
        try {
            if (!StringUtils.isEmpty((Object)className)) {
                builder.addInputParam(Class.forName(className.toString()));
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug("", (Throwable)e);
        }
    }

    private void addReturn(OperationModelContextsBuilder builder, FlowDefinition flowDefinition) {
        ParamDefinition output = (ParamDefinition)flowDefinition.getOutput();
        if (output == null || StringUtils.isEmpty((Object)output.getClassName())) {
            return;
        }
        String flowId = flowDefinition.getFlowId();
        StringBuilder className = new StringBuilder(output.getClassName());
        ClassUtil.isBasicType((StringBuilder)className);
        try {
            builder.addReturn(Class.forName(className.toString()));
        }
        catch (ClassNotFoundException e) {
            logger.debug("", (Throwable)e);
        }
        Class clazz = this.createResult(className.toString(), flowId);
        if (clazz != null) {
            this.resultModel.put(flowId, clazz);
            builder.addReturn((Type)clazz);
        }
    }

    public Class createResult(String dataClassName, String flowId) {
        ClassPool pool = ClassPool.getDefault();
        String className = OUTPUT_MODEL_CLASS_PREFIX + flowId;
        try {
            CtClass ctClass = this.getOrNull(pool, className);
            if (ctClass != null) {
                return Class.forName(className);
            }
            ctClass = pool.makeClass(className);
            CtField code = new CtField(pool.get("java.lang.String"), "code", ctClass);
            CtField msg = new CtField(pool.get("java.lang.String"), "msg", ctClass);
            CtField data = new CtField(pool.get(dataClassName), "data", ctClass);
            code.setModifiers(2);
            msg.setModifiers(2);
            data.setModifiers(2);
            ctClass.addField(code);
            ctClass.addField(msg);
            ctClass.addField(data);
            ctClass.addMethod(CtNewMethod.setter((String)"setCode", (CtField)code));
            ctClass.addMethod(CtNewMethod.getter((String)"getCode", (CtField)code));
            ctClass.addMethod(CtNewMethod.setter((String)"setMsg", (CtField)msg));
            ctClass.addMethod(CtNewMethod.getter((String)"getMsg", (CtField)msg));
            ctClass.addMethod(CtNewMethod.setter((String)"setData", (CtField)data));
            ctClass.addMethod(CtNewMethod.getter((String)"getData", (CtField)data));
            return ctClass.toClass();
        }
        catch (Exception e) {
            logger.debug("", (Throwable)e);
            return null;
        }
    }

    public Class createParamModel(List<Definition> input, String flowId) throws Exception {
        String className;
        ClassPool pool = ClassPool.getDefault();
        CtClass ctClass = this.getOrNull(pool, className = POST_PARAM_MODEL_CLASS_PREFIX + flowId);
        if (ctClass != null) {
            if (this.feeRunner.isStarted() && flowId.equals(this.hotLoadSwagger.getFlowId())) {
                className = className + this.modelSeq++;
            } else {
                return Class.forName(className);
            }
        }
        ctClass = pool.makeClass(className);
        if (input != null && !input.isEmpty()) {
            for (Definition d : input) {
                ParamDefinition p = (ParamDefinition)d;
                CtField ctField = this.createField(p, ctClass);
                ctClass.addField(ctField);
                String fieldName = p.getName();
                ctClass.addMethod(CtNewMethod.getter((String)this.getterName(fieldName, ctField, pool), (CtField)ctField));
                ctClass.addMethod(CtNewMethod.setter((String)this.setterName(fieldName), (CtField)ctField));
            }
        }
        return ctClass.toClass();
    }

    public CtField createField(ParamDefinition paramDefinition, CtClass ctClass) throws Exception {
        ClassPool classPool = ClassPool.getDefault();
        CtClass fileType = classPool.get(ClassUtil.convertBasicType((String)paramDefinition.getClassName(), (boolean)paramDefinition.isArray()));
        CtField ctField = new CtField(fileType, paramDefinition.getName(), ctClass);
        ctField.setModifiers(2);
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation ann = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
        ann.addMemberValue("value", (MemberValue)new StringMemberValue(paramDefinition.getDescription(), constPool));
        ann.addMemberValue("example", (MemberValue)new StringMemberValue(paramDefinition.getSwaggerExample(), constPool));
        attr.addAnnotation(ann);
        ctField.getFieldInfo().addAttribute((AttributeInfo)attr);
        return ctField;
    }

    private String setterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private String getterName(String fieldName, CtField ctField, ClassPool pool) {
        String name = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            name = ctField.getType().subclassOf(pool.get(Boolean.class.getName())) ? "is" + name : "get" + name;
        }
        catch (NotFoundException e) {
            logger.debug("", (Throwable)e);
        }
        return name;
    }

    private CtClass getOrNull(ClassPool pool, String className) {
        try {
            return pool.get(className);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public Map<String, Model> getModels() {
        return this.models;
    }

    public Map<String, Class> getParamPostModel() {
        return this.paramPostModel;
    }

    public Map<String, Class> getResultModel() {
        return this.resultModel;
    }
}

