/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.config;

import cn.com.yusys.yusp.bsp.workflow.IService;
import cn.com.yusys.yusp.commons.fee.common.logic.DistributeLock;
import cn.com.yusys.yusp.commons.fee.db.redis.BaseRedisOperation;
import cn.com.yusys.yusp.commons.fee.db.redis.RedisDistributeLock;
import cn.com.yusys.yusp.commons.fee.logic.IdempotentLogic;
import cn.com.yusys.yusp.commons.fee.logic.communicate.BSPService;
import cn.com.yusys.yusp.commons.fee.logic.lock.RedisLock;
import cn.com.yusys.yusp.commons.fee.logic.lock.ZkLock;
import cn.com.yusys.yusp.commons.fee.logic.redis.RedisLogic;
import cn.com.yusys.yusp.commons.fee.logic.zk.ZkCondition;
import cn.com.yusys.yusp.commons.fee.logic.zk.ZkWrapper;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class LogicAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IService iService() {
        return new BSPService();
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public RedisLogic redisLogic() {
        return new RedisLogic();
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public RedisLock redisLock() {
        return new RedisLock();
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public IdempotentLogic idempotent() {
        return new IdempotentLogic();
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public BaseRedisOperation baseRedisOperation() {
        return new BaseRedisOperation();
    }

    @Bean
    @ConditionalOnClass(value={RedisTemplate.class})
    public DistributeLock redisDistributeLock() {
        return new RedisDistributeLock();
    }

    @Bean(value={"feeRedisTemplate"})
    @ConditionalOnClass(value={RedisTemplate.class})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public ZkLock zkLock() {
        return new ZkLock();
    }

    @Bean
    public ZkWrapper wrapperZK() {
        return new ZkWrapper();
    }

    @Bean(initMethod="start")
    @Conditional(value={ZkCondition.class})
    public CuratorFramework curatorFramework() {
        return CuratorFrameworkFactory.newClient((String)this.wrapperZK().getConnectString(), (int)this.wrapperZK().getSessionTimeoutMs(), (int)this.wrapperZK().getConnectionTimeoutMs(), (RetryPolicy)new RetryNTimes(this.wrapperZK().getRetryCount(), this.wrapperZK().getElapsedTimeMs()));
    }
}

