/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.communicate;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.bsp.workflow.comm.out.CommType;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.ContextUtil;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.common.util.MessageFormat;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.component.QueryModelSupport;
import cn.com.yusys.yusp.commons.mapper.QueryModel;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@CataLog(nodeType=ActionNodeType.COMMUNICAT, value="tyzj/txgj")
public class CommunicatLogic {
    private static final Logger logger = LoggerFactory.getLogger(CommunicatLogic.class);
    private static final String MARK = "${";
    private static final String SLASH = "/{";

    public static <T> T bspGet(@LogicParam(description="spqmc", assignType="CONSTANT") String adapterName, @LogicParam(description="jydm", assignType="CONSTANT") String tradeCode, @LogicParam(description="qqdx") Object paramObj, @LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="xyc", assignType="CONSTANT") Class<T> rtnClazz) {
        return CommunicatLogic.bspAccess(adapterName, tradeCode, paramObj, api, rtnClazz, HttpMethod.GET);
    }

    @Logic(description="bsptxjc", async=true)
    public static <T> T bspPost(@LogicParam(description="spqmc", assignType="CONSTANT") String adapterName, @LogicParam(description="jydm", assignType="CONSTANT") String tradeCode, @LogicParam(description="qqdx") Object paramObj, @LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="xyc", assignType="CONSTANT") Class<T> rtnClazz) {
        return CommunicatLogic.bspAccess(adapterName, tradeCode, paramObj, api, rtnClazz, HttpMethod.POST);
    }

    @Logic(description="bsptxjc", async=true)
    public static <T> T bspPost(@LogicParam(description="spqmc", assignType="CONSTANT") String adapterName, @LogicParam(description="jydm", assignType="CONSTANT") String tradeCode, @LogicParam(description="qqdx") Object paramObj, @LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="xyc", assignType="CONSTANT") String rtnClazz) throws Exception {
        Class<?> aClass = Class.forName(rtnClazz);
        return (T)CommunicatLogic.bspAccess(adapterName, tradeCode, paramObj, api, aClass, HttpMethod.POST);
    }

    private static <T> T bspAccess(String adapterName, String tradeCode, Object paramObj, String api, Class<T> rtnClazz, HttpMethod httpMethod) {
        logger.info("Adapter name[{}], transaction code[{}], request object[{}]", new Object[]{adapterName, tradeCode, paramObj});
        HashMap<String, String> commPara = new HashMap<String, String>();
        commPara.put(CommType.HTTPCOMM_URI.getKey(), api);
        commPara.put(CommType.HTTPCOMM_METHOD.getKey(), httpMethod.name());
        commPara.put(CommType.HTTPCOMM_CONTENTTYPE.getKey(), "application/json");
        try {
            Object result = BspTemplate.exchange((String)adapterName, (String)tradeCode, (Object)paramObj, commPara, rtnClazz);
            if (logger.isDebugEnabled()) {
                logger.debug("result:{}", result);
            }
            return (T)result;
        }
        catch (Exception ex) {
            logger.error("BSP request failed", (Throwable)ex);
            throw Error.COMMUNICATE_BSP_FAILED.expcetion(ex.getMessage());
        }
    }

    @Logic(description="wfwgetjc", async=true)
    public static Object restCallGet(@LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="xylmc", assignType="CONSTANT") String responseClassName, @LogicParam(description="csstl") Object paramObj) {
        return CommunicatLogic.restCallGet2(api, responseClassName, paramObj);
    }

    private static Object restCallGet2(String api, String responseClassName, Object paramObj) {
        try {
            Flow currentFlow = FlowUtil.getSAGACurrentFlow();
            RestTemplate restTemplate = null;
            restTemplate = currentFlow != null ? (RestTemplate)SpringContextHolder.getBean((String)"omegaRestTemplate") : (RestTemplate)SpringContextHolder.getBean((String)"feeresttemplate");
            api = MessageFormat.queryLine((String)api, (Object)paramObj);
            if (api.startsWith("1")) {
                api = "http://" + api;
            }
            if (api.contains(MARK)) {
                api = CommunicatLogic.getYmlConfig(api);
            }
            if (api.contains(SLASH)) {
                api = CommunicatLogic.getValueFromContext(api);
            }
            Object responseDate = restTemplate.getForEntity(api, ClassUtil.strToClass((String)responseClassName), new Object[0]).getBody();
            if (logger.isDebugEnabled()) {
                logger.debug("API:{}", (Object)api);
                logger.debug("Response data: {}", responseDate);
            }
            return responseDate;
        }
        catch (Exception ex) {
            logger.error("[{}] request failed", (Object)api);
            throw Error.COMMUNICATE_MS_FAILED.expcetion(ex.getMessage());
        }
    }

    @Logic(description="wfwpjc", async=true)
    public static Object restCallPost(@LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="xylmc", assignType="CONSTANT") String responseClassName, @LogicParam(description="xxt") Object body) {
        return CommunicatLogic.restCallPost2(api, responseClassName, body);
    }

    private static Object restCallPost2(String api, String responseClassName, Object body) {
        try {
            if (body instanceof QueryModel) {
                body = CommunicatLogic.copyAndSetQueryModel((QueryModel)body);
            }
            Flow currentFlow = FlowUtil.getSAGACurrentFlow();
            RestTemplate restTemplate = null;
            restTemplate = currentFlow != null ? (RestTemplate)SpringContextHolder.getBean((String)"omegaRestTemplate") : (RestTemplate)SpringContextHolder.getBean((String)"feeresttemplate");
            if (api.startsWith("1")) {
                api = "http://" + api;
            }
            if (api.contains(MARK)) {
                api = CommunicatLogic.getYmlConfig(api);
            }
            if (api.contains(SLASH)) {
                api = CommunicatLogic.getValueFromContext(api);
            }
            Object responseDate = restTemplate.postForEntity(api, body, ClassUtil.strToClass((String)responseClassName), new Object[0]).getBody();
            if (logger.isDebugEnabled()) {
                logger.debug("Request API:{},data:{}", (Object)api, body);
                logger.debug("Response data: {}", responseDate);
            }
            return responseDate;
        }
        catch (Exception ex) {
            logger.error("[{}] request failed, {}", (Object)api, (Object)ex.getMessage());
            throw Error.COMMUNICATE_MS_FAILED.expcetion(ex.getMessage());
        }
    }

    private static String getYmlConfig(String api) {
        Environment environment = (Environment)SpringContextHolder.getBean(Environment.class);
        if (!Objects.isNull(environment)) {
            String serverName = api.substring(api.indexOf(MARK), api.indexOf("}") + 1);
            if (api.indexOf("}") == -1) {
                throw Error.URL_ANALYZE_EXCEPTION.expcetion();
            }
            String serverValue = environment.resolvePlaceholders(serverName);
            if (serverName.length() > 0) {
                return serverValue + api.substring(serverName.length());
            }
            return api;
        }
        throw Error.ENV_NOT_FOUND.expcetion();
    }

    private static String getValueFromContext(String api) {
        if (!api.contains(SLASH)) {
            return api;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(api.substring(0, api.indexOf(SLASH)));
        if (api.contains(SLASH)) {
            String[] split;
            String substring = api.substring(api.indexOf(SLASH));
            for (String s : split = substring.split("/")) {
                if (s.startsWith("{")) {
                    String key = s.substring(s.indexOf("{") + 1, s.length() - 1);
                    Object param = ContextUtil.getParam((String)key);
                    if (param != null) {
                        stringBuilder.append("/" + param);
                        continue;
                    }
                    stringBuilder.append("/" + s);
                    continue;
                }
                if (StringUtils.isEmpty((Object)s)) continue;
                stringBuilder.append("/" + s);
            }
        }
        return stringBuilder.toString();
    }

    private static QueryModelSupport copyAndSetQueryModel(QueryModel queryModel) {
        QueryModelSupport queryModelSupport = new QueryModelSupport();
        try {
            BeanUtils.copyProperties((Object)queryModelSupport, (Object)queryModel);
            String s = JSONObject.toJSONString((Object)queryModel.getCondition());
            queryModelSupport.setCondition(s);
        }
        catch (Exception e) {
            throw Error.BEAN_COPY_ERROR.expcetion();
        }
        return queryModelSupport;
    }
}

