/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.communicate;

import cn.com.yusys.yusp.bsp.workflow.IService;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.component.Param;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.core.component.ComponentFactory;
import cn.com.yusys.yusp.commons.fee.core.context.StandardContext;
import cn.com.yusys.yusp.commons.fee.core.init.FlowDefinitionRegistry;
import cn.com.yusys.yusp.commons.fee.core.init.definition.FlowDefinition;
import cn.com.yusys.yusp.commons.fee.core.intercepter.AllBspFlowInterceptor;
import cn.com.yusys.yusp.commons.fee.core.intercepter.FeeBspInterceptor;
import cn.com.yusys.yusp.commons.fee.core.intercepter.FeePostFlowInterceptor;
import cn.com.yusys.yusp.commons.fee.core.intercepter.FeePreFlowInterceptor;
import cn.com.yusys.yusp.commons.fee.core.process.ProcessCoord;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BSPService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(IService.class);

    /*
     * Loose catch block
     */
    public Map<String, Object> execute(String tradeCode, Map<String, Object> map) throws Exception {
        Map resultMap;
        Flow flow;
        LinkedBlockingQueue queue;
        Object result;
        FeeBspInterceptor feeBspInterceptor;
        block15: {
            Object input;
            logger.info("bsp execute value is ", map);
            FlowDefinitionRegistry flowDefinitionRegistry = (FlowDefinitionRegistry)SpringContextHolder.getBean(FlowDefinitionRegistry.class);
            String flowId = FlowUtil.getFlowUrlByBspTradeCode((String)tradeCode);
            if (StringUtils.isEmpty((Object)flowId)) {
                logger.warn("Interface not found: url = {}", (Object)tradeCode);
                throw Error.NOT_FOUND.expcetion();
            }
            feeBspInterceptor = null;
            result = null;
            queue = null;
            StandardContext rootContext = new StandardContext("rootContext");
            MdcParamUtil.initParam((String)"_flowId", (String)flowId);
            FlowDefinition flowDefinition = flowDefinitionRegistry.getFlow(flowId);
            feeBspInterceptor = (FeeBspInterceptor)SpringContextHolder.getBeanIfExist((String)flowDefinition.getBspIntercepter());
            queue = this.getInterceptorClassNameQueue(queue, flowDefinition.getSeveralBSPPreHandleClassName());
            this.handleRequest(feeBspInterceptor, map, queue);
            queue = this.getInterceptorClassNameQueue(queue, flowDefinition.getSeveralBSPPostHandleClassName());
            logger.info("Flow input: url={},flowId={},request={}", new Object[]{tradeCode, flowId, map});
            List inputList = flowDefinition.getInput();
            if (inputList != null && !inputList.isEmpty() && inputList.size() > 1) {
                logger.error("BSP can only have one input parameter, flowId={}", (Object)flowId);
                throw Error.BSP_FLOW_ERROR.expcetion();
            }
            flow = ((ComponentFactory)SpringContextHolder.getBean(ComponentFactory.class)).getFlow(flowId);
            if (CollectionUtils.isEmpty((Collection)flow.getInput())) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    rootContext.putParam(entry.getKey(), entry.getValue());
                }
            } else {
                input = flow.getInput();
                input.forEach(arg_0 -> BSPService.lambda$execute$0((Context)rootContext, map, arg_0));
            }
            ContextHolder.setContext((Context)rootContext);
            result = ((ProcessCoord)SpringContextHolder.getBean(ProcessCoord.class)).processExecute(flow);
            logger.info("Flow output: url={}, flowId={}, response={}", new Object[]{tradeCode, flowId, result});
            if (!(result instanceof Map)) break block15;
            input = (Map)result;
            this.handleResponse(feeBspInterceptor, result, queue);
            MdcParamUtil.cleanParam((String)"_flowId");
            ContextHolder.removeContext();
            return input;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String resultJson = objectMapper.writeValueAsString(result);
        Map map2 = resultMap = (Map)objectMapper.readValue(resultJson, Map.class);
        this.handleResponse(feeBspInterceptor, result, queue);
        MdcParamUtil.cleanParam((String)"_flowId");
        ContextHolder.removeContext();
        return map2;
        {
            catch (Exception e) {
                Map<String, Object> map3;
                block16: {
                    if (ObjectUtils.isEmpty((Object)flow.getOutput())) break block16;
                    if (!(result instanceof Map)) {
                        throw Error.BSP_RESULT_NOT_MAP.expcetion();
                    }
                    Map map4 = (Map)result;
                    this.handleResponse(feeBspInterceptor, result, queue);
                    MdcParamUtil.cleanParam((String)"_flowId");
                    ContextHolder.removeContext();
                    return map4;
                }
                try {
                    map3 = map;
                }
                catch (Exception e2) {
                    try {
                        logger.error("", (Throwable)e2);
                        throw e2;
                    }
                    catch (Throwable throwable) {
                        this.handleResponse(feeBspInterceptor, result, queue);
                        MdcParamUtil.cleanParam((String)"_flowId");
                        ContextHolder.removeContext();
                        throw throwable;
                    }
                }
                this.handleResponse(feeBspInterceptor, result, queue);
                MdcParamUtil.cleanParam((String)"_flowId");
                ContextHolder.removeContext();
                return map3;
            }
        }
    }

    private void handleRequest(FeeBspInterceptor feeBspInterceptor, Object input, Queue<String> classQueue) throws Exception {
        AllBspFlowInterceptor allBspFlowInterceptor = (AllBspFlowInterceptor)SpringContextHolder.getBeanIfExist(AllBspFlowInterceptor.class);
        if (allBspFlowInterceptor != null) {
            allBspFlowInterceptor.requestHandle(input);
        }
        if (feeBspInterceptor != null) {
            feeBspInterceptor.requestHandle(input);
        }
        if (!CollectionUtils.isEmpty(classQueue)) {
            while (classQueue.peek() != null) {
                FeePreFlowInterceptor preFlowInterceptor = (FeePreFlowInterceptor)ClassUtil.newInstance((String)classQueue.poll());
                preFlowInterceptor.preHandle(input);
            }
        }
    }

    private LinkedBlockingQueue getInterceptorClassNameQueue(LinkedBlockingQueue queue, String severalPostHandleClassName) {
        if (!StringUtils.isEmpty((Object)severalPostHandleClassName)) {
            String[] postHandleClassNames = severalPostHandleClassName.split(";");
            queue = new LinkedBlockingQueue<String>();
            for (String className : postHandleClassNames) {
                queue.add(className);
            }
        }
        return queue;
    }

    private void handleResponse(FeeBspInterceptor feeBspInterceptor, Object result, Queue<String> classQueue) throws Exception {
        AllBspFlowInterceptor allBspFlowInterceptor = (AllBspFlowInterceptor)SpringContextHolder.getBeanIfExist(AllBspFlowInterceptor.class);
        if (allBspFlowInterceptor != null) {
            allBspFlowInterceptor.responseHandle(result);
        }
        if (feeBspInterceptor != null) {
            feeBspInterceptor.responseHandle(result);
        }
        if (!CollectionUtils.isEmpty(classQueue)) {
            while (classQueue.peek() != null) {
                FeePostFlowInterceptor postFlowInterceptor = (FeePostFlowInterceptor)ClassUtil.newInstance((String)classQueue.poll());
                postFlowInterceptor.postHandle(result);
            }
        }
    }

    private static /* synthetic */ void lambda$execute$0(Context rootContext, Map map, Param param) {
        rootContext.putParam(param.getName(), (Object)map);
    }
}

