/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.web.rest.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public final class HeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(HeaderUtil.class);
    private static final String APPLICATION_NAME = "sampleMicroserviceApp";

    private HeaderUtil() {
    }

    public static HttpHeaders createAlert(String message, String param) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-sampleMicroserviceApp-alert", message);
        headers.add("X-sampleMicroserviceApp-params", param);
        return headers;
    }

    public static HttpHeaders createEntityCreationAlert(String entityName, String param) {
        return HeaderUtil.createAlert("sampleMicroserviceApp." + entityName + ".created", param);
    }

    public static HttpHeaders createEntityUpdateAlert(String entityName, String param) {
        return HeaderUtil.createAlert("sampleMicroserviceApp." + entityName + ".updated", param);
    }

    public static HttpHeaders createEntityDeletionAlert(String entityName, String param) {
        return HeaderUtil.createAlert("sampleMicroserviceApp." + entityName + ".deleted", param);
    }

    public static HttpHeaders createFailureAlert(String entityName, String errorKey, String defaultMessage) {
        log.error("Entity creation failed, {}", (Object)defaultMessage);
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-sampleMicroserviceApp-error", "error." + errorKey);
        headers.add("X-sampleMicroserviceApp-params", entityName);
        return headers;
    }
}

