/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.echain.client.dto.core.AssistDTO;
import cn.com.yusys.yusp.echain.client.dto.core.AsynSubFlowSetSubmitDTO;
import cn.com.yusys.yusp.echain.client.dto.core.CallBackDTO;
import cn.com.yusys.yusp.echain.client.dto.core.ChangeDTO;
import cn.com.yusys.yusp.echain.client.dto.core.CompleteJobDTO;
import cn.com.yusys.yusp.echain.client.dto.core.EchainCommentDTO;
import cn.com.yusys.yusp.echain.client.dto.core.EchainInstanceDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetAllCommentsDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetChangeUserDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetInstanceInfoDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetNextNodeListDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetNodeListDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetNodePropertyDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetNodeUserListDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetPropertyDTO;
import cn.com.yusys.yusp.echain.client.dto.core.GetTreatedNodeListDTO;
import cn.com.yusys.yusp.echain.client.dto.core.HangWakeDTO;
import cn.com.yusys.yusp.echain.client.dto.core.InitializeDTO;
import cn.com.yusys.yusp.echain.client.dto.core.JumpDTO;
import cn.com.yusys.yusp.echain.client.dto.core.ReturnBackDTO;
import cn.com.yusys.yusp.echain.client.dto.core.SaveCommentDTO;
import cn.com.yusys.yusp.echain.client.dto.core.SaveJobDTO;
import cn.com.yusys.yusp.echain.client.dto.core.SignInOffDTO;
import cn.com.yusys.yusp.echain.client.dto.core.SynSubFlowSetSubmitDTO;
import cn.com.yusys.yusp.echain.client.dto.core.TakeBackDTO;
import cn.com.yusys.yusp.echain.client.dto.core.TaskSignInOffDTO;
import cn.com.yusys.yusp.echain.client.dto.core.UrgeDTO;
import cn.com.yusys.yusp.echain.client.dto.core.WorkFlowHistoryDTO;
import cn.com.yusys.yusp.echain.server.domain.WfHumanstates;
import cn.com.yusys.yusp.echain.server.domain.WfiSignTask;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinInstanceDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinNodeInfoDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinSignVoteDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinSubmitResultDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinUserInfoDTO;
import cn.com.yusys.yusp.echain.server.service.EchainCoreService;
import cn.com.yusys.yusp.echain.server.service.EchainJoinCoreService;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfAssistDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfCallBackDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfChangeDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfCheckAgentDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfCheckAsynSubDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfCompleteDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfFreeDateDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetCallBackNodesDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetInstanceHistoryDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetInstanceInfoDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetJumpNodesDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetNextNodesDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetNodeUsersDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetNodesDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetSignTaskInfoDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfGetSignVoteInfoDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfHangWakeDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfInitDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfJumpDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfReturnBackDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfSaveDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfSignInOffDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfSignTaskDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfSubSubmitDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfSubmitSignVote;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfTakeBackDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfTaskSignInOffDTO;
import cn.com.yusys.yusp.echain.server.web.rest.dto.joincore.WfUrgeDTO;
import com.ecc.echain.util.UNIDProducer;
import com.ecc.echain.workflow.cache.WFClientInstuCache;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/joincore"})
public class EchainJoinCoreResource {
    @Autowired
    private EchainCoreService coreService;
    @Autowired
    private EchainJoinCoreService joinCoreService;

    @PostMapping(value={"/wfInit"})
    public ResultDto<EchainJoinSubmitResultDTO> wfInit(@Valid @RequestBody WfInitDTO dto) {
        String wfSign = this.joinCoreService.queryWfSignByBiz(dto.getApplType(), dto.getSessionOrgCode(), dto.getSessionInstuCde());
        if (wfSign == null) {
            ResultDto resultDTO = new ResultDto();
            resultDTO.setCode(1);
            resultDTO.setMessage("\u5f53\u524d\u7533\u8bf7\u7c7b\u578b[" + dto.getApplType() + "]\u548c\u673a\u6784[" + dto.getSessionOrgCode() + "]\u5bf9\u5e94\u7684\u6d41\u7a0b\u5173\u8054\u627e\u4e0d\u5230");
            return resultDTO;
        }
        String jobName = dto.getJobName();
        if (dto.getJobName() == null) {
            jobName = this.coreService.wfGetPropertyByWfSign(new GetPropertyDTO(dto.getSessionInstuCde(), wfSign, null, "wfname"));
        }
        InitializeDTO initializeDTO = new InitializeDTO(dto.getSessionInstuCde(), null, wfSign, dto.getApplType(), dto.getSessionLoginCode(), dto.getBizSeqNo(), jobName, dto.getSessionOrgCode(), dto.getCustId(), dto.getCustName(), dto.getParamMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfInitialize(initializeDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfSave"})
    public ResultDto<EchainJoinSubmitResultDTO> wfSave(@Valid @RequestBody WfSaveDTO dto) {
        String commentId = dto.getCommentId();
        if (commentId == null || commentId.equals("")) {
            UNIDProducer unidProducer = new UNIDProducer();
            commentId = unidProducer.getUNID();
        }
        SaveCommentDTO saveCommentDTO = new SaveCommentDTO(dto.getSessionInstuCde(), commentId, dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getCommentSign(), dto.getCommentContent(), dto.getSessionOrgCode());
        this.coreService.wfSaveComment(saveCommentDTO);
        SaveJobDTO saveJobDTO = new SaveJobDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getSessionOrgCode(), dto.getParamMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfSaveJob(saveJobDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfComplete"})
    public ResultDto<EchainJoinSubmitResultDTO> wfComplete(@Valid @RequestBody WfCompleteDTO dto) {
        String nextNodeUser = dto.getNextNodeUser();
        if ("wfiSysNodeUser".equals(nextNodeUser)) {
            nextNodeUser = null;
        } else {
            String[] nodesUsers;
            String nextNodeUserTmp = "";
            for (String nodeUsers : nodesUsers = nextNodeUser.split("@")) {
                String[] users;
                if (nodeUsers == null || "".equals(nodeUsers)) continue;
                for (String user : users = nodeUsers.split(";")) {
                    if (user == null || "".equals(user)) continue;
                    if (!(user.startsWith("T.") || user.startsWith("U.") || user.startsWith("G.") || user.startsWith("R.") || user.startsWith("D.") || user.startsWith("O.") || user.startsWith("A.") || user.startsWith("X."))) {
                        user = "U." + user;
                    }
                    nextNodeUserTmp = nextNodeUserTmp + user + ";";
                }
                nextNodeUserTmp = nextNodeUserTmp + "@";
            }
            if (nextNodeUserTmp.length() > 0) {
                nextNodeUser = nextNodeUserTmp.substring(0, nextNodeUserTmp.length() - 1);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ("1".equals(dto.getExv10())) {
            map.put("flag", "1");
        } else {
            map.put("flag", "0");
        }
        map.put("commentSign", dto.getCommentSign());
        CompleteJobDTO completeJob = new CompleteJobDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getSessionOrgCode(), dto.getNextNodeId(), nextNodeUser, dto.getAnnouceUser(), dto.getEntrustModel(), map);
        EchainInstanceDTO instanceInfo = this.coreService.wfCompleteJob(completeJob);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        String signConfig = "0";
        if (dto.getNextNodeId().indexOf("@") == -1 && dto.getNextNodeId().indexOf("e") == -1 && !"WFEND".equals(dto.getNextNodeId())) {
            signConfig = this.coreService.wfGetNodeExtProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNextNodeId(), "signConfig"));
        }
        if (signConfig != null && !"0".equals(signConfig)) {
            String scene = this.coreService.wfGetNodeExtProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNextNodeId(), "scene"));
            String nodeUsersList = this.coreService.wfGetNodeProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNextNodeId(), "NodeUsersList"));
            String nodeName = this.coreService.wfGetNodeProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNextNodeId(), "nodename"));
            WfiSignTask wfiSignTask = this.buildSignTask(dto.getInstanceId(), dto.getBizSeqNo(), dto.getNextNodeId(), dto.getApplType(), dto.getSessionLoginCode(), dto.getSessionOrgCode(), dto.getWfSign(), scene, signConfig);
            this.joinCoreService.initSignTask(wfiSignTask, nodeName, nodeUsersList);
        }
        return new ResultDto((Object)submitResult);
    }

    protected WfiSignTask buildSignTask(String instanceId, String serNo, String nodeId, String applType, String loginCode, String orgCode, String wfSign, String scene, String signConfig) {
        WfiSignTask task = new WfiSignTask();
        task.setWfiInstanceId(instanceId);
        task.setSerno(serNo);
        task.setWfiNodeId(nodeId);
        task.setBizType(applType);
        task.setStExeUser(loginCode);
        task.setStExeOrg(orgCode);
        task.setWfiSign(wfSign);
        task.setWfiSceneId(scene);
        task.setStConfig(signConfig);
        return task;
    }

    @PostMapping(value={"/wfRetrunBack"})
    public ResultDto<EchainJoinSubmitResultDTO> wfRetrunBack(@Valid @RequestBody WfReturnBackDTO dto) {
        String commentSign = dto.getCommentSign();
        HashMap<String, String> param = new HashMap<String, String>();
        if (null != commentSign) {
            param.put("commentSign", commentSign);
        }
        ReturnBackDTO returnBackDTO = new ReturnBackDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getIsDraft(), param);
        EchainInstanceDTO instanceInfo = this.coreService.wfReturnBack(returnBackDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfCallBack"})
    public ResultDto<EchainJoinSubmitResultDTO> wfCallBack(@Valid @RequestBody WfCallBackDTO dto) {
        String commentSign = dto.getCommentSign();
        HashMap<String, String> param = new HashMap<String, String>();
        if (null != commentSign) {
            param.put("commentSign", commentSign);
        }
        CallBackDTO callBackDTO = new CallBackDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getNextNodeId(), dto.getNextNodeUser(), dto.getCallBackModel(), param);
        EchainInstanceDTO instanceInfo = this.coreService.wfCallBack(callBackDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfAssist"})
    public ResultDto<EchainJoinSubmitResultDTO> wfAssist(@Valid @RequestBody WfAssistDTO dto) {
        AssistDTO assistDTO = new AssistDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getNextNodeUser());
        EchainInstanceDTO instanceInfo = this.coreService.wfAssist(assistDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfChange"})
    public ResultDto<EchainJoinSubmitResultDTO> wfChange(@Valid @RequestBody WfChangeDTO dto) {
        ChangeDTO changeDTO = new ChangeDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getNextNodeUser(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfChange(changeDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfJump"})
    public ResultDto<EchainJoinSubmitResultDTO> wfJump(@Valid @RequestBody WfJumpDTO dto) {
        JumpDTO jumpDTO = new JumpDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getNextNodeId(), "U." + dto.getNextNodeUser(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfJump(jumpDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfHang"})
    public ResultDto<EchainJoinSubmitResultDTO> wfHang(@Valid @RequestBody WfHangWakeDTO dto) {
        HangWakeDTO hangDTO = new HangWakeDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfHang(hangDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfWake"})
    public ResultDto<EchainJoinSubmitResultDTO> wfWake(@Valid @RequestBody WfHangWakeDTO dto) {
        HangWakeDTO hangDTO = new HangWakeDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfWake(hangDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfSignIn"})
    public ResultDto<EchainJoinSubmitResultDTO> wfSignIn(@Valid @RequestBody WfSignInOffDTO dto) {
        SignInOffDTO hangDTO = new SignInOffDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfSignIn(hangDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfSignOff"})
    public ResultDto<EchainJoinSubmitResultDTO> wfSignOff(@Valid @RequestBody WfSignInOffDTO dto) {
        SignInOffDTO hangDTO = new SignInOffDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfSignOff(hangDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"wfTakeBack"})
    public ResultDto<EchainJoinSubmitResultDTO> wfTackBack(@Valid @RequestBody WfTakeBackDTO dto) {
        TakeBackDTO takeBackDTO = new TakeBackDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfTakeBack(takeBackDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfUrge"})
    public ResultDto<EchainJoinSubmitResultDTO> wfUrge(@Valid @RequestBody WfUrgeDTO dto) {
        UrgeDTO urgeDTO = new UrgeDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfUrge(urgeDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfTaskSignIn"})
    public ResultDto<EchainJoinSubmitResultDTO> wfTaskSignIn(@Valid @RequestBody WfTaskSignInOffDTO dto) {
        TaskSignInOffDTO taskSignInOffDTO = new TaskSignInOffDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), dto.getNodeId());
        EchainInstanceDTO instanceInfo = this.coreService.wfTaskSignIn(taskSignInOffDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfTaskSignOff"})
    public ResultDto<EchainJoinSubmitResultDTO> wfTaskSignOff(@Valid @RequestBody WfTaskSignInOffDTO dto) {
        TaskSignInOffDTO taskSignInOffDTO = new TaskSignInOffDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), dto.getNodeId());
        EchainInstanceDTO instanceInfo = this.coreService.wfTaskSignOff(taskSignInOffDTO);
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfSubSubmit"})
    public ResultDto<EchainJoinSubmitResultDTO> wfSubSubmit(@Valid @RequestBody WfSubSubmitDTO dto) {
        EchainInstanceDTO instanceInfo = null;
        String subWfId = this.coreService.wfGetPropertyByWfSign(new GetPropertyDTO(dto.getSessionInstuCde(), dto.getSubWfSign(), null, "wfid"));
        String nextNodeId = this.coreService.wfGetPropertyByWfSign(new GetPropertyDTO(dto.getSessionInstuCde(), dto.getSubWfSign(), null, "WFFirstNodeDocID"));
        if ("1".equals(dto.getSubWfType())) {
            SynSubFlowSetSubmitDTO synSubFlowSetSubmitDTO = new SynSubFlowSetSubmitDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), nextNodeId, subWfId, dto.getSessionLoginCode(), dto.getSessionLoginCode(), dto.getSessionOrgCode());
            instanceInfo = this.coreService.wfSynSubFlowSetSubmit(synSubFlowSetSubmitDTO);
        } else {
            AsynSubFlowSetSubmitDTO asynSubFlowSetSubmitDTO = new AsynSubFlowSetSubmitDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getNodeId(), subWfId, dto.getSessionLoginCode(), dto.getSessionLoginCode(), dto.getSessionOrgCode(), dto.getApplType(), dto.getInstanceId());
            instanceInfo = this.coreService.wfAsynSubFlowSetSubmit(asynSubFlowSetSubmitDTO);
        }
        EchainJoinSubmitResultDTO submitResult = this.joinCoreService.buildSubmitResult(instanceInfo);
        if (0 == submitResult.getSign()) {
            if ("1".equals(dto.getSubWfType())) {
                submitResult.setInstanceId(dto.getInstanceId());
                submitResult.setNodeId(nextNodeId);
            } else {
                submitResult.setNodeId(nextNodeId);
            }
        }
        return new ResultDto((Object)submitResult);
    }

    @PostMapping(value={"/wfGetInstanceInfo"})
    public ResultDto<EchainJoinInstanceDTO> wfGetInstanceInfo(@Valid @RequestBody WfGetInstanceInfoDTO dto) {
        GetInstanceInfoDTO getInstanceInfoDTO = new GetInstanceInfoDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode());
        EchainInstanceDTO instanceInfo = this.coreService.wfGetInstanceInfo(getInstanceInfoDTO);
        EchainJoinInstanceDTO getResult = this.joinCoreService.buildInstanceResult(instanceInfo);
        GetAllCommentsDTO getAllCommentsDTO = new GetAllCommentsDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), true);
        List<EchainCommentDTO> comments = this.coreService.wfGetAllComments(getAllCommentsDTO);
        if (comments.size() > 0) {
            EchainCommentDTO echainCommentDTO = comments.get(0);
            HashMap<String, String> commentMap = new HashMap<String, String>();
            commentMap.put("commentId", echainCommentDTO.getCommentId());
            commentMap.put("commentSign", echainCommentDTO.getCommentSign());
            commentMap.put("commentContent", echainCommentDTO.getCommentContent());
            getResult.setComment(commentMap);
        }
        GetNodePropertyDTO getNodePropertyDTO = new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNodeId(), "noderoutertype");
        String nodeRouterType = this.coreService.wfGetNodeProperty(getNodePropertyDTO);
        getResult.setNodeRouterType(nodeRouterType);
        getNodePropertyDTO = new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNodeId(), "subwfid");
        String subWfSign = this.coreService.wfGetNodeProperty(getNodePropertyDTO);
        getResult.setSubWfSign(subWfSign);
        getNodePropertyDTO = new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNodeId(), "nodeusesubwf");
        String subWfType = this.coreService.wfGetNodeProperty(getNodePropertyDTO);
        getResult.setSubWfType(subWfType);
        String applType = getResult.getAppId();
        String wfSign = getResult.getWfSign();
        String funcId = this.joinCoreService.queryFuncIdByBiz(applType, wfSign, dto.getNodeId());
        getResult.setFuncId(funcId);
        return new ResultDto((Object)getResult);
    }

    @PostMapping(value={"/wfGetNextNodes"})
    public ResultDto<List<EchainJoinNodeInfoDTO>> wfGetNextNodes(@Valid @RequestBody WfGetNextNodesDTO dto) {
        GetNextNodeListDTO getNextNodeListDTO = new GetNextNodeListDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfGetNextNodeList(getNextNodeListDTO);
        ArrayList<EchainJoinNodeInfoDTO> rtDtoList = new ArrayList<EchainJoinNodeInfoDTO>();
        HashMap paramMap = instanceInfo.getParamMap();
        if (paramMap != null && !paramMap.isEmpty()) {
            Set keySet = paramMap.keySet();
            for (Object key : keySet) {
                String nodeId = key.toString();
                Map nodeInfoMap = (Map)paramMap.get(key);
                String nodeName = (String)nodeInfoMap.get("nodename");
                String nodeType = (String)nodeInfoMap.get("nodetype");
                EchainJoinNodeInfoDTO rtDto = new EchainJoinNodeInfoDTO();
                rtDto.setNodeId(nodeId);
                rtDto.setNodeName(nodeName);
                rtDto.setNodeType(nodeType);
                rtDtoList.add(rtDto);
            }
        }
        return new ResultDto(rtDtoList);
    }

    @PostMapping(value={"/wfGetNodes"})
    public ResultDto<List<EchainJoinNodeInfoDTO>> wfGetNodes(@Valid @RequestBody WfGetNodesDTO dto) {
        String wfId = this.coreService.wfGetPropertyByWfSign(new GetPropertyDTO(dto.getSessionInstuCde(), dto.getWfSign(), null, "wfid"));
        GetNodeListDTO getNodeListDTO = new GetNodeListDTO(dto.getSessionInstuCde(), wfId, null);
        ArrayList<EchainJoinNodeInfoDTO> rtDtoList = new ArrayList<EchainJoinNodeInfoDTO>();
        Map paramMap = this.coreService.wfGetNodeList(getNodeListDTO);
        if (paramMap != null && !paramMap.isEmpty()) {
            Set keySet = paramMap.keySet();
            for (Object key : keySet) {
                String nodeId = key.toString();
                Map nodeInfoMap = (Map)paramMap.get(key);
                String nodeName = (String)nodeInfoMap.get("nodename");
                String nodeType = (String)nodeInfoMap.get("nodetype");
                EchainJoinNodeInfoDTO rtDto = new EchainJoinNodeInfoDTO();
                rtDto.setNodeId(nodeId);
                rtDto.setNodeName(nodeName);
                rtDto.setNodeType(nodeType);
                rtDtoList.add(rtDto);
            }
        }
        return new ResultDto(rtDtoList);
    }

    @PostMapping(value={"/wfGetNodeUsers"})
    public ResultDto<List<EchainJoinUserInfoDTO>> wfGetNodeUsers(@Valid @RequestBody WfGetNodeUsersDTO dto) {
        ArrayList<EchainJoinUserInfoDTO> users = new ArrayList<EchainJoinUserInfoDTO>();
        String signConfig = this.coreService.wfGetNodeExtProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNodeId(), "signConfig"));
        if (!"0".equals(signConfig)) {
            EchainJoinUserInfoDTO user = new EchainJoinUserInfoDTO();
            user.setLoginCode("signUser");
            user.setUserName("\u4f1a\u7b7e\u6210\u5458");
            users.add(user);
            return new ResultDto(users);
        }
        String nodeUsersAssign = this.coreService.wfGetNodeProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNodeId(), "NodeUsersAssign"));
        String nodeUsersCompute = this.coreService.wfGetNodeProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), dto.getNodeId(), "NodeUsersCompute"));
        if ("2".equals(nodeUsersAssign) || "3".equals(nodeUsersCompute)) {
            EchainJoinUserInfoDTO user = new EchainJoinUserInfoDTO();
            user.setLoginCode("wfiSysNodeUser");
            user.setUserName("\u7cfb\u7edf\u6307\u5b9a");
            users.add(user);
            return new ResultDto(users);
        }
        GetNodeUserListDTO getNodeUserListDTO = new GetNodeUserListDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getNodeId(), dto.getSessionOrgCode(), new HashMap());
        EchainInstanceDTO instanceInfo = this.coreService.wfGetNodeUserList(getNodeUserListDTO);
        String multeitFlag = instanceInfo.getMulteitFlag();
        if (instanceInfo.isExb()) {
            EchainJoinUserInfoDTO user = new EchainJoinUserInfoDTO();
            user.setLoginCode("${alluser}");
            user.setUserName("\u6240\u6709\u7528\u6237");
            user.setIsMulteit(multeitFlag == null || "1".equals(multeitFlag) ? "0" : "1");
            users.add(user);
            ResultDto resultDto = new ResultDto(users);
            resultDto.setCode(1);
            return resultDto;
        }
        HashMap paramMap = instanceInfo.getParamMap();
        Set keys = paramMap.keySet();
        for (Object key : keys) {
            EchainJoinUserInfoDTO user = new EchainJoinUserInfoDTO();
            String wfUserId = key.toString();
            if (wfUserId.startsWith("T.")) {
                user.setLoginCode(wfUserId);
                user.setUserName("\u4efb\u52a1\u6c60");
            } else if (wfUserId.startsWith("U.")) {
                String loginCode = wfUserId.substring(2);
                String userName = paramMap.get(key) == null ? "" : paramMap.get(key).toString();
                user.setLoginCode(loginCode);
                user.setUserName(userName);
                user.setIsMulteit(multeitFlag == null || "1".equals(multeitFlag) ? "0" : "1");
            }
            if (user.getLoginCode() == null) continue;
            users.add(user);
        }
        ResultDto re = new ResultDto();
        re.setData(this.getPagedList(dto.getPage(), dto.getSize(), users));
        re.setTotal((long)users.size());
        return re;
    }

    private List<EchainJoinUserInfoDTO> getPagedList(int page, int size, List<EchainJoinUserInfoDTO> users) {
        int toIndex;
        int fromIndex;
        if (page == 0) {
            page = 1;
        }
        if ((fromIndex = (page - 1) * size) >= users.size()) {
            return Collections.emptyList();
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((toIndex = page * size) >= users.size()) {
            toIndex = users.size();
        }
        return users.subList(fromIndex, toIndex);
    }

    @PostMapping(value={"/wfGetChangeUsers"})
    public ResultDto<List<EchainJoinUserInfoDTO>> wfGetChangeUsers(@Valid @RequestBody WfGetNodeUsersDTO dto) {
        ArrayList<EchainJoinUserInfoDTO> users = new ArrayList<EchainJoinUserInfoDTO>();
        GetChangeUserDTO getChangeUserDTO = new GetChangeUserDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode());
        EchainInstanceDTO instanceInfo = this.coreService.wfGetChangeUser(getChangeUserDTO);
        if (instanceInfo.isExb()) {
            EchainJoinUserInfoDTO user = new EchainJoinUserInfoDTO();
            user.setLoginCode("${alluser}");
            user.setUserName("\u6240\u6709\u7528\u6237");
            users.add(user);
            ResultDto resultDto = new ResultDto(users);
            resultDto.setCode(1);
            return resultDto;
        }
        HashMap paramMap = instanceInfo.getParamMap();
        Set keys = paramMap.keySet();
        for (Object key : keys) {
            EchainJoinUserInfoDTO user = new EchainJoinUserInfoDTO();
            String wfUserId = key.toString();
            if (wfUserId.startsWith("U.")) {
                String loginCode = wfUserId.substring(2);
                String userName = paramMap.get(key) == null ? "" : paramMap.get(key).toString();
                user.setLoginCode(loginCode);
                user.setUserName(userName);
            }
            if (user.getLoginCode() == null) continue;
            users.add(user);
        }
        return new ResultDto(users);
    }

    @PostMapping(value={"/wfGetCallBackNodes"})
    public ResultDto<List<EchainJoinNodeInfoDTO>> wfGetCallBackNodes(@Valid @RequestBody WfGetCallBackNodesDTO dto) {
        ArrayList<EchainJoinNodeInfoDTO> treatedNodes = new ArrayList<EchainJoinNodeInfoDTO>();
        List<EchainCommentDTO> allComments = this.coreService.wfGetAllComments(new GetAllCommentsDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), false));
        HashMap<String, String> commentsMap = new HashMap<String, String>();
        for (EchainCommentDTO c : allComments) {
            String commentSign = c.getCommentSign();
            if (commentSign != null && (commentSign.equals("60") || commentSign.equals("61") || commentSign.equals("80") || commentSign.equals("90") || commentSign.equals("31"))) continue;
            String nodeId = c.getNodeId();
            String userId = c.getUserId();
            if (commentsMap.containsKey(nodeId)) {
                String userIdHas = (String)commentsMap.get(nodeId);
                userIdHas = userIdHas + ";" + userId;
                commentsMap.put(nodeId, userIdHas);
                continue;
            }
            commentsMap.put(nodeId, userId);
        }
        List<Map> treatedNodeList = this.coreService.wfGetTreatedNodeList(new GetTreatedNodeListDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getNodeId(), dto.getSessionLoginCode(), dto.getSessionOrgCode()));
        String currentNodeId = dto.getNodeId();
        String wfId = currentNodeId.split("_")[0];
        String firstNodeId = this.coreService.wfGetPropertyByWfId(new GetPropertyDTO(dto.getSessionInstuCde(), null, wfId, "WFFirstNodeDocID"));
        if (!treatedNodeList.isEmpty()) {
            for (Map treatedNode : treatedNodeList) {
                String signConfig;
                String wfIdTmp;
                String nodeType;
                EchainJoinNodeInfoDTO nodeInfo = new EchainJoinNodeInfoDTO();
                Map treatedNodeMap = treatedNode;
                String nodeIdTmp = (String)treatedNodeMap.get("nodeid");
                if (!commentsMap.containsKey(nodeIdTmp) && !nodeIdTmp.equals(firstNodeId) || !"A".equals(nodeType = this.coreService.wfGetNodeProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), nodeIdTmp, "NodeType"))) || !wfId.equals(wfIdTmp = nodeIdTmp.split("_")[0]) || nodeIdTmp.equals(currentNodeId) || !"0".equals(signConfig = this.coreService.wfGetNodeExtProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), nodeIdTmp, "signConfig")))) continue;
                String nodeNameTmp = (String)treatedNodeMap.get("nodename");
                nodeInfo.setNodeId(nodeIdTmp);
                nodeInfo.setNodeName(nodeNameTmp);
                String userIdsTmp = (String)treatedNodeMap.get("userid");
                String userNamesTmp = (String)treatedNodeMap.get("username");
                String[] userIdArr = userIdsTmp.split(";");
                String[] userNameArr = userNamesTmp.split(";");
                ArrayList<EchainJoinUserInfoDTO> wfiUsers = new ArrayList<EchainJoinUserInfoDTO>();
                String userIdComment = (String)commentsMap.get(nodeIdTmp);
                for (int i = 0; i < userIdArr.length; ++i) {
                    String userIdTmp = userIdArr[i];
                    if (!userIdComment.contains(userIdTmp)) continue;
                    String userNameTmp = userNameArr[i];
                    EchainJoinUserInfoDTO wfiUser = new EchainJoinUserInfoDTO();
                    wfiUser.setLoginCode(userIdTmp);
                    wfiUser.setUserName(userNameTmp);
                    wfiUsers.add(wfiUser);
                }
                nodeInfo.setUserInfos(wfiUsers);
                String nodeTransactType = this.coreService.wfGetNodeProperty(new GetNodePropertyDTO(dto.getSessionInstuCde(), nodeIdTmp, "NodeTransactType"));
                nodeInfo.setNodeType(nodeType);
                nodeInfo.setNodeTransactType(nodeTransactType);
                treatedNodes.add(nodeInfo);
            }
        }
        return new ResultDto(treatedNodes);
    }

    @PostMapping(value={"/wfGetJumpNodes"})
    public ResultDto<List<EchainJoinNodeInfoDTO>> wfGetJumpNodes(@Valid @RequestBody WfGetJumpNodesDTO dto) {
        String wfId = this.coreService.wfGetPropertyByWfSign(new GetPropertyDTO(dto.getSessionInstuCde(), dto.getWfSign(), null, "wfid"));
        GetNodeListDTO getNodeListDTO = new GetNodeListDTO(dto.getSessionInstuCde(), wfId, null);
        ArrayList<EchainJoinNodeInfoDTO> rtDtoList = new ArrayList<EchainJoinNodeInfoDTO>();
        Map paramMap = this.coreService.wfGetNodeList(getNodeListDTO);
        if (paramMap != null && !paramMap.isEmpty()) {
            Set keySet = paramMap.keySet();
            for (Object key : keySet) {
                String nodeId = key.toString();
                String nodeName = paramMap.get(key).toString();
                EchainJoinNodeInfoDTO rtDto = new EchainJoinNodeInfoDTO();
                rtDto.setNodeId(nodeId);
                rtDto.setNodeName(nodeName);
                rtDtoList.add(rtDto);
            }
        }
        return new ResultDto(rtDtoList);
    }

    @PostMapping(value={"/wfGetInstanceHistory"})
    public ResultDto<List<EchainInstanceDTO>> wfGetInstanceHistory(@Valid @RequestBody WfGetInstanceHistoryDTO dto) {
        List<EchainInstanceDTO> history = this.coreService.wfGetWorkFlowHistory(new WorkFlowHistoryDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode()));
        GetAllCommentsDTO getAllCommentsDTO = new GetAllCommentsDTO(dto.getSessionInstuCde(), dto.getInstanceId(), dto.getSessionLoginCode(), false);
        List<EchainCommentDTO> comments = this.coreService.wfGetAllComments(getAllCommentsDTO);
        block0: for (EchainInstanceDTO hisDto : history) {
            String nodeId = hisDto.getNodeId();
            if (null == nodeId || "".equals(nodeId)) continue;
            for (EchainCommentDTO commentDto : comments) {
                if (!nodeId.equals(commentDto.getNodeId())) continue;
                hisDto.setFieldContent(commentDto.getCommentContent());
                continue block0;
            }
        }
        return new ResultDto(history);
    }

    @GetMapping(value={"/wfGetJumpUsers"})
    public ResultDto<List<EchainJoinUserInfoDTO>> wfGetJumpUsers(QueryModel query) {
        List<EchainJoinUserInfoDTO> list = this.joinCoreService.getJumpUsersByModel(query);
        return new ResultDto(list);
    }

    @GetMapping(value={"/wfGetAssistUsers"})
    public ResultDto<List<EchainJoinUserInfoDTO>> wfGetAssistUsers(QueryModel query) {
        List<EchainJoinUserInfoDTO> list = this.joinCoreService.getAssistUsersByModel(query);
        return new ResultDto(list);
    }

    @PostMapping(value={"/wfCheckAgent"})
    public ResultDto<String> wfCheckAgent(@Valid @RequestBody WfCheckAgentDTO dto) {
        String[] users;
        String isAgent = "0";
        String sysId = WFClientInstuCache.getInstance().getClientSign(dto.getSessionInstuCde());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentTime = sdf.format(new Date());
        for (String user : users = dto.getUsers().split(";")) {
            List<WfHumanstates> agents = this.joinCoreService.getAgentOfValidity(sysId, user, currentTime, dto.getApplType());
            if (agents.size() <= 0) continue;
            isAgent = "1";
            break;
        }
        return new ResultDto((Object)isAgent);
    }

    @PostMapping(value={"/wfGetSignTaskInfo"})
    public ResultDto<WfiSignTask> wfGetSignTaskInfo(@Valid @RequestBody WfGetSignTaskInfoDTO dto) {
        WfiSignTask info = this.joinCoreService.selectSignTaskInfo(dto.getStTaskId());
        return new ResultDto((Object)info);
    }

    @GetMapping(value={"/wfGetSignTaskUsers"})
    public ResultDto<List<EchainJoinUserInfoDTO>> wfGetSignTaskUsers(QueryModel query) {
        List<EchainJoinUserInfoDTO> users = this.joinCoreService.selectSignTaskUsersByModel(query);
        return new ResultDto(users);
    }

    @PostMapping(value={"/wfSaveSignTask"})
    public ResultDto<Integer> wfSaveSignTask(@Valid @RequestBody WfiSignTask task) {
        int saveCount = this.joinCoreService.saveSignTaskInfo(task);
        return new ResultDto((Object)saveCount);
    }

    @PostMapping(value={"/wfBeginSignTask"})
    public ResultDto<Integer> wfBeginSignTask(@Valid @RequestBody WfSignTaskDTO dto) {
        boolean result = this.joinCoreService.beginSignTask(dto.getStTaskId());
        return new ResultDto((Object)(result ? 1 : 0));
    }

    @PostMapping(value={"/wfReBeginSignTask"})
    public ResultDto<WfiSignTask> wfReBeginSignTask(@Valid @RequestBody WfSignTaskDTO dto) {
        WfiSignTask signTask = this.joinCoreService.reBeginSignTask(dto.getStTaskId());
        return new ResultDto((Object)signTask);
    }

    @PostMapping(value={"/wfFinishSignTask"})
    public ResultDto<Integer> wfFinishSignTask(@Valid @RequestBody WfSignTaskDTO dto) {
        boolean result = this.joinCoreService.finishSignTask(dto.getStTaskId());
        return new ResultDto((Object)(result ? 1 : 0));
    }

    @PostMapping(value={"/wfCancleSignTask"})
    public ResultDto<Integer> wfCancleSignTask(@Valid @RequestBody WfSignTaskDTO dto) {
        WfiSignTask task = this.joinCoreService.cancleSignTask(dto.getStTaskId());
        if (task != null) {
            this.coreService.wfTakeBack(new TakeBackDTO(dto.getSessionInstuCde(), task.getWfiInstanceId(), dto.getSessionLoginCode(), new HashMap()));
        }
        return new ResultDto((Object)(task != null ? 1 : 0));
    }

    @PostMapping(value={"/wfEndSignTask"})
    public ResultDto<Integer> wfEndSignTask(@Valid @RequestBody WfSignTaskDTO dto) {
        WfiSignTask task = this.joinCoreService.endSignTask(dto.getStTaskId());
        if (task != null) {
            this.coreService.wfSaveComment(new SaveCommentDTO(dto.getSessionInstuCde(), task.getWfiAdviceId(), task.getWfiInstanceId(), task.getWfiNodeId(), dto.getSessionLoginCode(), task.getStResult(), task.getStAdvice(), task.getStExeOrg()));
            this.joinCoreService.updateWf4Sign(dto.getStTaskId());
        }
        return new ResultDto((Object)(task != null ? 1 : 0));
    }

    @GetMapping(value={"/wfGetSignTaskVoteInfosByModel"})
    public ResultDto<List<EchainJoinSignVoteDTO>> wfGetSignTaskVoteInfosByModel(QueryModel query) {
        List<EchainJoinSignVoteDTO> votes = this.joinCoreService.selectSignTaskVoteInfosByModel(query);
        return new ResultDto(votes);
    }

    @PostMapping(value={"/wfGetSignVoteInfo"})
    public ResultDto<EchainJoinSignVoteDTO> wfGetSignVoteInfo(@Valid @RequestBody WfGetSignVoteInfoDTO dto) {
        EchainJoinSignVoteDTO voteInfo = this.joinCoreService.selectSignVoteInfo(dto.getSvVoteId());
        return new ResultDto((Object)voteInfo);
    }

    @PostMapping(value={"/wfSubmitSignVote"})
    public ResultDto<List<Integer>> wfSubmitSignVote(@Valid @RequestBody WfSubmitSignVote dto) {
        this.joinCoreService.submitSignVote(dto.getSvVoteId(), dto.getSvResult(), dto.getSvAdvice());
        return new ResultDto();
    }

    @PostMapping(value={"/wfCheckAsynSub"})
    public ResultDto<String> wfCheckAsynSub(@Valid @RequestBody WfCheckAsynSubDTO dto) {
        String hashSub = "0";
        Long count = this.joinCoreService.selectWfAsynSubCount(dto.getInstanceId(), dto.getNodeId());
        if (count != null && count > 0L) {
            hashSub = "1";
        }
        return new ResultDto((Object)hashSub);
    }

    @GetMapping(value={"/wfGetFreeDays"})
    public ResultDto<List<Integer>> wfGetFreeDays(@RequestParam(value="year") String year, @RequestParam(value="month") String month) {
        String freeDays = this.coreService.wfGetFreeDateByYear(year);
        return new ResultDto(this.getFreeDaysByMonth(freeDays, year, month));
    }

    @PostMapping(value={"/wfFreeDateInit"})
    public ResultDto<String> wfFreeDateInit(@RequestBody WfFreeDateDTO dto) {
        String freeDays = this.coreService.wfFreeDateInit(dto.getYear());
        return new ResultDto((Object)freeDays);
    }

    @PostMapping(value={"/wfFreeDateSetFreeDate"})
    public ResultDto<List<Integer>> wfFreeDateSetFreeDate(@RequestBody WfFreeDateDTO dto) {
        String freeDays = this.coreService.wfFreeDateSetFreeDate(dto.getYear() + dto.getMonth() + dto.getDay());
        List<Integer> list = this.getFreeDaysByMonth(freeDays, dto.getYear(), dto.getMonth());
        return new ResultDto(list);
    }

    @PostMapping(value={"/wfFreeDateSetWorkDate"})
    public ResultDto<List<Integer>> wfFreeDateSetWorkDate(@RequestBody WfFreeDateDTO dto) {
        String freeDays = this.coreService.freeDateSetWorkDate(dto.getYear() + dto.getMonth() + dto.getDay());
        List<Integer> list = this.getFreeDaysByMonth(freeDays, dto.getYear(), dto.getMonth());
        return new ResultDto(list);
    }

    protected List<Integer> getFreeDaysByMonth(String freeDays, String year, String month) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (freeDays != null) {
            String[] freeDayStrs;
            for (String freeDayStr : freeDayStrs = freeDays.split(",")) {
                String freeMonth;
                if (freeDayStr.length() != 10 || !(freeMonth = freeDayStr.substring(5, 7)).equals(month)) continue;
                String day = freeDayStr.substring(7, 9);
                list.add(Integer.valueOf(day));
            }
        }
        return list;
    }
}

